/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.google.material.utils;

import io.homo.superresolution.core.gui.google.material.utils.MathUtils;

public class ColorUtils {
    static final double[][] SRGB_TO_XYZ = new double[][]{{0.41233895, 0.35762064, 0.18051042}, {0.2126, 0.7152, 0.0722}, {0.01932141, 0.11916382, 0.95034478}};
    static final double[][] XYZ_TO_SRGB = new double[][]{{3.2413774792388685, -1.5376652402851851, -0.49885366846268053}, {-0.9691452513005321, 1.8758853451067872, 0.04156585616912061}, {0.05562093689691305, -0.20395524564742123, 1.0571799111220335}};
    static final double[] WHITE_POINT_D65 = new double[]{95.047, 100.0, 108.883};

    private ColorUtils() {
    }

    public static int argbFromRgb(int red, int green, int blue) {
        return 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    public static int argbFromLinrgb(double[] linrgb) {
        int r = ColorUtils.delinearized(linrgb[0]);
        int g = ColorUtils.delinearized(linrgb[1]);
        int b = ColorUtils.delinearized(linrgb[2]);
        return ColorUtils.argbFromRgb(r, g, b);
    }

    public static int alphaFromArgb(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static int redFromArgb(int argb) {
        return argb >> 16 & 0xFF;
    }

    public static int greenFromArgb(int argb) {
        return argb >> 8 & 0xFF;
    }

    public static int blueFromArgb(int argb) {
        return argb & 0xFF;
    }

    public static boolean isOpaque(int argb) {
        return ColorUtils.alphaFromArgb(argb) >= 255;
    }

    public static int argbFromXyz(double x, double y, double z) {
        double[][] matrix = XYZ_TO_SRGB;
        double linearR = matrix[0][0] * x + matrix[0][1] * y + matrix[0][2] * z;
        double linearG = matrix[1][0] * x + matrix[1][1] * y + matrix[1][2] * z;
        double linearB = matrix[2][0] * x + matrix[2][1] * y + matrix[2][2] * z;
        int r = ColorUtils.delinearized(linearR);
        int g = ColorUtils.delinearized(linearG);
        int b = ColorUtils.delinearized(linearB);
        return ColorUtils.argbFromRgb(r, g, b);
    }

    public static double[] xyzFromArgb(int argb) {
        double r = ColorUtils.linearized(ColorUtils.redFromArgb(argb));
        double g = ColorUtils.linearized(ColorUtils.greenFromArgb(argb));
        double b = ColorUtils.linearized(ColorUtils.blueFromArgb(argb));
        return MathUtils.matrixMultiply(new double[]{r, g, b}, SRGB_TO_XYZ);
    }

    public static int argbFromLab(double l, double a, double b) {
        double[] whitePoint = WHITE_POINT_D65;
        double fy = (l + 16.0) / 116.0;
        double fx = a / 500.0 + fy;
        double fz = fy - b / 200.0;
        double xNormalized = ColorUtils.labInvf(fx);
        double yNormalized = ColorUtils.labInvf(fy);
        double zNormalized = ColorUtils.labInvf(fz);
        double x = xNormalized * whitePoint[0];
        double y = yNormalized * whitePoint[1];
        double z = zNormalized * whitePoint[2];
        return ColorUtils.argbFromXyz(x, y, z);
    }

    public static double[] labFromArgb(int argb) {
        double linearR = ColorUtils.linearized(ColorUtils.redFromArgb(argb));
        double linearG = ColorUtils.linearized(ColorUtils.greenFromArgb(argb));
        double linearB = ColorUtils.linearized(ColorUtils.blueFromArgb(argb));
        double[][] matrix = SRGB_TO_XYZ;
        double x = matrix[0][0] * linearR + matrix[0][1] * linearG + matrix[0][2] * linearB;
        double y = matrix[1][0] * linearR + matrix[1][1] * linearG + matrix[1][2] * linearB;
        double z = matrix[2][0] * linearR + matrix[2][1] * linearG + matrix[2][2] * linearB;
        double[] whitePoint = WHITE_POINT_D65;
        double xNormalized = x / whitePoint[0];
        double yNormalized = y / whitePoint[1];
        double zNormalized = z / whitePoint[2];
        double fx = ColorUtils.labF(xNormalized);
        double fy = ColorUtils.labF(yNormalized);
        double fz = ColorUtils.labF(zNormalized);
        double l = 116.0 * fy - 16.0;
        double a = 500.0 * (fx - fy);
        double b = 200.0 * (fy - fz);
        return new double[]{l, a, b};
    }

    public static int argbFromLstar(double lstar) {
        double y = ColorUtils.yFromLstar(lstar);
        int component = ColorUtils.delinearized(y);
        return ColorUtils.argbFromRgb(component, component, component);
    }

    public static double lstarFromArgb(int argb) {
        double y = ColorUtils.xyzFromArgb(argb)[1];
        return 116.0 * ColorUtils.labF(y / 100.0) - 16.0;
    }

    public static double yFromLstar(double lstar) {
        return 100.0 * ColorUtils.labInvf((lstar + 16.0) / 116.0);
    }

    public static double lstarFromY(double y) {
        return ColorUtils.labF(y / 100.0) * 116.0 - 16.0;
    }

    public static double linearized(int rgbComponent) {
        double normalized = (double)rgbComponent / 255.0;
        if (normalized <= 0.040449936) {
            return normalized / 12.92 * 100.0;
        }
        return Math.pow((normalized + 0.055) / 1.055, 2.4) * 100.0;
    }

    public static int delinearized(double rgbComponent) {
        double normalized = rgbComponent / 100.0;
        double delinearized = 0.0;
        delinearized = normalized <= 0.0031308 ? normalized * 12.92 : 1.055 * Math.pow(normalized, 0.4166666666666667) - 0.055;
        return MathUtils.clampInt(0, 255, (int)Math.round(delinearized * 255.0));
    }

    public static double[] whitePointD65() {
        return WHITE_POINT_D65;
    }

    static double labF(double t) {
        double e = 0.008856451679035631;
        double kappa = 903.2962962962963;
        if (t > e) {
            return Math.pow(t, 0.3333333333333333);
        }
        return (kappa * t + 16.0) / 116.0;
    }

    static double labInvf(double ft) {
        double e = 0.008856451679035631;
        double kappa = 903.2962962962963;
        double ft3 = ft * ft * ft;
        if (ft3 > e) {
            return ft3;
        }
        return (116.0 * ft - 16.0) / kappa;
    }
}

