/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.widgets.button;

import io.homo.superresolution.core.gui.MaterialRipple;
import io.homo.superresolution.core.gui.MaterialSymbol;
import io.homo.superresolution.core.gui.core.UIInputState;
import io.homo.superresolution.core.gui.core.backends.interfaces.IPaint;
import io.homo.superresolution.core.gui.core.backends.interfaces.IUIDrawContext;
import io.homo.superresolution.core.gui.core.backends.interfaces.TextAlign;
import io.homo.superresolution.core.gui.core.backends.interfaces.TextAlignType;
import io.homo.superresolution.core.gui.core.backends.nanovg.NanoVG;
import io.homo.superresolution.core.gui.core.event.EventListener;
import io.homo.superresolution.core.gui.core.event.events.WidgetEvent;
import io.homo.superresolution.core.gui.core.impl.Rectangle;
import io.homo.superresolution.core.gui.widgets.MaterialWidget;
import io.homo.superresolution.core.gui.widgets.button.MaterialButtonAnimationSet;
import io.homo.superresolution.core.gui.widgets.button.MaterialButtonShape;
import io.homo.superresolution.core.gui.widgets.button.MaterialButtonSize;
import io.homo.superresolution.core.gui.widgets.button.MaterialButtonStyle;
import io.homo.superresolution.core.gui.widgets.button.MaterialButtonVariant;
import io.homo.superresolution.core.utils.Color;
import io.homo.superresolution.core.utils.MouseCursor;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.BezierInterpolator;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.PropertyValuesHolder;
import io.homo.superresolution.thirdparty.icyllis.modernui.animation.ValueAnimator;
import java.util.function.Supplier;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class MaterialButton
extends MaterialWidget<MaterialButton, MaterialButtonStyle, MaterialButtonAnimationSet> {
    private Supplier<String> textContextSupplier = () -> null;
    private MaterialRipple ripple;
    private Vector2f lastClickPosition;
    private Supplier<MaterialSymbol> iconContextSupplier = () -> null;
    private ValueAnimator hoverAnimator;
    private ValueAnimator pressAnimator;
    private ValueAnimator.AnimatorUpdateListener hoverUpdateListener;
    private ValueAnimator.AnimatorUpdateListener pressUpdateListener;

    public MaterialButton(MaterialButtonSize size) {
        this.style = new MaterialButtonStyle();
        this.ripple = new MaterialRipple();
        ((MaterialButtonStyle)this.style).size(size);
        this.getLayoutNode().setDebugName("MaterialButton");
        this.updateRectangle();
    }

    public static MaterialButton create(MaterialButtonSize size) {
        return new MaterialButton(size);
    }

    public static MaterialButton create() {
        return new MaterialButton(MaterialButtonSize.Medium);
    }

    public static MaterialButton create(Vector2f size) {
        float iconSizeRatio = 0.1f;
        float iconPaddingRatio = 0.038f;
        float paddingRatio = 0.1525f;
        float squareCornerSizeRatio = 0.07f;
        float pressedCornerSizeRatio = 0.049f;
        float fontSizeRatio = 0.076f;
        MaterialButtonSize buttonSize = new MaterialButtonSize(size.y, size.x * paddingRatio, size.x * iconPaddingRatio, 0.0f, size.x * squareCornerSizeRatio, size.x * pressedCornerSizeRatio, size.x * iconSizeRatio, size.x * fontSizeRatio);
        return new MaterialButton(buttonSize);
    }

    public void onClick(EventListener<WidgetEvent.ClickEvent> listener) {
        this.eventHandler.on(WidgetEvent.ClickEvent.class, listener);
    }

    @Override
    protected void init() {
        this.initAnimators();
        this.onHover(event -> this.onHover(event.getMousePosition(), event.isHovering()));
        this.onMouseRelease(event -> this.onRelease(event.getMousePosition()));
        this.onMousePress(event -> this.onPress(event.getMousePosition()));
    }

    private void initAnimators() {
        this.hoverAnimator = ValueAnimator.ofFloat(0.0f, 0.0f);
        this.hoverAnimator.setDuration(200L);
        this.hoverAnimator.setInterpolator(new BezierInterpolator(0.2f, 0.0f, 0.0f, 1.0f));
        this.pressAnimator = ValueAnimator.ofFloat(0.0f, 0.0f);
        this.pressAnimator.setDuration(200L);
        this.pressAnimator.setInterpolator(new BezierInterpolator(0.2f, 0.0f, 0.0f, 1.0f));
    }

    private void animateHoverTo(float targetValue, long duration) {
        if (this.hoverAnimator.isRunning()) {
            this.hoverAnimator.cancel();
        }
        this.hoverAnimator.setValues(PropertyValuesHolder.ofFloat(((Float)this.hoverAnimator.getAnimatedValue()).floatValue(), targetValue));
        this.hoverAnimator.setDuration(duration);
        this.hoverAnimator.start();
    }

    private void animatePressTo(float targetValue, long duration) {
        if (this.pressAnimator.isRunning()) {
            this.pressAnimator.cancel();
        }
        this.pressAnimator.setValues(PropertyValuesHolder.ofFloat(((Float)this.pressAnimator.getAnimatedValue()).floatValue(), targetValue));
        this.pressAnimator.setDuration(duration);
        this.pressAnimator.start();
    }

    public MaterialButtonSize size() {
        return ((MaterialButtonStyle)this.style).size();
    }

    public MaterialButton size(MaterialButtonSize size) {
        ((MaterialButtonStyle)this.style).size(size);
        this.updateRectangle();
        return this;
    }

    public MaterialButton text(String string) {
        this.textContextSupplier = () -> string;
        this.updateRectangle();
        return this;
    }

    public MaterialButton text(Supplier<String> supplier) {
        this.textContextSupplier = supplier;
        this.updateRectangle();
        return this;
    }

    public MaterialButton icon(MaterialSymbol icon) {
        this.iconContextSupplier = () -> icon;
        this.updateRectangle();
        return this;
    }

    public MaterialButton icon(Supplier<MaterialSymbol> supplier) {
        this.iconContextSupplier = supplier;
        this.updateRectangle();
        return this;
    }

    private void updateRectangle() {
        NanoVG.context.save();
        NanoVG.context.fontSize(this.size().fontSize());
        float textContextWidth = NanoVG.RENDERER.TEXT.measureTextWidth(this.textContextSupplier.get(), this.size().fontSize());
        NanoVG.context.restore();
        float iconContextWidth = 0.0f;
        if (this.iconContextSupplier.get() != null) {
            iconContextWidth = ((MaterialButtonStyle)this.style).size().iconSize();
        }
        float width = ((MaterialButtonStyle)this.style).size().padding() + iconContextWidth + (iconContextWidth == 0.0f ? 0.0f : ((MaterialButtonStyle)this.style).size().iconPadding()) + textContextWidth + ((MaterialButtonStyle)this.style).size().padding();
        this.setElementSize(width, ((MaterialButtonStyle)this.style).size().height());
    }

    @Override
    public void render(IUIDrawContext drawContext, UIInputState inputState) {
        drawContext.beginBatch();
        this.updateRectangle();
        this.ripple.update();
        Rectangle bounds = this.getBounds();
        ButtonColors colors = this.getButtonColors();
        float cornerSize = ((MaterialButtonStyle)this.style).shape() == MaterialButtonShape.Round ? bounds.height / 2.0f : ((MaterialButtonStyle)this.style).size().squareCornerSize();
        float deltaValue = ((MaterialButtonStyle)this.style).size().pressedCornerSize() - ((MaterialButtonStyle)this.style).size().squareCornerSize();
        cornerSize += ((Float)this.pressAnimator.getAnimatedValue()).floatValue() * deltaValue;
        if (colors.backgroundColor != null) {
            drawContext.drawRoundedRect(bounds.x, bounds.y, bounds.width, bounds.height, cornerSize, colors.backgroundColor, true);
        }
        if (colors.coverColor != null) {
            drawContext.drawRoundedRect(bounds.x, bounds.y, bounds.width, bounds.height, cornerSize, colors.coverColor, true);
        }
        if (colors.borderColor != null) {
            drawContext.strokeWidth(1.0f);
            drawContext.drawRoundedRect(bounds.x, bounds.y, bounds.width, bounds.height, cornerSize, colors.borderColor, false);
        }
        if (this.ripple.shouldRender() || this.ripple.isPressed()) {
            IPaint[] ripplePaints;
            for (IPaint paint : ripplePaints = this.ripple.getPaints(((MaterialButtonStyle)this.style).variant() == MaterialButtonVariant.Elevated ? this.scheme.primary() : (((MaterialButtonStyle)this.style).variant() == MaterialButtonVariant.Filled ? this.scheme.onPrimary() : (((MaterialButtonStyle)this.style).variant() == MaterialButtonVariant.Tonal ? this.scheme.onSecondaryContainer() : (((MaterialButtonStyle)this.style).variant() == MaterialButtonVariant.Text ? this.scheme.primary() : this.scheme.onSurfaceVariant()))), drawContext, bounds.getPosition(), bounds.getSize())) {
                if (paint == null) continue;
                drawContext.beginPath();
                drawContext.paint(paint);
                drawContext.roundedRect(bounds.x, bounds.y, bounds.width, bounds.height, cornerSize);
                drawContext.endPath();
            }
        }
        float iconContextWidth = 0.0f;
        if (this.iconContextSupplier.get() != null && colors.iconColor != null) {
            iconContextWidth = ((MaterialButtonStyle)this.style).size().iconSize();
            this.iconContextSupplier.get().render(drawContext, colors.iconColor, ((MaterialButtonStyle)this.style).size().iconSize(), new Vector2f(bounds.x + this.size().padding() + ((MaterialButtonStyle)this.style).size().iconSize() / 2.0f, bounds.getCenterY()));
        }
        drawContext.drawAlignedText(drawContext.font(), this.size().fontSize(), this.textContextSupplier.get(), bounds.x + this.size().padding() + iconContextWidth + (iconContextWidth == 0.0f ? 0.0f : ((MaterialButtonStyle)this.style).size().iconPadding()), bounds.getCenterY(), bounds.width, 20.0f, colors.textColor, TextAlign.of(TextAlignType.ALIGN_LEFT, TextAlignType.ALIGN_MIDDLE), false);
        drawContext.endBatch(this.getZIndex());
    }

    private ButtonColors getButtonColors() {
        ButtonColors colors = new ButtonColors();
        switch (((MaterialButtonStyle)this.style).variant()) {
            case Elevated: {
                if (this.isHovered() || this.hoverAnimator != null && this.hoverAnimator.isRunning()) {
                    colors.coverColor = this.scheme.primary().copy().alpha((int)((double)(255.0f * ((Float)this.hoverAnimator.getAnimatedValue()).floatValue()) * 0.08));
                }
                colors.backgroundColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(25) : this.scheme.surfaceContainerLow();
                colors.textColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(96) : this.scheme.primary();
                colors.iconColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(96) : this.scheme.primary();
                break;
            }
            case Filled: {
                if (this.isHovered() || this.hoverAnimator != null && this.hoverAnimator.isRunning()) {
                    colors.coverColor = this.scheme.onPrimary().copy().alpha((int)((double)(255.0f * ((Float)this.hoverAnimator.getAnimatedValue()).floatValue()) * 0.08));
                }
                colors.backgroundColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(25) : this.scheme.primary();
                colors.textColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(96) : this.scheme.onPrimary();
                colors.iconColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(96) : this.scheme.onPrimary();
                break;
            }
            case Tonal: {
                if (this.isHovered() || this.hoverAnimator != null && this.hoverAnimator.isRunning()) {
                    colors.coverColor = this.scheme.onSecondaryContainer().copy().alpha((int)((double)(255.0f * ((Float)this.hoverAnimator.getAnimatedValue()).floatValue()) * 0.08));
                }
                colors.backgroundColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(25) : this.scheme.secondaryContainer();
                colors.textColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(96) : this.scheme.onSecondaryContainer();
                colors.iconColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(96) : this.scheme.onSecondaryContainer();
                break;
            }
            case Text: {
                if (this.isHovered() || this.hoverAnimator != null && this.hoverAnimator.isRunning()) {
                    colors.coverColor = this.scheme.primary().copy().alpha((int)((double)(255.0f * ((Float)this.hoverAnimator.getAnimatedValue()).floatValue()) * 0.08));
                }
                colors.backgroundColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(25) : null;
                colors.textColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(96) : this.scheme.primary();
                colors.iconColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(96) : this.scheme.primary();
                break;
            }
            case Outlined: {
                if (this.isHovered() || this.hoverAnimator != null && this.hoverAnimator.isRunning()) {
                    colors.coverColor = this.scheme.onSurfaceVariant().copy().alpha((int)((double)(255.0f * ((Float)this.hoverAnimator.getAnimatedValue()).floatValue()) * 0.08));
                }
                colors.backgroundColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(25) : null;
                colors.borderColor = this.scheme.outlineVariant();
                colors.textColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(96) : this.scheme.onSurfaceVariant();
                colors.iconColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(96) : this.scheme.onSurfaceVariant();
                break;
            }
            default: {
                colors.backgroundColor = this.scheme.primary();
                colors.textColor = this.scheme.primary();
            }
        }
        return colors;
    }

    private void onHover(Vector2f mousePosition, boolean hover) {
        if (hover) {
            this.animateHoverTo(1.0f, 200L);
            MouseCursor.HAND.use();
        } else {
            this.animateHoverTo(0.0f, 200L);
            MouseCursor.ARROW.use();
        }
    }

    @Override
    protected boolean isInteractive() {
        return true;
    }

    private void onPress(Vector2f mousePosition) {
        this.animateHoverTo(1.25f, 200L);
        this.animatePressTo(1.0f, 200L);
        this.lastClickPosition = new Vector2f((Vector2fc)mousePosition);
        this.ripple.setPressed(true, this.lastClickPosition, this.getBounds());
        this.eventHandler.fire(new WidgetEvent.ClickEvent());
    }

    private void onRelease(Vector2f mousePosition) {
        float targetHoverValue = this.isHovered() ? 1.0f : 0.0f;
        this.animateHoverTo(targetHoverValue, 200L);
        this.animatePressTo(0.0f, 200L);
        this.ripple.setPressed(false, this.lastClickPosition, this.getBounds());
    }

    @Override
    public void destroy() {
        if (this.hoverAnimator != null) {
            if (this.hoverUpdateListener != null) {
                this.hoverAnimator.removeUpdateListener(this.hoverUpdateListener);
                this.hoverUpdateListener = null;
            }
            if (this.hoverAnimator.isRunning()) {
                this.hoverAnimator.cancel();
            }
            this.hoverAnimator = null;
        }
        if (this.pressAnimator != null) {
            if (this.pressUpdateListener != null) {
                this.pressAnimator.removeUpdateListener(this.pressUpdateListener);
                this.pressUpdateListener = null;
            }
            if (this.pressAnimator.isRunning()) {
                this.pressAnimator.cancel();
            }
            this.pressAnimator = null;
        }
        if (this.ripple != null) {
            this.ripple.destroy();
            this.ripple = null;
        }
    }

    private static class ButtonColors {
        Color coverColor;
        Color backgroundColor;
        Color textColor;
        Color borderColor;
        Color iconColor;

        private ButtonColors() {
        }
    }
}

