/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.icyllis.modernui.core;

import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.thirdparty.icyllis.modernui.annotation.NonNull;
import io.homo.superresolution.thirdparty.icyllis.modernui.annotation.Nullable;
import io.homo.superresolution.thirdparty.icyllis.modernui.core.Core;
import io.homo.superresolution.thirdparty.icyllis.modernui.core.Handler;
import io.homo.superresolution.thirdparty.icyllis.modernui.core.Message;
import java.util.ArrayList;
import java.util.concurrent.locks.LockSupport;
import javax.annotation.concurrent.GuardedBy;
import org.lwjgl.glfw.GLFW;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public final class MessageQueue {
    private static final Marker MARKER = MarkerFactory.getMarker((String)"MessageQueue");
    private static final boolean DEBUG = false;
    private final Thread mThread;
    @GuardedBy(value="this")
    Message mMessages;
    @GuardedBy(value="this")
    private final ArrayList<IdleHandler> mIdleHandlers = new ArrayList();
    private IdleHandler[] mPendingIdleHandlers;
    @GuardedBy(value="this")
    private boolean mQuitting;
    private volatile boolean mPolling;
    @GuardedBy(value="this")
    private boolean mBlocked;
    private boolean mDisposed;
    @GuardedBy(value="this")
    private int mNextBarrierToken;

    MessageQueue(Thread thread) {
        this.mThread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            long now = Core.timeMillis();
            return this.mMessages == null || now < this.mMessages.when;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleHandler(@NonNull IdleHandler handler) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdleHandler(@NonNull IdleHandler handler) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPolling() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            return !this.mQuitting && this.mPolling;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    Message next() {
        if (this.mDisposed) {
            return null;
        }
        int pendingIdleHandlerCount = -1;
        int nextPollTimeoutMillis = 0;
        while (true) {
            if (this.mThread == null) {
                this.mPolling = true;
                if (nextPollTimeoutMillis < 0) {
                    GLFW.glfwWaitEvents();
                } else if (nextPollTimeoutMillis == 0) {
                    GLFW.glfwPollEvents();
                } else {
                    GLFW.glfwWaitEventsTimeout((double)((double)nextPollTimeoutMillis / 1000.0));
                }
                this.mPolling = false;
            } else {
                this.mPolling = true;
                if (nextPollTimeoutMillis < 0) {
                    LockSupport.park();
                } else if (nextPollTimeoutMillis > 0) {
                    LockSupport.parkNanos((long)nextPollTimeoutMillis * 1000000L);
                }
                this.mPolling = false;
            }
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                long now;
                block29: {
                    now = Core.timeMillis();
                    Message prevMsg = null;
                    Message msg = this.mMessages;
                    if (msg != null && msg.target == null) {
                        do {
                            prevMsg = msg;
                        } while ((msg = msg.next) != null && !msg.isAsynchronous());
                    }
                    if (msg != null) {
                        if (now < msg.when) {
                            nextPollTimeoutMillis = (int)Math.min(msg.when - now, Integer.MAX_VALUE);
                            break block29;
                        } else {
                            this.mBlocked = false;
                            if (prevMsg != null) {
                                prevMsg.next = msg.next;
                            } else {
                                this.mMessages = msg.next;
                            }
                            msg.next = null;
                            msg.markInUse();
                            return msg;
                        }
                    }
                    nextPollTimeoutMillis = -1;
                }
                if (this.mQuitting) {
                    this.mDisposed = true;
                    return null;
                }
                if (pendingIdleHandlerCount < 0 && (this.mMessages == null || now < this.mMessages.when)) {
                    pendingIdleHandlerCount = this.mIdleHandlers.size();
                }
                if (pendingIdleHandlerCount <= 0) {
                    this.mBlocked = true;
                    continue;
                }
                if (this.mPendingIdleHandlers == null) {
                    this.mPendingIdleHandlers = new IdleHandler[Math.max(pendingIdleHandlerCount, 4)];
                }
                this.mPendingIdleHandlers = this.mIdleHandlers.toArray(this.mPendingIdleHandlers);
            }
            for (int i = 0; i < pendingIdleHandlerCount; ++i) {
                IdleHandler idler = this.mPendingIdleHandlers[i];
                this.mPendingIdleHandlers[i] = null;
                boolean keep = false;
                try {
                    keep = idler.queueIdle();
                }
                catch (Throwable t) {
                    SuperResolution.LOGGER.info(MARKER, "IdleHandler threw exception", t);
                }
                if (keep) continue;
                MessageQueue messageQueue2 = this;
                synchronized (messageQueue2) {
                    this.mIdleHandlers.remove(idler);
                    continue;
                }
            }
            pendingIdleHandlerCount = 0;
            nextPollTimeoutMillis = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void quit(boolean safe) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.mQuitting) {
                return;
            }
            this.mQuitting = true;
            if (safe) {
                this.removeAllFutureMessagesLocked();
            } else {
                this.removeAllMessagesLocked();
            }
            if (this.mThread == null) {
                GLFW.glfwPostEmptyEvent();
            } else {
                LockSupport.unpark(this.mThread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int postSyncBarrier() {
        long when = Core.timeMillis();
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            int token = this.mNextBarrierToken++;
            Message msg = Message.obtain();
            msg.markInUse();
            msg.when = when;
            msg.arg1 = token;
            Message prev = null;
            Message p = this.mMessages;
            if (when != 0L) {
                while (p != null && p.when <= when) {
                    prev = p;
                    p = p.next;
                }
            }
            msg.next = p;
            if (prev != null) {
                prev.next = msg;
            } else {
                this.mMessages = msg;
            }
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSyncBarrier(int token) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            Message prev = null;
            Message p = this.mMessages;
            while (p != null && (p.target != null || p.arg1 != token)) {
                prev = p;
                p = p.next;
            }
            if (p == null) {
                throw new IllegalStateException("The specified message queue synchronization  barrier token has not been posted or has already been removed.");
            }
            if (prev != null) {
                prev.next = p.next;
                needWake = false;
            } else {
                this.mMessages = p.next;
                needWake = this.mMessages == null || this.mMessages.target != null;
            }
            p.recycleUnchecked();
            if (needWake && !this.mQuitting) {
                if (this.mThread == null) {
                    GLFW.glfwPostEmptyEvent();
                } else {
                    LockSupport.unpark(this.mThread);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueueMessage(@NonNull Message msg, long when) {
        if (msg.target == null) {
            throw new IllegalArgumentException("Message must have a target.");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            if (msg.isInUse()) {
                throw new IllegalStateException(String.valueOf(msg) + " This message is already in use.");
            }
            if (this.mQuitting) {
                IllegalStateException e = new IllegalStateException(String.valueOf(msg.target) + " sending message to a Handler on a dead thread");
                SuperResolution.LOGGER.warn(MARKER, e.getMessage(), (Throwable)e);
                msg.recycle();
                return false;
            }
            msg.markInUse();
            msg.when = when;
            Message p = this.mMessages;
            if (p == null || when == 0L || when < p.when) {
                msg.next = p;
                this.mMessages = msg;
                needWake = this.mBlocked;
            } else {
                needWake = this.mBlocked && p.target == null && msg.isAsynchronous();
                while (true) {
                    Message prev = p;
                    p = p.next;
                    if (p == null || when < p.when) break;
                    if (!needWake || !p.isAsynchronous()) continue;
                    needWake = false;
                }
                msg.next = p;
                prev.next = msg;
            }
            if (needWake) {
                if (this.mThread == null) {
                    GLFW.glfwPostEmptyEvent();
                } else {
                    LockSupport.unpark(this.mThread);
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasMessages(Handler h, int what, Object object) {
        if (h == null) {
            return false;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.what == what && (object == null || p.obj == object)) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasMessages(@NonNull Handler h, Runnable r) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.callback == r) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasMessages(@NonNull Handler h) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessages(@NonNull Handler h, int what, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.what == what && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycleUnchecked();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.what == what && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycleUnchecked();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMessages(@NonNull Handler h, Runnable r, Object object) {
        if (r == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.callback == r && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycleUnchecked();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.callback == r && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycleUnchecked();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCallbacksAndMessages(@NonNull Handler h, Object object) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycleUnchecked();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycleUnchecked();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    private void removeAllMessagesLocked() {
        Message p = this.mMessages;
        while (p != null) {
            Message n = p.next;
            p.recycleUnchecked();
            p = n;
        }
        this.mMessages = null;
    }

    private void removeAllFutureMessagesLocked() {
        long now = Core.timeMillis();
        Message p = this.mMessages;
        if (p != null) {
            if (p.when > now) {
                this.removeAllMessagesLocked();
            } else {
                Message n;
                while (true) {
                    if ((n = p.next) == null) {
                        return;
                    }
                    if (n.when > now) break;
                    p = n;
                }
                p.next = null;
                do {
                    p = n;
                    n = p.next;
                    p.recycleUnchecked();
                } while (n != null);
            }
        }
    }

    @FunctionalInterface
    public static interface IdleHandler {
        public boolean queueIdle();
    }
}

