/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.node;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaConstants;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDimension;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaPhysicalEdge;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.node.CachedMeasurement;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.FloatOptional;
import java.util.Arrays;
import java.util.Objects;

public class LayoutResults {
    public static final int MAX_CACHED_MEASUREMENTS = 8;
    private YogaDirection direction = YogaDirection.INHERIT;
    private boolean hadOverflow = false;
    private final float[] dimensions = new float[]{Float.NaN, Float.NaN};
    private final float[] measuredDimensions = new float[]{Float.NaN, Float.NaN};
    private final float[] position = new float[4];
    private final float[] margin = new float[4];
    private final float[] border = new float[4];
    private final float[] padding = new float[4];
    public long computedFlexBasisGeneration = 0L;
    public FloatOptional computedFlexBasis = FloatOptional.of(Float.NaN);
    public int generationCount = 0;
    public int configVersion = 0;
    public YogaDirection lastOwnerDirection = YogaDirection.INHERIT;
    public int nextCachedMeasurementsIndex = 0;
    public final CachedMeasurement[] cachedMeasurements = new CachedMeasurement[8];
    public CachedMeasurement cachedLayout = new CachedMeasurement();

    public LayoutResults() {
        for (int i = 0; i < 8; ++i) {
            this.cachedMeasurements[i] = new CachedMeasurement();
        }
    }

    public LayoutResults(LayoutResults other) {
        this.direction = other.direction;
        this.hadOverflow = other.hadOverflow;
        System.arraycopy(other.dimensions, 0, this.dimensions, 0, this.dimensions.length);
        System.arraycopy(other.measuredDimensions, 0, this.measuredDimensions, 0, this.measuredDimensions.length);
        System.arraycopy(other.position, 0, this.position, 0, this.position.length);
        System.arraycopy(other.margin, 0, this.margin, 0, this.margin.length);
        System.arraycopy(other.border, 0, this.border, 0, this.border.length);
        System.arraycopy(other.padding, 0, this.padding, 0, this.padding.length);
        this.computedFlexBasisGeneration = other.computedFlexBasisGeneration;
        this.computedFlexBasis = other.computedFlexBasis;
        this.generationCount = other.generationCount;
        this.configVersion = other.configVersion;
        this.lastOwnerDirection = other.lastOwnerDirection;
        this.nextCachedMeasurementsIndex = other.nextCachedMeasurementsIndex;
        for (int i = 0; i < 8; ++i) {
            if (other.cachedMeasurements[i] == null) continue;
            this.cachedMeasurements[i] = new CachedMeasurement(other.cachedMeasurements[i]);
        }
        this.cachedLayout = new CachedMeasurement(other.cachedLayout);
    }

    public YogaDirection direction() {
        return this.direction;
    }

    public void setDirection(YogaDirection direction) {
        this.direction = direction;
    }

    public boolean hadOverflow() {
        return this.hadOverflow;
    }

    public void setHadOverflow(boolean hadOverflow) {
        this.hadOverflow = hadOverflow;
    }

    public float dimension(YogaDimension axis) {
        return this.dimensions[axis.ordinal()];
    }

    public void setDimension(YogaDimension axis, float dimension) {
        this.dimensions[axis.ordinal()] = dimension;
    }

    public float measuredDimension(YogaDimension axis) {
        return this.measuredDimensions[axis.ordinal()];
    }

    public void setMeasuredDimension(YogaDimension axis, float dimension) {
        this.measuredDimensions[axis.ordinal()] = dimension;
    }

    public float position(YogaPhysicalEdge physicalEdge) {
        return this.position[physicalEdge.ordinal()];
    }

    public void setPosition(YogaPhysicalEdge physicalEdge, float dimension) {
        this.position[physicalEdge.ordinal()] = dimension;
    }

    public float margin(YogaPhysicalEdge physicalEdge) {
        return this.margin[physicalEdge.ordinal()];
    }

    public void setMargin(YogaPhysicalEdge physicalEdge, float dimension) {
        this.margin[physicalEdge.ordinal()] = dimension;
    }

    public float border(YogaPhysicalEdge physicalEdge) {
        return this.border[physicalEdge.ordinal()];
    }

    public void setBorder(YogaPhysicalEdge physicalEdge, float dimension) {
        this.border[physicalEdge.ordinal()] = dimension;
    }

    public float padding(YogaPhysicalEdge physicalEdge) {
        return this.padding[physicalEdge.ordinal()];
    }

    public void setPadding(YogaPhysicalEdge physicalEdge, float dimension) {
        this.padding[physicalEdge.ordinal()] = dimension;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LayoutResults other = (LayoutResults)obj;
        boolean isEqual = this.direction == other.direction && this.hadOverflow == other.hadOverflow && Arrays.equals(this.position, other.position) && Arrays.equals(this.dimensions, other.dimensions) && Arrays.equals(this.margin, other.margin) && Arrays.equals(this.border, other.border) && Arrays.equals(this.padding, other.padding) && this.lastOwnerDirection == other.lastOwnerDirection && this.configVersion == other.configVersion && this.nextCachedMeasurementsIndex == other.nextCachedMeasurementsIndex && Objects.equals(this.cachedLayout, other.cachedLayout) && Objects.equals(this.computedFlexBasis, other.computedFlexBasis);
        for (int i = 0; i < 8 && isEqual; ++i) {
            isEqual = isEqual && Objects.equals(this.cachedMeasurements[i], other.cachedMeasurements[i]);
        }
        if (!YogaConstants.isUndefined(this.measuredDimensions[0]) || !YogaConstants.isUndefined(other.measuredDimensions[0])) {
            boolean bl = isEqual = isEqual && this.measuredDimensions[0] == other.measuredDimensions[0];
        }
        if (!YogaConstants.isUndefined(this.measuredDimensions[1]) || !YogaConstants.isUndefined(other.measuredDimensions[1])) {
            isEqual = isEqual && this.measuredDimensions[1] == other.measuredDimensions[1];
        }
        return isEqual;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.direction, this.hadOverflow, this.computedFlexBasis, this.generationCount, this.configVersion, this.lastOwnerDirection, this.nextCachedMeasurementsIndex, this.cachedLayout});
        result = 31 * result + Arrays.hashCode(this.dimensions);
        result = 31 * result + Arrays.hashCode(this.measuredDimensions);
        result = 31 * result + Arrays.hashCode(this.position);
        result = 31 * result + Arrays.hashCode(this.margin);
        result = 31 * result + Arrays.hashCode(this.border);
        result = 31 * result + Arrays.hashCode(this.padding);
        result = 31 * result + Arrays.hashCode(this.cachedMeasurements);
        return result;
    }

    public void reset() {
        this.direction = YogaDirection.INHERIT;
        this.hadOverflow = false;
        Arrays.fill(this.dimensions, Float.NaN);
        Arrays.fill(this.measuredDimensions, Float.NaN);
        Arrays.fill(this.position, 0.0f);
        Arrays.fill(this.margin, 0.0f);
        Arrays.fill(this.border, 0.0f);
        Arrays.fill(this.padding, 0.0f);
        this.computedFlexBasisGeneration = 0L;
        this.computedFlexBasis = FloatOptional.of(Float.NaN);
        this.generationCount = 0;
        this.configVersion = 0;
        this.lastOwnerDirection = YogaDirection.INHERIT;
        this.nextCachedMeasurementsIndex = 0;
        for (int i = 0; i < 8; ++i) {
            this.cachedMeasurements[i] = new CachedMeasurement();
        }
    }
}

