/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.api.platform;

import com.sun.jna.Platform;
import net.minecraft.class_2561;

public enum OperatingSystemType {
    ANDROID(8 == Platform.getOSType()),
    LINUX(1 == Platform.getOSType()),
    WINDOWS(2 == Platform.getOSType()),
    MACOS(0 == Platform.getOSType()),
    ANY(true);

    private final boolean isCurrentOS;

    private OperatingSystemType(boolean isCurrentOS) {
        this.isCurrentOS = isCurrentOS;
    }

    public static OperatingSystemType get() {
        if (OperatingSystemType.ANDROID.isCurrentOS || System.getenv("POJAV_RENDERER") != null) {
            return ANDROID;
        }
        if (OperatingSystemType.LINUX.isCurrentOS) {
            return LINUX;
        }
        if (OperatingSystemType.WINDOWS.isCurrentOS) {
            return WINDOWS;
        }
        if (OperatingSystemType.MACOS.isCurrentOS) {
            return MACOS;
        }
        return ANY;
    }

    public static boolean isCurrentOS(OperatingSystemType osType) {
        return osType.isCurrentOS;
    }

    public boolean equals(OperatingSystemType type) {
        return type == ANY || OperatingSystemType.get() == type;
    }

    public String getString() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case ANDROID -> "Android";
            case LINUX -> "Linux";
            case WINDOWS -> "Windows";
            case MACOS -> "MacOS";
            case ANY -> class_2561.method_43471((String)"superresolution.requirement.os.any").getString();
        };
    }
}

