/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.upscale.sgsr.v2;

import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.core.graphics.impl.buffer.IBufferData;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.lwjgl.system.MemoryUtil;

public class SgsrParams
implements IBufferData {
    private final ByteBuffer container = MemoryUtil.memCalloc((int)((int)this.size()));
    private int sameFrameNum = 0;
    private Matrix4f prev_view_proj_matrix;

    private static boolean isCameraStill(Matrix4f currentMVP, Matrix4f prevMVP, float threshold) {
        float diff = 0.0f;
        for (int r = 0; r < 4; ++r) {
            for (int c = 0; c < 4; ++c) {
                diff += Math.abs(currentMVP.get(r, c) - prevMVP.get(r, c));
            }
        }
        return diff < threshold;
    }

    public void setRenderSize(Vector2f renderSize) {
        this.container.putInt(0, (int)renderSize.x);
        this.container.putInt(4, (int)renderSize.y);
    }

    public void setDisplaySize(Vector2f displaySize) {
        this.container.putInt(8, (int)displaySize.x);
        this.container.putInt(12, (int)displaySize.y);
    }

    public void setRenderSizeRcp(Vector2f renderSizeRcp) {
        this.container.putFloat(16, renderSizeRcp.x);
        this.container.putFloat(20, renderSizeRcp.y);
    }

    public void setDisplaySizeRcp(Vector2f displaySizeRcp) {
        this.container.putFloat(24, displaySizeRcp.x);
        this.container.putFloat(28, displaySizeRcp.y);
    }

    public void setJitterOffset(Vector2f jitterOffset) {
        this.container.putFloat(32, jitterOffset.x);
        this.container.putFloat(36, jitterOffset.y);
    }

    public void setClipToPrevClip(Matrix4f clipToPrevClip) {
        clipToPrevClip.get(48, this.container);
    }

    public void setPreExposure(float preExposure) {
        this.container.putFloat(112, preExposure);
    }

    public void setCameraFovAngleHor(float cameraFovAngleHor) {
        this.container.putFloat(116, cameraFovAngleHor);
    }

    public void setCameraNear(float cameraNear) {
        this.container.putFloat(120, cameraNear);
    }

    public void setMinLerpContribution(float minLerpContribution) {
        this.container.putFloat(124, minLerpContribution);
    }

    public void setbSameCamera(boolean bSameCamera) {
        this.container.putInt(128, bSameCamera ? 1 : 0);
    }

    public void setReset(boolean reset) {
        this.container.putInt(132, reset ? 1 : 0);
    }

    public void fillZero(int start, int end) {
        for (int i = start; i < end; ++i) {
            this.container.put(i, (byte)0);
        }
    }

    public void updateData(DispatchResource dispatchResource) {
        this.container.clear();
        this.setRenderSize(dispatchResource.renderSize());
        this.setDisplaySize(dispatchResource.screenSize());
        this.setRenderSizeRcp(new Vector2f().set(1.0f).div((Vector2fc)dispatchResource.renderSize()));
        this.setDisplaySizeRcp(new Vector2f().set(1.0f).div((Vector2fc)dispatchResource.screenSize()));
        this.setJitterOffset(new Vector2f(0.0f));
        this.fillZero(40, 48);
        Matrix4f curr_view_proj_matrix = new Matrix4f((Matrix4fc)dispatchResource.projectionMatrix()).mul((Matrix4fc)dispatchResource.viewMatrix());
        Matrix4f inv_current_view_proj_matrix = new Matrix4f((Matrix4fc)dispatchResource.viewMatrix()).invert().mul((Matrix4fc)new Matrix4f((Matrix4fc)dispatchResource.projectionMatrix()).invert());
        Matrix4f clipToPrevClipMat = new Matrix4f((Matrix4fc)dispatchResource.lastViewMatrix()).mul((Matrix4fc)inv_current_view_proj_matrix);
        this.setClipToPrevClip(clipToPrevClipMat);
        this.setPreExposure(1.2f);
        this.setCameraFovAngleHor(dispatchResource.horizontalFov());
        this.setCameraNear(dispatchResource.cameraNear());
        boolean isCameraStill = SgsrParams.isCameraStill(curr_view_proj_matrix, this.prev_view_proj_matrix == null ? curr_view_proj_matrix : this.prev_view_proj_matrix, 1.0E-5f);
        double MinLerpContribution = 0.0;
        if (isCameraStill) {
            ++this.sameFrameNum;
            if (this.sameFrameNum > 5) {
                MinLerpContribution = 0.3;
            }
            if (this.sameFrameNum == 65535) {
                this.sameFrameNum = 1;
            }
        } else {
            this.sameFrameNum = 0;
        }
        this.setMinLerpContribution((float)MinLerpContribution);
        this.setbSameCamera(isCameraStill);
        this.fillZero(136, 144);
        this.container.position(144);
        this.container.flip();
        this.prev_view_proj_matrix = new Matrix4f((Matrix4fc)curr_view_proj_matrix);
    }

    @Override
    public ByteBuffer container() {
        return this.container;
    }

    @Override
    public long size() {
        return 144L;
    }

    @Override
    public void free() {
        MemoryUtil.memFree((Buffer)this.container);
    }

    @Override
    public void put(byte[] src, long offset) {
        throw new RuntimeException();
    }

    @Override
    public void updatePartial(Buffer data, long offset, long length) {
        throw new RuntimeException();
    }

    @Override
    public void update(Buffer data) {
        throw new RuntimeException();
    }
}

