/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.pipeline;

import io.homo.superresolution.core.graphics.impl.command.ICommandBuffer;
import io.homo.superresolution.core.graphics.impl.pipeline.GpuComputeJob;
import io.homo.superresolution.core.graphics.impl.pipeline.IPipelineJob;
import io.homo.superresolution.core.graphics.impl.shader.IShaderProgram;
import java.util.Objects;
import java.util.function.Supplier;
import org.joml.Vector3i;

public class PipelineComputeJob
extends GpuComputeJob<PipelineComputeJob>
implements IPipelineJob {
    protected Supplier<Vector3i> workGroupSizeSupplier = null;
    protected IShaderProgram<?> program = null;

    public PipelineComputeJob workGroupSize(int x, int y, int z) {
        if (x <= 0 || y <= 0 || z <= 0) {
            throw new IllegalArgumentException("\u5de5\u4f5c\u7ec4\u5927\u5c0f\u5fc5\u987b\u5927\u4e8e0");
        }
        this.workGroupSizeSupplier = () -> new Vector3i(x, y, z);
        return this;
    }

    public PipelineComputeJob computeProgram(IShaderProgram<?> program) {
        this.program = Objects.requireNonNull(program, "\u8ba1\u7b97\u7740\u8272\u5668\u4e0d\u80fd\u4e3anull");
        return this;
    }

    public PipelineComputeJob workGroupSizeSupplier(Supplier<Vector3i> workGroupSizeSupplier) {
        this.workGroupSizeSupplier = Objects.requireNonNull(workGroupSizeSupplier, "\u5de5\u4f5c\u7ec4\u63d0\u4f9b\u5668\u4e0d\u80fd\u4e3anull");
        return this;
    }

    @Override
    public void execute(ICommandBuffer commandBuffer) {
        Objects.requireNonNull(this.workGroupSizeSupplier, "\u5de5\u4f5c\u7ec4\u5927\u5c0f\u63d0\u4f9b\u5668\u672a\u8bbe\u7f6e");
        Objects.requireNonNull(this.program, "\u8ba1\u7b97\u7740\u8272\u5668\u672a\u8bbe\u7f6e");
        this.setupProgramResources(this.program);
        Vector3i workGroup = this.workGroupSizeSupplier.get();
        if (workGroup.x <= 0 || workGroup.y <= 0 || workGroup.z <= 0) {
            throw new IllegalStateException("\u65e0\u6548\u7684\u5de5\u4f5c\u7ec4\u5927\u5c0f: " + String.valueOf(workGroup));
        }
        commandBuffer.getEncoder().dispatchCompute(commandBuffer, this.program, workGroup.x, workGroup.y, workGroup.z);
    }

    @Override
    public void destroy() {
        this.program = null;
        this.workGroupSizeSupplier = null;
    }
}

