/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui;

import io.homo.superresolution.common.minecraft.MinecraftWindow;
import io.homo.superresolution.core.gui.MaterialScheme;
import io.homo.superresolution.core.gui.MaterialTheme;
import io.homo.superresolution.core.gui.NanoVGScreen;
import io.homo.superresolution.core.gui.core.ContainerWidget;
import io.homo.superresolution.core.gui.core.UIInputState;
import io.homo.superresolution.core.gui.core.backends.interfaces.IUIDrawContext;
import io.homo.superresolution.core.gui.core.backends.interfaces.TextAlign;
import io.homo.superresolution.core.gui.core.backends.interfaces.TextAlignType;
import io.homo.superresolution.core.gui.core.impl.Rectangle;
import io.homo.superresolution.core.gui.widgets.MaterialScrollableContainerWidget;
import io.homo.superresolution.core.gui.widgets.button.MaterialButton;
import io.homo.superresolution.core.gui.widgets.button.MaterialButtonSize;
import io.homo.superresolution.core.gui.widgets.button.MaterialButtonStyle;
import io.homo.superresolution.core.gui.widgets.button.MaterialButtonVariant;
import io.homo.superresolution.core.utils.Color;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaAlign;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaEdge;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaFlexDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaGutter;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaJustify;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.test.CaptureTree;
import java.nio.file.Path;
import java.util.ArrayList;
import net.minecraft.class_2561;
import org.joml.Vector2f;

public class WidgetDesignScreen
extends NanoVGScreen<WidgetDesignScreen> {
    private ContainerWidget rootContainer;
    private MaterialScheme materialScheme;

    public WidgetDesignScreen(class_2561 title) {
        super(title);
    }

    private ContainerWidget createLine(int line) {
        ContainerWidget lineContainer = new ContainerWidget();
        lineContainer.setElementSize(400.0f, 60.0f);
        lineContainer.layout().setFlexDirection(YogaFlexDirection.ROW);
        lineContainer.layout().setJustifyContent(YogaJustify.SPACE_BETWEEN);
        lineContainer.layout().setAlignItems(YogaAlign.STRETCH);
        MaterialButton btnElevated = ((MaterialButton)MaterialButton.create().text("Elevated " + line).scheme(this.materialScheme)).size(MaterialButtonSize.ExtraSmall);
        ((MaterialButtonStyle)btnElevated.style()).variant(MaterialButtonVariant.Elevated);
        btnElevated.layout().setAlignSelf(YogaAlign.FLEX_START);
        MaterialButton btnFilled = ((MaterialButton)MaterialButton.create().text("Filled " + line).scheme(this.materialScheme)).size(MaterialButtonSize.Medium);
        ((MaterialButtonStyle)btnFilled.style()).variant(MaterialButtonVariant.Filled);
        btnFilled.layout().setAlignSelf(YogaAlign.CENTER);
        MaterialButton btnTonal = ((MaterialButton)MaterialButton.create().text("Tonal " + line).scheme(this.materialScheme)).size(MaterialButtonSize.ExtraSmall);
        ((MaterialButtonStyle)btnTonal.style()).variant(MaterialButtonVariant.Tonal);
        btnTonal.layout().setAlignSelf(YogaAlign.FLEX_END);
        lineContainer.addChild(btnElevated);
        lineContainer.addChild(btnFilled);
        lineContainer.addChild(btnTonal);
        return lineContainer;
    }

    @Override
    protected void buildWidgets() {
        this.materialScheme = MaterialScheme.from(MaterialTheme.Dark, Color.from("#6750A4"));
        this.rootContainer = new ContainerWidget();
        MaterialScrollableContainerWidget scrollableContainer = new MaterialScrollableContainerWidget();
        scrollableContainer.scheme(this.materialScheme);
        scrollableContainer.setElementSize(400.0f, 700.0f);
        scrollableContainer.setViewRegion(new Vector2f(400.0f, 700.0f));
        scrollableContainer.setHorizontalScrollEnabled(false);
        scrollableContainer.setVerticalScrollEnabled(true);
        scrollableContainer.layout().setFlexDirection(YogaFlexDirection.COLUMN);
        scrollableContainer.layout().setGap(YogaGutter.COLUMN, 4.0f);
        ArrayList<ContainerWidget> lines = new ArrayList<ContainerWidget>();
        for (int i = 0; i < 40; ++i) {
            ContainerWidget line = this.createLine(i);
            lines.add(line);
            scrollableContainer.addChild(line);
        }
        this.rootContainer.addChild(scrollableContainer);
        this.rootContainer.layout().setPosition(YogaEdge.LEFT, 0.0f);
        this.rootContainer.layout().setPosition(YogaEdge.TOP, 100.0f);
        Vector2f screenSize = MinecraftWindow.getWindowSize();
        this.rootContainer.setElementSize(screenSize.x, screenSize.y);
        this.rootContainer.getLayoutNode().setDebugName("Root");
        this.addWidget(this.rootContainer);
    }

    @Override
    public void draw(IUIDrawContext drawContext, UIInputState inputState) {
        int i;
        Vector2f screenSize = MinecraftWindow.getWindowSize();
        this.rootContainer.getLayoutNode().setWidth(screenSize.x);
        this.rootContainer.getLayoutNode().setHeight(screenSize.y);
        this.rootContainer.getLayoutNode().setPosition(YogaEdge.TOP, 100.0f);
        this.rootContainer.getLayoutNode().calculateLayout(screenSize.x, screenSize.y);
        CaptureTree.calculateLayoutWithCapture(this.rootContainer.getLayoutNode(), screenSize.x, screenSize.y, YogaDirection.LTR, Path.of("test_layout.json", new String[0]));
        drawContext.beginBatch();
        drawContext.drawRect(0.0f, 0.0f, MinecraftWindow.getWindowSize().x, MinecraftWindow.getWindowSize().y, this.materialScheme.background(), true);
        drawContext.endBatch(-1);
        super.draw(drawContext, inputState);
        this.setTransparent(true);
        drawContext.beginBatch();
        Color[] colors = new Color[]{this.materialScheme.primary(), this.materialScheme.onPrimary(), this.materialScheme.primaryContainer(), this.materialScheme.onPrimaryContainer(), this.materialScheme.secondary(), this.materialScheme.onSecondary(), this.materialScheme.secondaryContainer(), this.materialScheme.onSecondaryContainer(), this.materialScheme.tertiary(), this.materialScheme.onTertiary(), this.materialScheme.tertiaryContainer(), this.materialScheme.onTertiaryContainer(), this.materialScheme.error(), this.materialScheme.onError(), this.materialScheme.errorContainer(), this.materialScheme.onErrorContainer(), this.materialScheme.background(), this.materialScheme.onBackground(), this.materialScheme.surface(), this.materialScheme.onSurface(), this.materialScheme.surfaceVariant(), this.materialScheme.onSurfaceVariant(), this.materialScheme.outline(), this.materialScheme.outlineVariant(), this.materialScheme.shadow(), this.materialScheme.scrim(), this.materialScheme.inverseSurface(), this.materialScheme.inverseOnSurface(), this.materialScheme.inversePrimary(), this.materialScheme.primaryFixed(), this.materialScheme.primaryFixedDim(), this.materialScheme.onPrimaryFixed(), this.materialScheme.onPrimaryFixedVariant(), this.materialScheme.secondaryFixed(), this.materialScheme.secondaryFixedDim(), this.materialScheme.onSecondaryFixed(), this.materialScheme.onSecondaryFixedVariant(), this.materialScheme.tertiaryFixed(), this.materialScheme.tertiaryFixedDim(), this.materialScheme.onTertiaryFixed(), this.materialScheme.onTertiaryFixedVariant(), this.materialScheme.controlActivated(), this.materialScheme.controlNormal(), this.materialScheme.controlHighlight(), this.materialScheme.textPrimaryInverse(), this.materialScheme.textSecondaryAndTertiaryInverse(), this.materialScheme.textPrimaryInverseDisableOnly(), this.materialScheme.textSecondaryAndTertiaryInverseDisabled(), this.materialScheme.textHintInverse()};
        String[] colorNames = new String[]{"Primary", "On Primary", "Primary Container", "On Primary Container", "Secondary", "On Secondary", "Secondary Container", "On Secondary Container", "Tertiary", "On Tertiary", "Tertiary Container", "On Tertiary Container", "Error", "On Error", "Error Container", "On Error Container", "Background", "On Background", "Surface", "On Surface", "Surface Variant", "On Surface Variant", "Outline", "Outline Variant", "Shadow", "Scrim", "Inverse Surface", "Inverse On Surface", "Inverse Primary", "Primary Fixed", "Primary Fixed Dim", "On Primary Fixed", "On Primary Fixed Variant", "Secondary Fixed", "Secondary Fixed Dim", "On Secondary Fixed", "On Secondary Fixed Variant", "Tertiary Fixed", "Tertiary Fixed Dim", "On Tertiary Fixed", "On Tertiary Fixed Variant", "Control Activated", "Control Normal", "Control Highlight", "Text Primary Inverse", "Text Secondary And Tertiary Inverse", "Text Primary Inverse Disable Only", "Text Secondary And Tertiary Inverse Disabled", "Text Hint Inverse"};
        int colorCount = colors.length;
        int colorsPerColumn = 30;
        float screenWidth = MinecraftWindow.getWindowSize().x;
        float screenHeight = MinecraftWindow.getWindowSize().y;
        float columnWidth = screenWidth * 0.2f;
        float leftColumnX = screenWidth * 0.6f;
        float rightColumnX = screenWidth * 0.8f;
        for (i = 0; i < colorsPerColumn; ++i) {
            float yPos = screenHeight * ((float)i / (float)colorsPerColumn);
            float height = screenHeight / (float)colorsPerColumn;
            this.drawRibbonWithText(drawContext, new Rectangle(leftColumnX, yPos, columnWidth, height), colors[i], colorNames[i]);
        }
        for (i = colorsPerColumn; i < colorCount; ++i) {
            int rightColumnIndex = i - colorsPerColumn;
            float yPos = screenHeight * ((float)rightColumnIndex / (float)(colorCount - colorsPerColumn));
            float height = screenHeight / (float)(colorCount - colorsPerColumn);
            this.drawRibbonWithText(drawContext, new Rectangle(rightColumnX, yPos, columnWidth, height), colors[i], colorNames[i]);
        }
        drawContext.endBatch(0);
    }

    private void drawRibbonWithText(IUIDrawContext drawContext, Rectangle rectangle, Color color, String str) {
        drawContext.drawRect(rectangle.x / this.nvg.globalScale, rectangle.y / this.nvg.globalScale, rectangle.width / this.nvg.globalScale, rectangle.height / this.nvg.globalScale, color, true);
        drawContext.drawAlignedText(drawContext.font(), 14.0f, str, rectangle.getCenterX() / this.nvg.globalScale, rectangle.getCenterY() / this.nvg.globalScale, rectangle.width / this.nvg.globalScale, 14.0f, Color.rgb(255 - color.red(), 255 - color.green(), 255 - color.blue()), TextAlign.of(TextAlignType.ALIGN_CENTER, TextAlignType.ALIGN_MIDDLE), false);
    }
}

