/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.widgets.sliders;

import io.homo.superresolution.core.gui.core.UIInputState;
import io.homo.superresolution.core.gui.core.animator.Easing;
import io.homo.superresolution.core.gui.core.backends.interfaces.IUIDrawContext;
import io.homo.superresolution.core.gui.core.backends.interfaces.TextAlign;
import io.homo.superresolution.core.gui.core.backends.interfaces.TextAlignType;
import io.homo.superresolution.core.gui.core.event.EventListener;
import io.homo.superresolution.core.gui.core.event.events.MouseEvent;
import io.homo.superresolution.core.gui.core.event.events.WidgetEvent;
import io.homo.superresolution.core.gui.core.impl.Rectangle;
import io.homo.superresolution.core.gui.widgets.MaterialWidget;
import io.homo.superresolution.core.gui.widgets.sliders.MaterialSliderAnimationSet;
import io.homo.superresolution.core.gui.widgets.sliders.MaterialSliderSize;
import io.homo.superresolution.core.gui.widgets.sliders.MaterialSliderStyle;
import io.homo.superresolution.core.utils.Color;
import io.homo.superresolution.core.utils.MouseCursor;
import java.util.function.Function;
import org.joml.Vector2f;

public class MaterialSlider
extends MaterialWidget<MaterialSlider, MaterialSliderStyle, MaterialSliderAnimationSet> {
    private Number value = 0.0;
    private Number step = 0.0;
    private Number max = 1.0;
    private Number min = 0.0;
    private Function<Number, String> valueIndicatorTextFormater = Object::toString;

    public MaterialSlider(MaterialSliderSize size, float width) {
        this.style = new MaterialSliderStyle();
        ((MaterialSliderStyle)this.style).size(size);
        this.setElementWidth(width);
        this.updateRectangle();
        this.getLayoutNode().setDebugName("MaterialSlider");
    }

    public static MaterialSlider create() {
        return new MaterialSlider(MaterialSliderSize.Medium, 354.0f);
    }

    public Function<Number, String> getValueIndicatorTextFormater() {
        return this.valueIndicatorTextFormater;
    }

    public MaterialSlider setValueIndicatorTextFormater(Function<Number, String> valueIndicatorTextFormater) {
        this.valueIndicatorTextFormater = valueIndicatorTextFormater;
        return this;
    }

    public Number value() {
        return this.value;
    }

    public MaterialSlider setValue(Number value) {
        this.value = value;
        this.eventHandler.fire(new WidgetEvent.ChangeEvent<Number>(value));
        return this;
    }

    public Number step() {
        return this.step;
    }

    public MaterialSlider setStep(Number step) {
        this.step = step;
        return this;
    }

    public Number max() {
        return this.max;
    }

    public MaterialSlider setMax(Number max) {
        this.max = max;
        return this;
    }

    public Number min() {
        return this.min;
    }

    public MaterialSlider setMin(Number min) {
        this.min = min;
        return this;
    }

    public float width() {
        return this.getBounds().width;
    }

    public void onChange(EventListener<WidgetEvent.ChangeEvent> listener) {
        this.eventHandler.on(WidgetEvent.ChangeEvent.class, listener);
    }

    @Override
    protected boolean isInteractive() {
        return true;
    }

    @Override
    protected void init() {
        this.animationSet = new MaterialSliderAnimationSet();
        this.onHover(event -> this.onHover(event.getMousePosition(), event.isHovering()));
        this.onMouseRelease(event -> this.onRelease(event.getMousePosition()));
        this.onMousePress(event -> this.onPress(event.getMousePosition()));
        this.onMouseMove((MouseEvent.MouseMoveEvent event) -> this.onMouseMove(event.getMousePosition()));
        this.onMouseDrag(event -> this.onMouseDrag(event.getMousePosition(), event.getDragDelta()));
    }

    private void updateRectangle() {
        this.setElementHeight(((MaterialSliderStyle)this.style).size().handleHeight());
    }

    @Override
    public void render(IUIDrawContext drawContext, UIInputState inputState) {
        if (((MaterialSliderAnimationSet)this.animationSet).handleSize.floatValue() < ((MaterialSliderStyle)this.style).size().handleWidthPress()) {
            ((MaterialSliderAnimationSet)this.animationSet).handleSize.set(Float.valueOf(((MaterialSliderStyle)this.style).size().handleWidth()));
        }
        this.updateRectangle();
        drawContext.beginBatch();
        ((MaterialSliderAnimationSet)this.animationSet).update();
        SliderColors colors = this.getSliderColors();
        Rectangle bounds = this.getBounds();
        float progress = (float)((this.value.doubleValue() - this.min.doubleValue()) / (this.max.doubleValue() - this.min.doubleValue()));
        float availableWidth = bounds.width - ((MaterialSliderStyle)this.style).size().stepsHorizontalPadding() * 2.0f;
        float handleXPosition = bounds.x + availableWidth * progress;
        float handleWidth = ((MaterialSliderAnimationSet)this.animationSet).handleSize.floatValue();
        float activeTrackWidth = availableWidth * progress - handleWidth / 2.0f - ((MaterialSliderStyle)this.style).size().handleHorizontalPadding() + ((MaterialSliderStyle)this.style).size().stepsSize();
        if (activeTrackWidth > 1.0f) {
            drawContext.beginPath();
            drawContext.fillColor(colors.activeTrackColor);
            drawContext.roundedRectComplex(bounds.x, bounds.y + (((MaterialSliderStyle)this.style).size().handleHeight() - ((MaterialSliderStyle)this.style).size().trackHeight()) / 2.0f, activeTrackWidth, ((MaterialSliderStyle)this.style).size().trackHeight(), Math.min(((MaterialSliderStyle)this.style).size().trackCornerSize(), activeTrackWidth / 2.0f), Math.min(2.0f, activeTrackWidth / 2.0f), Math.min(((MaterialSliderStyle)this.style).size().trackCornerSize(), activeTrackWidth / 2.0f), Math.min(2.0f, activeTrackWidth / 2.0f));
            drawContext.endPath();
        }
        drawContext.drawRoundedRect(handleXPosition - handleWidth / 2.0f + ((MaterialSliderStyle)this.style).size().stepsSize(), bounds.y, handleWidth, ((MaterialSliderStyle)this.style).size().handleHeight(), Math.min(2.0f, handleWidth / 2.0f), colors.handleColor, true);
        float inactiveTrackWidth = bounds.width - activeTrackWidth - handleWidth - ((MaterialSliderStyle)this.style).size().handleHorizontalPadding() - ((MaterialSliderStyle)this.style).size().handleHorizontalPadding();
        if (inactiveTrackWidth > 1.0f) {
            drawContext.beginPath();
            drawContext.fillColor(colors.inactiveTrackColor);
            drawContext.roundedRectComplex(bounds.getLimitX() - inactiveTrackWidth, bounds.y + (((MaterialSliderStyle)this.style).size().handleHeight() - ((MaterialSliderStyle)this.style).size().trackHeight()) / 2.0f, inactiveTrackWidth, ((MaterialSliderStyle)this.style).size().trackHeight(), Math.min(2.0f, inactiveTrackWidth / 2.0f), Math.min(((MaterialSliderStyle)this.style).size().trackCornerSize(), inactiveTrackWidth / 2.0f), Math.min(2.0f, inactiveTrackWidth / 2.0f), Math.min(((MaterialSliderStyle)this.style).size().trackCornerSize(), inactiveTrackWidth / 2.0f));
            drawContext.endPath();
        }
        if (this.step.doubleValue() > 0.0 && ((MaterialSliderStyle)this.style).steps()) {
            int steps = (int)Math.floor((this.max.doubleValue() - this.min.doubleValue()) / this.step().doubleValue());
            float stepSpacing = availableWidth / (float)steps;
            for (int stepIndex = 0; stepIndex <= steps; ++stepIndex) {
                float stepXPosition = bounds.x + ((MaterialSliderStyle)this.style).size().stepsHorizontalPadding() + stepSpacing * (float)stepIndex;
                if (Math.abs(stepXPosition - handleXPosition) < stepSpacing / 2.0f) continue;
                double stepValue = this.min.doubleValue() + (double)stepIndex * this.step.doubleValue();
                Color stepColor = this.value.doubleValue() >= stepValue ? colors.stepActiveIndicatorsColor : colors.stepInactiveIndicatorsColor;
                drawContext.drawArc(stepXPosition, bounds.y + ((MaterialSliderStyle)this.style).size().trackHeight() / 2.0f + (((MaterialSliderStyle)this.style).size().handleHeight() - ((MaterialSliderStyle)this.style).size().trackHeight()) / 2.0f, ((MaterialSliderStyle)this.style).size().stepsSize() / 2.0f, stepColor, true);
            }
        }
        drawContext.endBatch(this.getZIndex());
        drawContext.beginBatch();
        if (((MaterialSliderStyle)this.style).valueIndicator() && ((MaterialSliderAnimationSet)this.animationSet).hover.doubleValue() > 0.01) {
            String valueIndicatorString = this.valueIndicatorTextFormater == null ? String.valueOf(this.value()) : this.valueIndicatorTextFormater.apply(this.value());
            Vector2f valueIndicatorStringRegion = drawContext.measureText(valueIndicatorString, 14.0f);
            Rectangle valueIndicatorRegion = new Rectangle();
            valueIndicatorRegion.width = ((MaterialSliderStyle)this.style).size().valueIndicatorTextHorizontalPadding() * 2.0f + valueIndicatorStringRegion.x;
            valueIndicatorRegion.height = ((MaterialSliderStyle)this.style).size().valueIndicatorTextVerticalPadding() * 2.0f + 20.0f;
            valueIndicatorRegion.x = handleXPosition - valueIndicatorRegion.width / 2.0f;
            valueIndicatorRegion.y = bounds.y + (((MaterialSliderStyle)this.style).size().handleHeight() - ((MaterialSliderStyle)this.style).size().trackHeight()) / 2.0f - (((MaterialSliderStyle)this.style).size().handleHeight() - ((MaterialSliderStyle)this.style).size().trackHeight()) / 2.0f - ((MaterialSliderStyle)this.style).size().valueIndicatorBottomPadding() - bounds.height;
            drawContext.transform().push();
            drawContext.transform().last().scaleAt(((MaterialSliderAnimationSet)this.animationSet).hover.floatValue(), ((MaterialSliderAnimationSet)this.animationSet).hover.floatValue(), valueIndicatorRegion.getCenterX(), valueIndicatorRegion.getLimitY());
            drawContext.transform().translate(0.0f, 0.0f);
            drawContext.drawRoundedRect(valueIndicatorRegion.x, valueIndicatorRegion.y, valueIndicatorRegion.width, valueIndicatorRegion.height, valueIndicatorRegion.height / 2.0f, colors.valueIndicatorColor, true);
            drawContext.drawAlignedText(drawContext.font(), 14.0f, valueIndicatorString, valueIndicatorRegion.getCenterX(), valueIndicatorRegion.getCenterY(), valueIndicatorRegion.width, 14.0f, colors.valueIndicatorTextColor, TextAlign.of(TextAlignType.ALIGN_CENTER, TextAlignType.ALIGN_MIDDLE), false);
            drawContext.transform().pop();
        }
        drawContext.endBatch(1000);
    }

    private SliderColors getSliderColors() {
        SliderColors colors = new SliderColors();
        colors.inactiveTrackColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(25) : this.scheme.secondaryContainer();
        colors.activeTrackColor = this.isDisabled() ? this.scheme.onSurface() : this.scheme.primary();
        colors.handleColor = this.isDisabled() ? this.scheme.onSurface().copy().alpha(96) : this.scheme.primary();
        colors.stepInactiveIndicatorsColor = this.isDisabled() ? this.scheme.onSurface() : this.scheme.onSecondaryContainer();
        colors.stepActiveIndicatorsColor = this.isDisabled() ? this.scheme.inverseOnSurface() : this.scheme.onPrimary();
        colors.insetIconColor = this.isDisabled() ? this.scheme.inverseOnSurface() : this.scheme.onPrimary();
        colors.valueIndicatorColor = this.scheme.inverseSurface();
        colors.valueIndicatorTextColor = this.scheme.inverseOnSurface();
        return colors;
    }

    private void onHover(Vector2f mousePosition, boolean hover) {
        if (hover) {
            ((MaterialSliderAnimationSet)this.animationSet).hover.ease(Easing.LINEAR).animateTo(1, 150L);
            MouseCursor.HAND.use();
        } else {
            if (!this.isPressed()) {
                ((MaterialSliderAnimationSet)this.animationSet).hover.ease(Easing.LINEAR).animateTo(0, 150L);
            }
            MouseCursor.ARROW.use();
        }
    }

    private float calcProgressFromMouse(Vector2f position) {
        Rectangle bounds = this.getBounds();
        float relativeX = position.x - bounds.x;
        float clampedX = this.clamp(relativeX, 0.0f, bounds.width);
        return clampedX / bounds.width;
    }

    private float clamp(float value, float min, float max) {
        return Math.min(max, Math.max(value, min));
    }

    private double clamp(double value, double min, double max) {
        return Math.min(max, Math.max(value, min));
    }

    private void onPress(Vector2f mousePosition) {
        ((MaterialSliderAnimationSet)this.animationSet).hover.ease(Easing.LINEAR).animateTo(1, 150L);
        ((MaterialSliderAnimationSet)this.animationSet).press.ease(Easing.LINEAR).animateTo(1, 200L);
        ((MaterialSliderAnimationSet)this.animationSet).handleSize.ease(Easing.LINEAR).animateTo(Float.valueOf(((MaterialSliderStyle)this.style).size().handleWidthPress()), 200L);
        float progress = this.calcProgressFromMouse(mousePosition);
        double range = this.max.doubleValue() - this.min.doubleValue();
        double newValue = this.min.doubleValue() + range * (double)progress;
        if (this.step.doubleValue() > 0.0) {
            double steps = (newValue - this.min.doubleValue()) / this.step.doubleValue();
            newValue = this.min.doubleValue() + (double)Math.round(steps) * this.step.doubleValue();
        }
        newValue = this.clamp(newValue, this.min.doubleValue(), this.max.doubleValue());
        this.setValue(newValue);
    }

    private void onMouseDrag(Vector2f mousePosition, Vector2f mousePositionDelta) {
        if (this.isPressed()) {
            float progress = this.calcProgressFromMouse(mousePosition);
            double range = this.max.doubleValue() - this.min.doubleValue();
            double newValue = this.min.doubleValue() + range * (double)progress;
            if (this.step.doubleValue() > 0.0) {
                double steps = (newValue - this.min.doubleValue()) / this.step.doubleValue();
                newValue = this.min.doubleValue() + (double)Math.round(steps) * this.step.doubleValue();
            }
            newValue = this.clamp(newValue, this.min.doubleValue(), this.max.doubleValue());
            this.setValue(newValue);
        }
    }

    private void onMouseMove(Vector2f mousePosition) {
        if (this.isPressed()) {
            float progress = this.calcProgressFromMouse(mousePosition);
            double range = this.max.doubleValue() - this.min.doubleValue();
            double newValue = this.min.doubleValue() + range * (double)progress;
            if (this.step.doubleValue() > 0.0) {
                double steps = (newValue - this.min.doubleValue()) / this.step.doubleValue();
                newValue = this.min.doubleValue() + (double)Math.round(steps) * this.step.doubleValue();
            }
            newValue = this.clamp(newValue, this.min.doubleValue(), this.max.doubleValue());
            this.setValue(newValue);
        }
    }

    private void onRelease(Vector2f mousePosition) {
        ((MaterialSliderAnimationSet)this.animationSet).hover.ease(Easing.cubicBezier(0.2f, 0.0f, 0.0f, 1.0f)).animateTo(this.isHovered() ? 1 : 0, 200L);
        ((MaterialSliderAnimationSet)this.animationSet).press.ease(Easing.LINEAR).animateTo(0, 200L);
        ((MaterialSliderAnimationSet)this.animationSet).handleSize.ease(Easing.LINEAR).animateTo(Float.valueOf(((MaterialSliderStyle)this.style).size().handleWidth()), 200L);
    }

    private static class SliderColors {
        Color insetIconColor;
        Color stepActiveIndicatorsColor;
        Color stepInactiveIndicatorsColor;
        Color valueIndicatorColor;
        Color valueIndicatorTextColor;
        Color activeTrackColor;
        Color inactiveTrackColor;
        Color handleColor;

        private SliderColors() {
        }
    }
}

