/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.shadercompat;

import com.google.common.collect.ImmutableList;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.minecraft.handler.SRShaderCompatConfig;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.shadercompat.NamedCompositePass;
import io.homo.superresolution.shadercompat.SRCompatShaderPack;
import io.homo.superresolution.shadercompat.ShaderCompatUpscaleDispatcher;
import io.homo.superresolution.shadercompat.mixin.core.CompositeRendererAccessor;
import io.homo.superresolution.shadercompat.mixin.core.IrisRenderingPipelineAccessor;
import io.homo.superresolution.shadercompat.mixin.core.RenderTargetsAccessor;
import java.lang.reflect.Field;
import java.util.Optional;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.pipeline.CompositeRenderer;
import net.irisshaders.iris.shaderpack.ShaderPack;
import org.jetbrains.annotations.NotNull;

public class IrisShaderPipelineHandle {
    public static String getCompositePassName(Object obj) {
        if (obj instanceof NamedCompositePass) {
            return ((NamedCompositePass)obj).superresolution$getName();
        }
        try {
            Class<?> passClazz = Class.forName("net.irisshaders.iris.pipeline.CompositeRenderer$Pass");
            Field nameField = passClazz.getDeclaredField("name");
            nameField.setAccessible(true);
            return (String)nameField.get(obj);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public static ImmutableList<?> getCompositeRendererPasses(CompositeRenderer compositeRenderer) {
        return ((CompositeRendererAccessor)compositeRenderer).getPasses();
    }

    public static void onCompositeRendererRender(CompositeRenderer compositeRenderer, NamedCompositePass currentPass) {
        if (!IrisShaderPipelineHandle.shouldApplySuperResolutionChanges()) {
            return;
        }
        try {
            String currentPassName;
            String targetPassName;
            if (((CompositeRendererAccessor)compositeRenderer).getRenderTargets() != null && !((RenderTargetsAccessor)((CompositeRendererAccessor)compositeRenderer).getRenderTargets()).isDestroyed() && Iris.getPipelineManager().getPipeline().isPresent() && compositeRenderer.equals(((IrisRenderingPipelineAccessor)Iris.getPipelineManager().getPipeline().get()).getCompositeRenderer()) && ShaderCompatUpscaleDispatcher.getCurrentConfig() != null && ShaderCompatUpscaleDispatcher.getCurrentConfig().enabled && (targetPassName = ShaderCompatUpscaleDispatcher.getCurrentConfig().upscale_config.before_upscale_shader_name).equals(currentPassName = IrisShaderPipelineHandle.getCompositePassName(currentPass))) {
                ShaderCompatUpscaleDispatcher.dispatchUpscale(compositeRenderer);
            }
        }
        catch (Throwable throwable) {
            SuperResolution.LOGGER.error("\u6267\u884c\u8d85\u5206\u65f6\u53d1\u751f\u9519\u8bef");
            throwable.printStackTrace();
        }
    }

    public static Optional<SRShaderCompatConfig> getCurrentShaderPackConfig() {
        return IrisShaderPipelineHandle.getCurrentShaderPack().map(pack -> ((SRCompatShaderPack)pack).superresolution$getSuperResolutionComaptConfig());
    }

    @NotNull
    public static Optional<ShaderPack> getCurrentShaderPack() {
        return Iris.getCurrentPack();
    }

    public static boolean shouldApplySuperResolutionChanges() {
        return !SuperResolutionConfig.isForceDisableShaderCompat() && IrisApi.getInstance().isShaderPackInUse() && IrisShaderPipelineHandle.getCurrentShaderPack().isPresent() && ((SRCompatShaderPack)IrisShaderPipelineHandle.getCurrentShaderPack().get()).superresolution$isSupportsSuperResolution() && ((SRCompatShaderPack)IrisShaderPipelineHandle.getCurrentShaderPack().get()).superresolution$getSuperResolutionComaptConfig() != null && ((SRCompatShaderPack)IrisShaderPipelineHandle.getCurrentShaderPack().get()).superresolution$getSuperResolutionComaptConfig().sr.enabled;
    }

    public static boolean shouldApplySuperResolutionChangesJitter() {
        return !SuperResolutionConfig.isForceDisableShaderCompat() && IrisApi.getInstance().isShaderPackInUse() && IrisShaderPipelineHandle.getCurrentShaderPack().isPresent() && ((SRCompatShaderPack)IrisShaderPipelineHandle.getCurrentShaderPack().get()).superresolution$isSupportsSuperResolution() && ((SRCompatShaderPack)IrisShaderPipelineHandle.getCurrentShaderPack().get()).superresolution$getSuperResolutionComaptConfig() != null && ((SRCompatShaderPack)IrisShaderPipelineHandle.getCurrentShaderPack().get()).superresolution$getSuperResolutionComaptConfig().sr_jitter.enabled;
    }

    public static TextureFormat getInternalTextureFormat() {
        if (!SuperResolutionConfig.isForceDisableShaderCompat() && IrisApi.getInstance().isShaderPackInUse() && IrisShaderPipelineHandle.getCurrentShaderPack().isPresent() && ((SRCompatShaderPack)IrisShaderPipelineHandle.getCurrentShaderPack().get()).superresolution$isSupportsSuperResolution() && ((SRCompatShaderPack)IrisShaderPipelineHandle.getCurrentShaderPack().get()).superresolution$getSuperResolutionComaptConfig() != null && ShaderCompatUpscaleDispatcher.getCurrentConfig() != null && ShaderCompatUpscaleDispatcher.getCurrentConfig().enabled) {
            return ShaderCompatUpscaleDispatcher.getCurrentConfig().upscale_config.getSrInternalTextureFormat();
        }
        return TextureFormat.R11G11B10F;
    }
}

