/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.shadercompat.mixin.core;

import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.SuperResolutionConfig;
import io.homo.superresolution.common.minecraft.handler.RenderHandlerManager;
import io.homo.superresolution.common.upscale.AlgorithmManager;
import net.irisshaders.iris.gl.uniform.UniformHolder;
import net.irisshaders.iris.gl.uniform.UniformUpdateFrequency;
import net.irisshaders.iris.uniforms.ViewportUniforms;
import org.joml.Vector2f;
import org.joml.Vector2i;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ViewportUniforms.class})
public class ViewportUniformsMixin {
    @Inject(method={"addViewportUniforms"}, at={@At(value="RETURN")}, remap=false)
    private static void addUniforms(UniformHolder uniforms, CallbackInfo ci) {
        if (SuperResolutionConfig.isForceDisableShaderCompat()) {
            return;
        }
        uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "SRRenderScale", () -> SuperResolutionConfig.isEnableUpscale() ? SuperResolutionConfig.getRenderScaleFactor() : 1.0f);
        uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "SRRatio", () -> SuperResolutionConfig.isEnableUpscale() ? SuperResolutionConfig.getUpscaleRatio() : 1.0f);
        uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "SRRenderScaleLog2", () -> Math.log(SuperResolutionConfig.isEnableUpscale() ? (double)SuperResolutionConfig.getUpscaleRatio() : 1.0));
        uniforms.uniform2f(UniformUpdateFrequency.PER_FRAME, "SRScaledViewportSize", () -> new Vector2f((float)RenderHandlerManager.getRenderWidth(), (float)RenderHandlerManager.getRenderHeight()));
        uniforms.uniform2f(UniformUpdateFrequency.PER_FRAME, "SROriginalViewportSize", () -> new Vector2f((float)RenderHandlerManager.getScreenWidth(), (float)RenderHandlerManager.getScreenHeight()));
        uniforms.uniform2i(UniformUpdateFrequency.PER_FRAME, "SRScaledViewportSizeI", () -> new Vector2i(RenderHandlerManager.getRenderWidth(), RenderHandlerManager.getRenderHeight()));
        uniforms.uniform2i(UniformUpdateFrequency.PER_FRAME, "SROriginalViewportSizeI", () -> new Vector2i(RenderHandlerManager.getScreenWidth(), RenderHandlerManager.getScreenHeight()));
        uniforms.uniform2f(UniformUpdateFrequency.PER_FRAME, "SRJitterOffset", () -> {
            if (!SuperResolution.getCurrentAlgorithm().isSupportJitter()) {
                return new Vector2f(0.0f);
            }
            Vector2f jitterOffset = AlgorithmManager.getJitterOffset();
            return new Vector2f(jitterOffset.x, jitterOffset.y);
        });
    }
}

