/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaAlign;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDimension;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaDisplay;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaErrata;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaExperimentalFeature;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaFlexDirection;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaJustify;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaNode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaOverflow;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaPhysicalEdge;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaPositionType;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaSize;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.YogaWrap;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.AbsoluteLayout;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.AlignUtil;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.Baseline;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.BoundAxis;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.Cache;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.FlexDirectionUtil;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.FlexLine;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.PixelGrid;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.SizingMode;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.algorithm.TrailingPosition;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.LayoutData;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.LayoutPassReason;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.LayoutType;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.YogaEvent;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.YogaEventType;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.node.CachedMeasurement;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.node.LayoutResults;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.node.LayoutableChildren;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.Comparison;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.numeric.FloatOptional;
import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.style.YogaStyle;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;

public class CalculateLayout {
    private static final AtomicInteger gCurrentGenerationCount = new AtomicInteger(0);

    public static void calculateLayout(YogaNode node, float ownerWidth, float ownerHeight, YogaDirection ownerDirection) {
        YogaEvent.publish(YogaEventType.LAYOUT_PASS_START, node);
        LayoutData markerData = new LayoutData();
        gCurrentGenerationCount.incrementAndGet();
        node.processDimensions();
        YogaDirection direction = node.resolveDirection(ownerDirection);
        float width = Float.NaN;
        SizingMode widthSizingMode = SizingMode.MAX_CONTENT;
        YogaStyle style = node.getStyle();
        if (node.hasDefiniteLength(YogaDimension.WIDTH, ownerWidth)) {
            width = node.getResolvedDimension(direction, FlexDirectionUtil.dimension(YogaFlexDirection.ROW), ownerWidth, ownerWidth).unwrap() + node.getStyle().computeMarginForAxis(YogaFlexDirection.ROW, ownerWidth);
            widthSizingMode = SizingMode.STRETCH_FIT;
        } else if (style.resolveMaxDimension(direction, YogaDimension.WIDTH, ownerWidth, ownerWidth).isDefined()) {
            width = style.resolveMaxDimension(direction, YogaDimension.WIDTH, ownerWidth, ownerWidth).unwrap();
            widthSizingMode = SizingMode.FIT_CONTENT;
        } else {
            width = ownerWidth;
            widthSizingMode = Comparison.isUndefined(width) ? SizingMode.MAX_CONTENT : SizingMode.STRETCH_FIT;
        }
        float height = Float.NaN;
        SizingMode heightSizingMode = SizingMode.MAX_CONTENT;
        if (node.hasDefiniteLength(YogaDimension.HEIGHT, ownerHeight)) {
            height = node.getResolvedDimension(direction, FlexDirectionUtil.dimension(YogaFlexDirection.COLUMN), ownerHeight, ownerWidth).unwrap() + node.getStyle().computeMarginForAxis(YogaFlexDirection.COLUMN, ownerWidth);
            heightSizingMode = SizingMode.STRETCH_FIT;
        } else if (style.resolveMaxDimension(direction, YogaDimension.HEIGHT, ownerHeight, ownerWidth).isDefined()) {
            height = style.resolveMaxDimension(direction, YogaDimension.HEIGHT, ownerHeight, ownerWidth).unwrap();
            heightSizingMode = SizingMode.FIT_CONTENT;
        } else {
            height = ownerHeight;
            SizingMode sizingMode = heightSizingMode = Comparison.isUndefined(height) ? SizingMode.MAX_CONTENT : SizingMode.STRETCH_FIT;
        }
        if (CalculateLayout.calculateLayoutInternal(node, width, height, ownerDirection, widthSizingMode, heightSizingMode, ownerWidth, ownerHeight, true, LayoutPassReason.INITIAL, markerData, 0, gCurrentGenerationCount.get())) {
            node.setPosition(node.getLayout().direction(), ownerWidth, ownerHeight);
            PixelGrid.roundLayoutResultsToPixelGrid(node, 0.0, 0.0);
        }
        YogaEvent.publish(node, YogaEventType.LAYOUT_PASS_END, new YogaEvent.LayoutPassEndData(markerData));
    }

    public static boolean calculateLayoutInternal(YogaNode node, float availableWidth, float availableHeight, YogaDirection ownerDirection, SizingMode widthSizingMode, SizingMode heightSizingMode, float ownerWidth, float ownerHeight, boolean performLayout, LayoutPassReason reason, LayoutData layoutMarkerData, int depth, int generationCount) {
        boolean needToVisitNode;
        LayoutResults layout = node.getLayout();
        ++depth;
        boolean bl = needToVisitNode = node.isDirty() && layout.generationCount != generationCount || layout.configVersion != node.getConfig().getVersion() || layout.lastOwnerDirection != ownerDirection;
        if (needToVisitNode) {
            layout.nextCachedMeasurementsIndex = 0;
            layout.cachedLayout.availableWidth = -1.0f;
            layout.cachedLayout.availableHeight = -1.0f;
            layout.cachedLayout.widthSizingMode = SizingMode.MAX_CONTENT;
            layout.cachedLayout.heightSizingMode = SizingMode.MAX_CONTENT;
            layout.cachedLayout.computedWidth = -1.0f;
            layout.cachedLayout.computedHeight = -1.0f;
        }
        CachedMeasurement cachedResults = null;
        if (node.hasMeasureFunc()) {
            float marginAxisColumn;
            float marginAxisRow = node.getStyle().computeMarginForAxis(YogaFlexDirection.ROW, ownerWidth);
            if (Cache.canUseCachedMeasurement(widthSizingMode, availableWidth, heightSizingMode, availableHeight, layout.cachedLayout.widthSizingMode, layout.cachedLayout.availableWidth, layout.cachedLayout.heightSizingMode, layout.cachedLayout.availableHeight, layout.cachedLayout.computedWidth, layout.cachedLayout.computedHeight, marginAxisRow, marginAxisColumn = node.getStyle().computeMarginForAxis(YogaFlexDirection.COLUMN, ownerWidth), node.getConfig())) {
                cachedResults = layout.cachedLayout;
            } else {
                for (int i = 0; i < layout.nextCachedMeasurementsIndex; ++i) {
                    if (!Cache.canUseCachedMeasurement(widthSizingMode, availableWidth, heightSizingMode, availableHeight, layout.cachedMeasurements[i].widthSizingMode, layout.cachedMeasurements[i].availableWidth, layout.cachedMeasurements[i].heightSizingMode, layout.cachedMeasurements[i].availableHeight, layout.cachedMeasurements[i].computedWidth, layout.cachedMeasurements[i].computedHeight, marginAxisRow, marginAxisColumn, node.getConfig())) continue;
                    cachedResults = layout.cachedMeasurements[i];
                    break;
                }
            }
        } else if (performLayout) {
            if (Comparison.inexactEquals(layout.cachedLayout.availableWidth, availableWidth) && Comparison.inexactEquals(layout.cachedLayout.availableHeight, availableHeight) && layout.cachedLayout.widthSizingMode == widthSizingMode && layout.cachedLayout.heightSizingMode == heightSizingMode) {
                cachedResults = layout.cachedLayout;
            }
        } else {
            for (int i = 0; i < layout.nextCachedMeasurementsIndex; ++i) {
                if (!Comparison.inexactEquals(layout.cachedMeasurements[i].availableWidth, availableWidth) || !Comparison.inexactEquals(layout.cachedMeasurements[i].availableHeight, availableHeight) || layout.cachedMeasurements[i].widthSizingMode != widthSizingMode || layout.cachedMeasurements[i].heightSizingMode != heightSizingMode) continue;
                cachedResults = layout.cachedMeasurements[i];
                break;
            }
        }
        if (!needToVisitNode && cachedResults != null) {
            layout.setMeasuredDimension(YogaDimension.WIDTH, cachedResults.computedWidth);
            layout.setMeasuredDimension(YogaDimension.HEIGHT, cachedResults.computedHeight);
            if (performLayout) {
                layoutMarkerData.cachedLayouts = layoutMarkerData.cachedLayouts() + 1;
            } else {
                layoutMarkerData.cachedMeasures = layoutMarkerData.cachedMeasures() + 1;
            }
        } else {
            CalculateLayout.calculateLayoutImpl(node, availableWidth, availableHeight, ownerDirection, widthSizingMode, heightSizingMode, ownerWidth, ownerHeight, performLayout, reason, layoutMarkerData, depth, generationCount);
            layout.lastOwnerDirection = ownerDirection;
            layout.configVersion = node.getConfig().getVersion();
            if (cachedResults == null) {
                layoutMarkerData.maxMeasureCache = Math.max(layoutMarkerData.maxMeasureCache(), layout.nextCachedMeasurementsIndex + 1);
                if (layout.nextCachedMeasurementsIndex == 8) {
                    layout.nextCachedMeasurementsIndex = 0;
                }
                if (performLayout) {
                    newCacheEntry = layout.cachedLayout;
                } else {
                    newCacheEntry = layout.cachedMeasurements[layout.nextCachedMeasurementsIndex];
                    ++layout.nextCachedMeasurementsIndex;
                }
                newCacheEntry.availableWidth = availableWidth;
                newCacheEntry.availableHeight = availableHeight;
                newCacheEntry.widthSizingMode = widthSizingMode;
                newCacheEntry.heightSizingMode = heightSizingMode;
                newCacheEntry.computedWidth = layout.measuredDimension(YogaDimension.WIDTH);
                newCacheEntry.computedHeight = layout.measuredDimension(YogaDimension.HEIGHT);
            }
        }
        if (performLayout) {
            node.setLayoutDimension(node.getLayout().measuredDimension(YogaDimension.WIDTH), YogaDimension.WIDTH);
            node.setLayoutDimension(node.getLayout().measuredDimension(YogaDimension.HEIGHT), YogaDimension.HEIGHT);
            node.setHasNewLayout(true);
            node.setDirty(false);
        }
        layout.generationCount = generationCount;
        LayoutType layoutType = performLayout ? (!needToVisitNode && cachedResults == layout.cachedLayout ? LayoutType.CACHED_LAYOUT : LayoutType.LAYOUT) : (cachedResults != null ? LayoutType.CACHED_MEASURE : LayoutType.MEASURE);
        YogaEvent.publish(node, YogaEventType.NODE_LAYOUT, new YogaEvent.NodeLayoutData(layoutType));
        return needToVisitNode || cachedResults == null;
    }

    private static void calculateLayoutImpl(YogaNode node, float availableWidth, float availableHeight, YogaDirection ownerDirection, SizingMode widthSizingMode, SizingMode heightSizingMode, float ownerWidth, float ownerHeight, boolean performLayout, LayoutPassReason reason, LayoutData layoutMarkerData, int depth, int generationCount) {
        boolean mainAxisOverflows;
        assert (!Comparison.isUndefined(availableWidth) || widthSizingMode == SizingMode.MAX_CONTENT) : "availableWidth is indefinite so widthSizingMode must be SizingMode.MAX_CONTENT";
        assert (!Comparison.isUndefined(availableHeight) || heightSizingMode == SizingMode.MAX_CONTENT) : "availableHeight is indefinite so heightSizingMode must be SizingMode.MAX_CONTENT";
        if (performLayout) {
            ++layoutMarkerData.layouts;
        } else {
            ++layoutMarkerData.measures;
        }
        YogaDirection direction = node.resolveDirection(ownerDirection);
        node.setLayoutDirection(direction);
        YogaFlexDirection flexRowDirection = FlexDirectionUtil.resolveDirection(YogaFlexDirection.ROW, direction);
        YogaFlexDirection flexColumnDirection = FlexDirectionUtil.resolveDirection(YogaFlexDirection.COLUMN, direction);
        YogaPhysicalEdge startEdge = direction == YogaDirection.LTR ? YogaPhysicalEdge.LEFT : YogaPhysicalEdge.RIGHT;
        YogaPhysicalEdge endEdge = direction == YogaDirection.LTR ? YogaPhysicalEdge.RIGHT : YogaPhysicalEdge.LEFT;
        float marginRowLeading = node.getStyle().computeInlineStartMargin(flexRowDirection, direction, ownerWidth);
        node.setLayoutMargin(marginRowLeading, startEdge);
        float marginRowTrailing = node.getStyle().computeInlineEndMargin(flexRowDirection, direction, ownerWidth);
        node.setLayoutMargin(marginRowTrailing, endEdge);
        float marginColumnLeading = node.getStyle().computeInlineStartMargin(flexColumnDirection, direction, ownerWidth);
        node.setLayoutMargin(marginColumnLeading, YogaPhysicalEdge.TOP);
        float marginColumnTrailing = node.getStyle().computeInlineEndMargin(flexColumnDirection, direction, ownerWidth);
        node.setLayoutMargin(marginColumnTrailing, YogaPhysicalEdge.BOTTOM);
        float marginAxisRow = marginRowLeading + marginRowTrailing;
        float marginAxisColumn = marginColumnLeading + marginColumnTrailing;
        node.setLayoutBorder(node.getStyle().computeInlineStartBorder(flexRowDirection, direction), startEdge);
        node.setLayoutBorder(node.getStyle().computeInlineEndBorder(flexRowDirection, direction), endEdge);
        node.setLayoutBorder(node.getStyle().computeInlineStartBorder(flexColumnDirection, direction), YogaPhysicalEdge.TOP);
        node.setLayoutBorder(node.getStyle().computeInlineEndBorder(flexColumnDirection, direction), YogaPhysicalEdge.BOTTOM);
        node.setLayoutPadding(node.getStyle().computeInlineStartPadding(flexRowDirection, direction, ownerWidth), startEdge);
        node.setLayoutPadding(node.getStyle().computeInlineEndPadding(flexRowDirection, direction, ownerWidth), endEdge);
        node.setLayoutPadding(node.getStyle().computeInlineStartPadding(flexColumnDirection, direction, ownerWidth), YogaPhysicalEdge.TOP);
        node.setLayoutPadding(node.getStyle().computeInlineEndPadding(flexColumnDirection, direction, ownerWidth), YogaPhysicalEdge.BOTTOM);
        if (node.hasMeasureFunc()) {
            CalculateLayout.measureNodeWithMeasureFunc(node, direction, availableWidth - marginAxisRow, availableHeight - marginAxisColumn, widthSizingMode, heightSizingMode, ownerWidth, ownerHeight, layoutMarkerData, reason);
            CalculateLayout.cleanupContentsNodesRecursively(node);
            return;
        }
        int childCount = node.getLayoutChildCount();
        if (childCount == 0) {
            CalculateLayout.measureNodeWithoutChildren(node, direction, availableWidth - marginAxisRow, availableHeight - marginAxisColumn, widthSizingMode, heightSizingMode, ownerWidth, ownerHeight);
            CalculateLayout.cleanupContentsNodesRecursively(node);
            return;
        }
        if (!performLayout && CalculateLayout.measureNodeWithFixedSize(node, direction, availableWidth - marginAxisRow, availableHeight - marginAxisColumn, widthSizingMode, heightSizingMode, ownerWidth, ownerHeight)) {
            CalculateLayout.cleanupContentsNodesRecursively(node);
            return;
        }
        node.cloneChildrenIfNeeded();
        node.setLayoutHadOverflow(false);
        CalculateLayout.cleanupContentsNodesRecursively(node);
        YogaFlexDirection mainAxis = FlexDirectionUtil.resolveDirection(node.getStyle().getFlexDirection(), direction);
        YogaFlexDirection crossAxis = FlexDirectionUtil.resolveCrossDirection(mainAxis, direction);
        boolean isMainAxisRow = FlexDirectionUtil.isRow(mainAxis);
        boolean isNodeFlexWrap = node.getStyle().getFlexWrap() != YogaWrap.NO_WRAP;
        float mainAxisOwnerSize = isMainAxisRow ? ownerWidth : ownerHeight;
        float crossAxisOwnerSize = isMainAxisRow ? ownerHeight : ownerWidth;
        float paddingAndBorderAxisMain = BoundAxis.paddingAndBorderForAxis(node, mainAxis, direction, ownerWidth);
        float paddingAndBorderAxisCross = BoundAxis.paddingAndBorderForAxis(node, crossAxis, direction, ownerWidth);
        float leadingPaddingAndBorderCross = node.getStyle().computeFlexStartPaddingAndBorder(crossAxis, direction, ownerWidth);
        SizingMode sizingModeMainDim = isMainAxisRow ? widthSizingMode : heightSizingMode;
        SizingMode sizingModeCrossDim = isMainAxisRow ? heightSizingMode : widthSizingMode;
        float paddingAndBorderAxisRow = isMainAxisRow ? paddingAndBorderAxisMain : paddingAndBorderAxisCross;
        float paddingAndBorderAxisColumn = isMainAxisRow ? paddingAndBorderAxisCross : paddingAndBorderAxisMain;
        float availableInnerWidth = CalculateLayout.calculateAvailableInnerDimension(node, direction, YogaDimension.WIDTH, availableWidth - marginAxisRow, paddingAndBorderAxisRow, ownerWidth, ownerWidth);
        float availableInnerHeight = CalculateLayout.calculateAvailableInnerDimension(node, direction, YogaDimension.HEIGHT, availableHeight - marginAxisColumn, paddingAndBorderAxisColumn, ownerHeight, ownerWidth);
        float availableInnerMainDim = isMainAxisRow ? availableInnerWidth : availableInnerHeight;
        float availableInnerCrossDim = isMainAxisRow ? availableInnerHeight : availableInnerWidth;
        float totalMainDim = 0.0f;
        totalMainDim += CalculateLayout.computeFlexBasisForChildren(node, availableInnerWidth, availableInnerHeight, widthSizingMode, heightSizingMode, direction, mainAxis, performLayout, layoutMarkerData, depth, generationCount);
        if (childCount > 1) {
            totalMainDim += node.getStyle().computeGapForAxis(mainAxis, availableInnerMainDim) * (float)(childCount - 1);
        }
        boolean bl = mainAxisOverflows = sizingModeMainDim != SizingMode.MAX_CONTENT && totalMainDim > availableInnerMainDim;
        if (isNodeFlexWrap && mainAxisOverflows && sizingModeMainDim == SizingMode.FIT_CONTENT) {
            sizingModeMainDim = SizingMode.STRETCH_FIT;
        }
        LayoutableChildren.LayoutIterator startOfLineIterator = node.getLayoutChildren().iterator();
        int lineCount = 0;
        float totalLineCrossDim = 0.0f;
        float crossAxisGap = node.getStyle().computeGapForAxis(crossAxis, availableInnerCrossDim);
        float maxLineMainDim = 0.0f;
        while (startOfLineIterator.hasNext()) {
            FlexLine flexLine = FlexLine.calculateFlexLine(node, ownerDirection, ownerWidth, mainAxisOwnerSize, availableInnerWidth, availableInnerMainDim, startOfLineIterator, lineCount);
            boolean canSkipFlex = !performLayout && sizingModeCrossDim == SizingMode.STRETCH_FIT;
            boolean sizeBasedOnContent = false;
            if (sizingModeMainDim != SizingMode.STRETCH_FIT) {
                float maxInnerMainDim;
                YogaStyle style = node.getStyle();
                float minInnerWidth = style.resolveMinDimension(direction, YogaDimension.WIDTH, ownerWidth, ownerWidth).unwrap() - paddingAndBorderAxisRow;
                float maxInnerWidth = style.resolveMaxDimension(direction, YogaDimension.WIDTH, ownerWidth, ownerWidth).unwrap() - paddingAndBorderAxisRow;
                float minInnerHeight = style.resolveMinDimension(direction, YogaDimension.HEIGHT, ownerHeight, ownerWidth).unwrap() - paddingAndBorderAxisColumn;
                float maxInnerHeight = style.resolveMaxDimension(direction, YogaDimension.HEIGHT, ownerHeight, ownerWidth).unwrap() - paddingAndBorderAxisColumn;
                float minInnerMainDim = isMainAxisRow ? minInnerWidth : minInnerHeight;
                float f = maxInnerMainDim = isMainAxisRow ? maxInnerWidth : maxInnerHeight;
                if (Comparison.isDefined(minInnerMainDim) && flexLine.getSizeConsumed() < minInnerMainDim) {
                    availableInnerMainDim = minInnerMainDim;
                } else if (Comparison.isDefined(maxInnerMainDim) && flexLine.getSizeConsumed() > maxInnerMainDim) {
                    availableInnerMainDim = maxInnerMainDim;
                } else {
                    boolean useLegacyStretchBehaviour = node.hasErrata(YogaErrata.STRETCH_FLEX_BASIS);
                    if (!useLegacyStretchBehaviour && (Comparison.isDefined(flexLine.getLayout().getTotalFlexGrowFactors()) && flexLine.getLayout().getTotalFlexGrowFactors() == 0.0f || Comparison.isDefined(node.resolveFlexGrow()) && node.resolveFlexGrow() == 0.0f)) {
                        availableInnerMainDim = flexLine.getSizeConsumed();
                    }
                    boolean bl2 = sizeBasedOnContent = !useLegacyStretchBehaviour;
                }
            }
            if (!sizeBasedOnContent && Comparison.isDefined(availableInnerMainDim)) {
                flexLine.getLayout().setRemainingFreeSpace(availableInnerMainDim - flexLine.getSizeConsumed());
            } else if (flexLine.getSizeConsumed() < 0.0f) {
                flexLine.getLayout().setRemainingFreeSpace(-flexLine.getSizeConsumed());
            }
            if (!canSkipFlex) {
                CalculateLayout.resolveFlexibleLength(node, flexLine, mainAxis, crossAxis, direction, ownerWidth, mainAxisOwnerSize, availableInnerMainDim, availableInnerCrossDim, availableInnerWidth, availableInnerHeight, mainAxisOverflows, sizingModeCrossDim, performLayout, layoutMarkerData, depth, generationCount);
            }
            node.setLayoutHadOverflow(node.getLayout().hadOverflow() || flexLine.getLayout().getRemainingFreeSpace() < 0.0f);
            CalculateLayout.justifyMainAxis(node, flexLine, mainAxis, crossAxis, direction, sizingModeMainDim, sizingModeCrossDim, mainAxisOwnerSize, ownerWidth, availableInnerMainDim, availableInnerCrossDim, availableInnerWidth, performLayout);
            float containerCrossAxis = availableInnerCrossDim;
            if (sizingModeCrossDim == SizingMode.MAX_CONTENT || sizingModeCrossDim == SizingMode.FIT_CONTENT) {
                containerCrossAxis = BoundAxis.boundAxis(node, crossAxis, direction, flexLine.getLayout().getCrossDim() + paddingAndBorderAxisCross, crossAxisOwnerSize, ownerWidth) - paddingAndBorderAxisCross;
            }
            if (!isNodeFlexWrap && sizingModeCrossDim == SizingMode.STRETCH_FIT) {
                flexLine.getLayout().setCrossDim(availableInnerCrossDim);
            }
            if (!isNodeFlexWrap) {
                flexLine.getLayout().setCrossDim(BoundAxis.boundAxis(node, crossAxis, direction, flexLine.getLayout().getCrossDim() + paddingAndBorderAxisCross, crossAxisOwnerSize, ownerWidth) - paddingAndBorderAxisCross);
            }
            if (performLayout) {
                for (YogaNode child : flexLine.getItemsInFlow()) {
                    float leadingCrossDim = leadingPaddingAndBorderCross;
                    YogaAlign alignItem = AlignUtil.resolveChildAlignment(node, child);
                    if (alignItem == YogaAlign.STRETCH && !child.getStyle().flexStartMarginIsAuto(crossAxis, direction) && !child.getStyle().flexEndMarginIsAuto(crossAxis, direction)) {
                        if (!child.hasDefiniteLength(FlexDirectionUtil.dimension(crossAxis), availableInnerCrossDim)) {
                            float childMainSize = child.getLayout().measuredDimension(FlexDirectionUtil.dimension(mainAxis));
                            YogaStyle childStyle = child.getStyle();
                            float childCrossSize = childStyle.getAspectRatio().isDefined() ? child.getStyle().computeMarginForAxis(crossAxis, availableInnerWidth) + (isMainAxisRow ? childMainSize / childStyle.getAspectRatio().unwrap() : childMainSize * childStyle.getAspectRatio().unwrap()) : flexLine.getLayout().getCrossDim();
                            MaxSizeConstraint maxSizeConstraint = new MaxSizeConstraint();
                            maxSizeConstraint.constrainForMode(child, direction, mainAxis, availableInnerMainDim, availableInnerWidth, SizingMode.STRETCH_FIT, childMainSize += child.getStyle().computeMarginForAxis(mainAxis, availableInnerWidth));
                            childMainSize = maxSizeConstraint.size;
                            maxSizeConstraint.constrainForMode(child, direction, crossAxis, availableInnerCrossDim, availableInnerWidth, SizingMode.STRETCH_FIT, childCrossSize);
                            childCrossSize = maxSizeConstraint.size;
                            float childWidth = isMainAxisRow ? childMainSize : childCrossSize;
                            float childHeight = !isMainAxisRow ? childMainSize : childCrossSize;
                            YogaAlign alignContent = node.getStyle().getAlignContent();
                            boolean crossAxisDoesNotGrow = alignContent != YogaAlign.STRETCH && isNodeFlexWrap;
                            SizingMode childWidthSizingMode = Comparison.isUndefined(childWidth) || !isMainAxisRow && crossAxisDoesNotGrow ? SizingMode.MAX_CONTENT : SizingMode.STRETCH_FIT;
                            SizingMode childHeightSizingMode = Comparison.isUndefined(childHeight) || isMainAxisRow && crossAxisDoesNotGrow ? SizingMode.MAX_CONTENT : SizingMode.STRETCH_FIT;
                            CalculateLayout.calculateLayoutInternal(child, childWidth, childHeight, direction, childWidthSizingMode, childHeightSizingMode, availableInnerWidth, availableInnerHeight, true, LayoutPassReason.STRETCH, layoutMarkerData, depth, generationCount);
                        }
                    } else {
                        float remainingCrossDim = containerCrossAxis - child.dimensionWithMargin(crossAxis, availableInnerWidth);
                        if (child.getStyle().flexStartMarginIsAuto(crossAxis, direction) && child.getStyle().flexEndMarginIsAuto(crossAxis, direction)) {
                            leadingCrossDim += Comparison.maxOrDefined(0.0f, remainingCrossDim / 2.0f);
                        } else if (!child.getStyle().flexEndMarginIsAuto(crossAxis, direction)) {
                            if (child.getStyle().flexStartMarginIsAuto(crossAxis, direction)) {
                                leadingCrossDim += Comparison.maxOrDefined(0.0f, remainingCrossDim);
                            } else if (alignItem != YogaAlign.FLEX_START) {
                                leadingCrossDim = alignItem == YogaAlign.CENTER ? (leadingCrossDim += remainingCrossDim / 2.0f) : (leadingCrossDim += remainingCrossDim);
                            }
                        }
                    }
                    child.setLayoutPosition(child.getLayout().position(FlexDirectionUtil.flexStartEdge(crossAxis)) + totalLineCrossDim + leadingCrossDim, FlexDirectionUtil.flexStartEdge(crossAxis));
                }
            }
            float appliedCrossGap = lineCount != 0 ? crossAxisGap : 0.0f;
            totalLineCrossDim += flexLine.getLayout().getCrossDim() + appliedCrossGap;
            maxLineMainDim = Comparison.maxOrDefined(maxLineMainDim, flexLine.getLayout().getMainDim());
            ++lineCount;
        }
        if (performLayout && (isNodeFlexWrap || Baseline.isBaselineLayout(node))) {
            float leadPerLine = 0.0f;
            float currentLead = leadingPaddingAndBorderCross;
            float extraSpacePerLine = 0.0f;
            float unclampedCrossDim = sizingModeCrossDim == SizingMode.STRETCH_FIT ? availableInnerCrossDim + paddingAndBorderAxisCross : (node.hasDefiniteLength(FlexDirectionUtil.dimension(crossAxis), crossAxisOwnerSize) ? node.getResolvedDimension(direction, FlexDirectionUtil.dimension(crossAxis), crossAxisOwnerSize, ownerWidth).unwrap() : totalLineCrossDim + paddingAndBorderAxisCross);
            float innerCrossDim = BoundAxis.boundAxis(node, crossAxis, direction, unclampedCrossDim, crossAxisOwnerSize, ownerWidth) - paddingAndBorderAxisCross;
            float remainingAlignContentDim = innerCrossDim - totalLineCrossDim;
            YogaAlign alignContent = remainingAlignContentDim >= 0.0f ? node.getStyle().getAlignContent() : AlignUtil.fallbackAlignment(node.getStyle().getAlignContent());
            switch (alignContent) {
                case FLEX_END: {
                    currentLead += remainingAlignContentDim;
                    break;
                }
                case CENTER: {
                    currentLead += remainingAlignContentDim / 2.0f;
                    break;
                }
                case STRETCH: {
                    extraSpacePerLine = remainingAlignContentDim / (float)lineCount;
                    break;
                }
                case SPACE_AROUND: {
                    currentLead += remainingAlignContentDim / (2.0f * (float)lineCount);
                    leadPerLine = remainingAlignContentDim / (float)lineCount;
                    break;
                }
                case SPACE_EVENLY: {
                    currentLead += remainingAlignContentDim / (float)(lineCount + 1);
                    leadPerLine = remainingAlignContentDim / (float)(lineCount + 1);
                    break;
                }
                case SPACE_BETWEEN: {
                    if (lineCount <= 1) break;
                    leadPerLine = remainingAlignContentDim / (float)(lineCount - 1);
                    break;
                }
            }
            LayoutableChildren.LayoutIterator endIterator = node.getLayoutChildren().iterator();
            for (int i = 0; i < lineCount; ++i) {
                YogaNode child;
                LayoutableChildren.LayoutIterator startIterator = endIterator.copy();
                LayoutableChildren.LayoutIterator iterator = startIterator.copy();
                float lineHeight = 0.0f;
                float maxAscentForCurrentLine = 0.0f;
                float maxDescentForCurrentLine = 0.0f;
                while (iterator.hasNext()) {
                    child = iterator.current();
                    if (child.getStyle().getDisplay() != YogaDisplay.NONE && child.getStyle().getPositionType() != YogaPositionType.ABSOLUTE) {
                        if (child.getLineIndex() != i) break;
                        if (child.isLayoutDimensionDefined(crossAxis)) {
                            lineHeight = Comparison.maxOrDefined(lineHeight, child.getLayout().measuredDimension(FlexDirectionUtil.dimension(crossAxis)) + child.getStyle().computeMarginForAxis(crossAxis, availableInnerWidth));
                        }
                        if (AlignUtil.resolveChildAlignment(node, child) == YogaAlign.BASELINE) {
                            float ascent = Baseline.calculateBaseline(child) + child.getStyle().computeFlexStartMargin(YogaFlexDirection.COLUMN, direction, availableInnerWidth);
                            float descent = child.getLayout().measuredDimension(YogaDimension.HEIGHT) + child.getStyle().computeMarginForAxis(YogaFlexDirection.COLUMN, availableInnerWidth) - ascent;
                            maxAscentForCurrentLine = Comparison.maxOrDefined(maxAscentForCurrentLine, ascent);
                            maxDescentForCurrentLine = Comparison.maxOrDefined(maxDescentForCurrentLine, descent);
                            lineHeight = Comparison.maxOrDefined(lineHeight, maxAscentForCurrentLine + maxDescentForCurrentLine);
                        }
                    }
                    iterator.next();
                }
                endIterator = iterator.copy();
                currentLead += i != 0 ? crossAxisGap : 0.0f;
                lineHeight += extraSpacePerLine;
                iterator = startIterator;
                while (!iterator.equals(endIterator)) {
                    child = iterator.current();
                    if (child.getStyle().getDisplay() != YogaDisplay.NONE && child.getStyle().getPositionType() != YogaPositionType.ABSOLUTE) {
                        switch (AlignUtil.resolveChildAlignment(node, child)) {
                            case FLEX_START: {
                                child.setLayoutPosition(currentLead + child.getStyle().computeFlexStartPosition(crossAxis, direction, availableInnerWidth), FlexDirectionUtil.flexStartEdge(crossAxis));
                                break;
                            }
                            case FLEX_END: {
                                child.setLayoutPosition(currentLead + lineHeight - child.getStyle().computeFlexEndMargin(crossAxis, direction, availableInnerWidth) - child.getLayout().measuredDimension(FlexDirectionUtil.dimension(crossAxis)), FlexDirectionUtil.flexStartEdge(crossAxis));
                                break;
                            }
                            case CENTER: {
                                float childHeight = child.getLayout().measuredDimension(FlexDirectionUtil.dimension(crossAxis));
                                child.setLayoutPosition(currentLead + (lineHeight - childHeight) / 2.0f, FlexDirectionUtil.flexStartEdge(crossAxis));
                                break;
                            }
                            case STRETCH: {
                                float childHeight;
                                child.setLayoutPosition(currentLead + child.getStyle().computeFlexStartMargin(crossAxis, direction, availableInnerWidth), FlexDirectionUtil.flexStartEdge(crossAxis));
                                if (child.hasDefiniteLength(FlexDirectionUtil.dimension(crossAxis), availableInnerCrossDim)) break;
                                float childWidth = isMainAxisRow ? child.getLayout().measuredDimension(YogaDimension.WIDTH) + child.getStyle().computeMarginForAxis(mainAxis, availableInnerWidth) : leadPerLine + lineHeight;
                                float f = childHeight = !isMainAxisRow ? child.getLayout().measuredDimension(YogaDimension.HEIGHT) + child.getStyle().computeMarginForAxis(crossAxis, availableInnerWidth) : leadPerLine + lineHeight;
                                if (Comparison.inexactEquals(childWidth, child.getLayout().measuredDimension(YogaDimension.WIDTH)) && Comparison.inexactEquals(childHeight, child.getLayout().measuredDimension(YogaDimension.HEIGHT))) break;
                                CalculateLayout.calculateLayoutInternal(child, childWidth, childHeight, direction, SizingMode.STRETCH_FIT, SizingMode.STRETCH_FIT, availableInnerWidth, availableInnerHeight, true, LayoutPassReason.MULTILINE_STRETCH, layoutMarkerData, depth, generationCount);
                                break;
                            }
                            case BASELINE: {
                                child.setLayoutPosition(currentLead + maxAscentForCurrentLine - Baseline.calculateBaseline(child) + child.getStyle().computeFlexStartPosition(YogaFlexDirection.COLUMN, direction, availableInnerCrossDim), YogaPhysicalEdge.TOP);
                                break;
                            }
                        }
                    }
                    iterator.next();
                }
                currentLead = currentLead + leadPerLine + lineHeight;
            }
        }
        node.setLayoutMeasuredDimension(BoundAxis.boundAxis(node, YogaFlexDirection.ROW, direction, availableWidth - marginAxisRow, ownerWidth, ownerWidth), YogaDimension.WIDTH);
        node.setLayoutMeasuredDimension(BoundAxis.boundAxis(node, YogaFlexDirection.COLUMN, direction, availableHeight - marginAxisColumn, ownerHeight, ownerWidth), YogaDimension.HEIGHT);
        if (sizingModeMainDim == SizingMode.MAX_CONTENT || node.getStyle().getOverflow() != YogaOverflow.SCROLL && sizingModeMainDim == SizingMode.FIT_CONTENT) {
            node.setLayoutMeasuredDimension(BoundAxis.boundAxis(node, mainAxis, direction, maxLineMainDim, mainAxisOwnerSize, ownerWidth), FlexDirectionUtil.dimension(mainAxis));
        } else if (sizingModeMainDim == SizingMode.FIT_CONTENT && node.getStyle().getOverflow() == YogaOverflow.SCROLL) {
            node.setLayoutMeasuredDimension(Comparison.maxOrDefined(Comparison.minOrDefined(availableInnerMainDim + paddingAndBorderAxisMain, BoundAxis.boundAxisWithinMinAndMax(node, direction, mainAxis, FloatOptional.of(maxLineMainDim), mainAxisOwnerSize, ownerWidth).unwrap()), paddingAndBorderAxisMain), FlexDirectionUtil.dimension(mainAxis));
        }
        if (sizingModeCrossDim == SizingMode.MAX_CONTENT || node.getStyle().getOverflow() != YogaOverflow.SCROLL && sizingModeCrossDim == SizingMode.FIT_CONTENT) {
            node.setLayoutMeasuredDimension(BoundAxis.boundAxis(node, crossAxis, direction, totalLineCrossDim + paddingAndBorderAxisCross, crossAxisOwnerSize, ownerWidth), FlexDirectionUtil.dimension(crossAxis));
        } else if (sizingModeCrossDim == SizingMode.FIT_CONTENT && node.getStyle().getOverflow() == YogaOverflow.SCROLL) {
            node.setLayoutMeasuredDimension(Comparison.maxOrDefined(Comparison.minOrDefined(availableInnerCrossDim + paddingAndBorderAxisCross, BoundAxis.boundAxisWithinMinAndMax(node, direction, crossAxis, FloatOptional.of(totalLineCrossDim + paddingAndBorderAxisCross), crossAxisOwnerSize, ownerWidth).unwrap()), paddingAndBorderAxisCross), FlexDirectionUtil.dimension(crossAxis));
        }
        if (performLayout && node.getStyle().getFlexWrap() == YogaWrap.WRAP_REVERSE) {
            for (YogaNode child : node.getLayoutChildren()) {
                if (child.getStyle().getPositionType() == YogaPositionType.ABSOLUTE) continue;
                child.setLayoutPosition(node.getLayout().measuredDimension(FlexDirectionUtil.dimension(crossAxis)) - child.getLayout().position(FlexDirectionUtil.flexStartEdge(crossAxis)) - child.getLayout().measuredDimension(FlexDirectionUtil.dimension(crossAxis)), FlexDirectionUtil.flexStartEdge(crossAxis));
            }
        }
        if (performLayout) {
            boolean needsMainTrailingPos = TrailingPosition.needsTrailingPosition(mainAxis);
            boolean needsCrossTrailingPos = TrailingPosition.needsTrailingPosition(crossAxis);
            if (needsMainTrailingPos || needsCrossTrailingPos) {
                for (YogaNode child : node.getLayoutChildren()) {
                    if (child.getStyle().getDisplay() == YogaDisplay.NONE || child.getStyle().getPositionType() == YogaPositionType.ABSOLUTE) continue;
                    if (needsMainTrailingPos) {
                        TrailingPosition.setChildTrailingPosition(node, child, mainAxis);
                    }
                    if (!needsCrossTrailingPos) continue;
                    TrailingPosition.setChildTrailingPosition(node, child, crossAxis);
                }
            }
            if (node.getStyle().getPositionType() != YogaPositionType.STATIC || node.alwaysFormsContainingBlock() || depth == 1) {
                AbsoluteLayout.layoutAbsoluteDescendants(node, node, isMainAxisRow ? sizingModeMainDim : sizingModeCrossDim, direction, layoutMarkerData, depth, generationCount, 0.0f, 0.0f, availableInnerWidth, availableInnerHeight);
            }
        }
    }

    private static void computeFlexBasisForChild(YogaNode node, YogaNode child, float width, SizingMode widthMode, float height, float ownerWidth, float ownerHeight, SizingMode heightMode, YogaDirection direction, LayoutData layoutMarkerData, int depth, int generationCount) {
        YogaFlexDirection mainAxis = FlexDirectionUtil.resolveDirection(node.getStyle().getFlexDirection(), direction);
        boolean isMainAxisRow = FlexDirectionUtil.isRow(mainAxis);
        float mainAxisSize = isMainAxisRow ? width : height;
        float mainAxisOwnerSize = isMainAxisRow ? ownerWidth : ownerHeight;
        float childWidth = Float.NaN;
        float childHeight = Float.NaN;
        FloatOptional resolvedFlexBasis = child.resolveFlexBasis(direction, mainAxis, mainAxisOwnerSize, ownerWidth);
        boolean isRowStyleDimDefined = child.hasDefiniteLength(YogaDimension.WIDTH, ownerWidth);
        boolean isColumnStyleDimDefined = child.hasDefiniteLength(YogaDimension.HEIGHT, ownerHeight);
        if (resolvedFlexBasis.isDefined() && Comparison.isDefined(mainAxisSize)) {
            if (child.getLayout().computedFlexBasis.isUndefined() || child.getConfig().isExperimentalFeatureEnabled(YogaExperimentalFeature.WEB_FLEX_BASIS) && child.getLayout().computedFlexBasisGeneration != (long)generationCount) {
                FloatOptional paddingAndBorder = FloatOptional.of(BoundAxis.paddingAndBorderForAxis(child, mainAxis, direction, ownerWidth));
                child.setLayoutComputedFlexBasis(resolvedFlexBasis.maxOrDefined(paddingAndBorder));
            }
        } else if (isMainAxisRow && isRowStyleDimDefined) {
            FloatOptional paddingAndBorder = FloatOptional.of(BoundAxis.paddingAndBorderForAxis(child, YogaFlexDirection.ROW, direction, ownerWidth));
            child.setLayoutComputedFlexBasis(child.getResolvedDimension(direction, YogaDimension.WIDTH, ownerWidth, ownerWidth).maxOrDefined(paddingAndBorder));
        } else if (!isMainAxisRow && isColumnStyleDimDefined) {
            FloatOptional paddingAndBorder = FloatOptional.of(BoundAxis.paddingAndBorderForAxis(child, YogaFlexDirection.COLUMN, direction, ownerWidth));
            child.setLayoutComputedFlexBasis(child.getResolvedDimension(direction, YogaDimension.HEIGHT, ownerHeight, ownerWidth).maxOrDefined(paddingAndBorder));
        } else {
            boolean childHeightStretch;
            boolean childWidthStretch;
            YogaStyle childStyle;
            SizingMode childWidthSizingMode = SizingMode.MAX_CONTENT;
            SizingMode childHeightSizingMode = SizingMode.MAX_CONTENT;
            float marginRow = child.getStyle().computeMarginForAxis(YogaFlexDirection.ROW, ownerWidth);
            float marginColumn = child.getStyle().computeMarginForAxis(YogaFlexDirection.COLUMN, ownerWidth);
            if (isRowStyleDimDefined) {
                childWidth = child.getResolvedDimension(direction, YogaDimension.WIDTH, ownerWidth, ownerWidth).unwrap() + marginRow;
                childWidthSizingMode = SizingMode.STRETCH_FIT;
            }
            if (isColumnStyleDimDefined) {
                childHeight = child.getResolvedDimension(direction, YogaDimension.HEIGHT, ownerHeight, ownerWidth).unwrap() + marginColumn;
                childHeightSizingMode = SizingMode.STRETCH_FIT;
            }
            if ((!isMainAxisRow && node.getStyle().getOverflow() == YogaOverflow.SCROLL || node.getStyle().getOverflow() != YogaOverflow.SCROLL) && Comparison.isUndefined(childWidth) && Comparison.isDefined(width)) {
                childWidth = width;
                childWidthSizingMode = SizingMode.FIT_CONTENT;
            }
            if ((isMainAxisRow && node.getStyle().getOverflow() == YogaOverflow.SCROLL || node.getStyle().getOverflow() != YogaOverflow.SCROLL) && Comparison.isUndefined(childHeight) && Comparison.isDefined(height)) {
                childHeight = height;
                childHeightSizingMode = SizingMode.FIT_CONTENT;
            }
            if ((childStyle = child.getStyle()).getAspectRatio().isDefined()) {
                if (!isMainAxisRow && childWidthSizingMode == SizingMode.STRETCH_FIT) {
                    childHeight = marginColumn + (childWidth - marginRow) / childStyle.getAspectRatio().unwrap();
                    childHeightSizingMode = SizingMode.STRETCH_FIT;
                } else if (isMainAxisRow && childHeightSizingMode == SizingMode.STRETCH_FIT) {
                    childWidth = marginRow + (childHeight - marginColumn) * childStyle.getAspectRatio().unwrap();
                    childWidthSizingMode = SizingMode.STRETCH_FIT;
                }
            }
            boolean hasExactWidth = Comparison.isDefined(width) && widthMode == SizingMode.STRETCH_FIT;
            boolean bl = childWidthStretch = AlignUtil.resolveChildAlignment(node, child) == YogaAlign.STRETCH && childWidthSizingMode != SizingMode.STRETCH_FIT;
            if (!isMainAxisRow && !isRowStyleDimDefined && hasExactWidth && childWidthStretch) {
                childWidth = width;
                childWidthSizingMode = SizingMode.STRETCH_FIT;
                if (childStyle.getAspectRatio().isDefined()) {
                    childHeight = (childWidth - marginRow) / childStyle.getAspectRatio().unwrap();
                    childHeightSizingMode = SizingMode.STRETCH_FIT;
                }
            }
            boolean hasExactHeight = Comparison.isDefined(height) && heightMode == SizingMode.STRETCH_FIT;
            boolean bl2 = childHeightStretch = AlignUtil.resolveChildAlignment(node, child) == YogaAlign.STRETCH && childHeightSizingMode != SizingMode.STRETCH_FIT;
            if (isMainAxisRow && !isColumnStyleDimDefined && hasExactHeight && childHeightStretch) {
                childHeight = height;
                childHeightSizingMode = SizingMode.STRETCH_FIT;
                if (childStyle.getAspectRatio().isDefined()) {
                    childWidth = (childHeight - marginColumn) * childStyle.getAspectRatio().unwrap();
                    childWidthSizingMode = SizingMode.STRETCH_FIT;
                }
            }
            MaxSizeConstraint maxSizeConstraint = new MaxSizeConstraint();
            maxSizeConstraint.constrainForMode(child, direction, YogaFlexDirection.ROW, ownerWidth, ownerWidth, childWidthSizingMode, childWidth);
            childWidthSizingMode = maxSizeConstraint.mode;
            childWidth = maxSizeConstraint.size;
            maxSizeConstraint.constrainForMode(child, direction, YogaFlexDirection.COLUMN, ownerHeight, ownerWidth, childHeightSizingMode, childHeight);
            childHeightSizingMode = maxSizeConstraint.mode;
            childHeight = maxSizeConstraint.size;
            CalculateLayout.calculateLayoutInternal(child, childWidth, childHeight, direction, childWidthSizingMode, childHeightSizingMode, ownerWidth, ownerHeight, false, LayoutPassReason.MEASURE_CHILD, layoutMarkerData, depth, generationCount);
            child.setLayoutComputedFlexBasis(FloatOptional.of(Comparison.maxOrDefined(child.getLayout().measuredDimension(FlexDirectionUtil.dimension(mainAxis)), BoundAxis.paddingAndBorderForAxis(child, mainAxis, direction, ownerWidth))));
        }
        child.setLayoutComputedFlexBasisGeneration(generationCount);
    }

    private static void measureNodeWithMeasureFunc(YogaNode node, YogaDirection direction, float availableWidth, float availableHeight, SizingMode widthSizingMode, SizingMode heightSizingMode, float ownerWidth, float ownerHeight, LayoutData layoutMarkerData, LayoutPassReason reason) {
        float innerHeight;
        assert (node.hasMeasureFunc()) : "Expected node to have custom measure function";
        if (widthSizingMode == SizingMode.MAX_CONTENT) {
            availableWidth = Float.NaN;
        }
        if (heightSizingMode == SizingMode.MAX_CONTENT) {
            availableHeight = Float.NaN;
        }
        LayoutResults layout = node.getLayout();
        float paddingAndBorderAxisRow = layout.padding(YogaPhysicalEdge.LEFT) + layout.padding(YogaPhysicalEdge.RIGHT) + layout.border(YogaPhysicalEdge.LEFT) + layout.border(YogaPhysicalEdge.RIGHT);
        float paddingAndBorderAxisColumn = layout.padding(YogaPhysicalEdge.TOP) + layout.padding(YogaPhysicalEdge.BOTTOM) + layout.border(YogaPhysicalEdge.TOP) + layout.border(YogaPhysicalEdge.BOTTOM);
        float innerWidth = Comparison.isUndefined(availableWidth) ? availableWidth : Comparison.maxOrDefined(0.0f, availableWidth - paddingAndBorderAxisRow);
        float f = innerHeight = Comparison.isUndefined(availableHeight) ? availableHeight : Comparison.maxOrDefined(0.0f, availableHeight - paddingAndBorderAxisColumn);
        if (widthSizingMode == SizingMode.STRETCH_FIT && heightSizingMode == SizingMode.STRETCH_FIT) {
            node.setLayoutMeasuredDimension(BoundAxis.boundAxis(node, YogaFlexDirection.ROW, direction, availableWidth, ownerWidth, ownerWidth), YogaDimension.WIDTH);
            node.setLayoutMeasuredDimension(BoundAxis.boundAxis(node, YogaFlexDirection.COLUMN, direction, availableHeight, ownerHeight, ownerWidth), YogaDimension.HEIGHT);
        } else {
            YogaEvent.publish(YogaEventType.MEASURE_CALLBACK_START, node);
            YogaSize measuredSize = node.measure(innerWidth, SizingMode.measureMode(widthSizingMode), innerHeight, SizingMode.measureMode(heightSizingMode));
            ++layoutMarkerData.measureCallbacks;
            int n = reason.ordinal();
            layoutMarkerData.measureCallbackReasonsCount[n] = layoutMarkerData.measureCallbackReasonsCount[n] + 1;
            YogaEvent.publish(node, YogaEventType.MEASURE_CALLBACK_END, new YogaEvent.MeasureCallbackEndData(innerWidth, SizingMode.measureMode(widthSizingMode), innerHeight, SizingMode.measureMode(heightSizingMode), measuredSize.width(), measuredSize.height(), reason));
            node.setLayoutMeasuredDimension(BoundAxis.boundAxis(node, YogaFlexDirection.ROW, direction, widthSizingMode == SizingMode.MAX_CONTENT || widthSizingMode == SizingMode.FIT_CONTENT ? measuredSize.width() + paddingAndBorderAxisRow : availableWidth, ownerWidth, ownerWidth), YogaDimension.WIDTH);
            node.setLayoutMeasuredDimension(BoundAxis.boundAxis(node, YogaFlexDirection.COLUMN, direction, heightSizingMode == SizingMode.MAX_CONTENT || heightSizingMode == SizingMode.FIT_CONTENT ? measuredSize.height() + paddingAndBorderAxisColumn : availableHeight, ownerHeight, ownerWidth), YogaDimension.HEIGHT);
        }
    }

    private static void measureNodeWithoutChildren(YogaNode node, YogaDirection direction, float availableWidth, float availableHeight, SizingMode widthSizingMode, SizingMode heightSizingMode, float ownerWidth, float ownerHeight) {
        LayoutResults layout = node.getLayout();
        float width = availableWidth;
        if (widthSizingMode == SizingMode.MAX_CONTENT || widthSizingMode == SizingMode.FIT_CONTENT) {
            width = layout.padding(YogaPhysicalEdge.LEFT) + layout.padding(YogaPhysicalEdge.RIGHT) + layout.border(YogaPhysicalEdge.LEFT) + layout.border(YogaPhysicalEdge.RIGHT);
        }
        node.setLayoutMeasuredDimension(BoundAxis.boundAxis(node, YogaFlexDirection.ROW, direction, width, ownerWidth, ownerWidth), YogaDimension.WIDTH);
        float height = availableHeight;
        if (heightSizingMode == SizingMode.MAX_CONTENT || heightSizingMode == SizingMode.FIT_CONTENT) {
            height = layout.padding(YogaPhysicalEdge.TOP) + layout.padding(YogaPhysicalEdge.BOTTOM) + layout.border(YogaPhysicalEdge.TOP) + layout.border(YogaPhysicalEdge.BOTTOM);
        }
        node.setLayoutMeasuredDimension(BoundAxis.boundAxis(node, YogaFlexDirection.COLUMN, direction, height, ownerHeight, ownerWidth), YogaDimension.HEIGHT);
    }

    private static boolean measureNodeWithFixedSize(YogaNode node, YogaDirection direction, float availableWidth, float availableHeight, SizingMode widthSizingMode, SizingMode heightSizingMode, float ownerWidth, float ownerHeight) {
        if (Comparison.isDefined(availableWidth) && widthSizingMode == SizingMode.FIT_CONTENT && availableWidth <= 0.0f || Comparison.isDefined(availableHeight) && heightSizingMode == SizingMode.FIT_CONTENT && availableHeight <= 0.0f || widthSizingMode == SizingMode.STRETCH_FIT && heightSizingMode == SizingMode.STRETCH_FIT) {
            node.setLayoutMeasuredDimension(BoundAxis.boundAxis(node, YogaFlexDirection.ROW, direction, Comparison.isUndefined(availableWidth) || widthSizingMode == SizingMode.FIT_CONTENT && availableWidth < 0.0f ? 0.0f : availableWidth, ownerWidth, ownerWidth), YogaDimension.WIDTH);
            node.setLayoutMeasuredDimension(BoundAxis.boundAxis(node, YogaFlexDirection.COLUMN, direction, Comparison.isUndefined(availableHeight) || heightSizingMode == SizingMode.FIT_CONTENT && availableHeight < 0.0f ? 0.0f : availableHeight, ownerHeight, ownerWidth), YogaDimension.HEIGHT);
            return true;
        }
        return false;
    }

    private static void zeroOutLayoutRecursively(YogaNode node) {
        node.getLayout().reset();
        node.setLayoutDimension(0.0f, YogaDimension.WIDTH);
        node.setLayoutDimension(0.0f, YogaDimension.HEIGHT);
        node.setHasNewLayout(true);
        node.cloneChildrenIfNeeded();
        for (YogaNode child : node.getChildren()) {
            CalculateLayout.zeroOutLayoutRecursively(child);
        }
    }

    private static void cleanupContentsNodesRecursively(YogaNode node) {
        for (YogaNode child : node.getChildren()) {
            if (child.getStyle().getDisplay() != YogaDisplay.CONTENTS) continue;
            child.getLayout().reset();
            child.setLayoutDimension(0.0f, YogaDimension.WIDTH);
            child.setLayoutDimension(0.0f, YogaDimension.HEIGHT);
            child.setHasNewLayout(true);
            child.setDirty(false);
            child.cloneChildrenIfNeeded();
            CalculateLayout.cleanupContentsNodesRecursively(child);
        }
    }

    private static float calculateAvailableInnerDimension(YogaNode node, YogaDirection direction, YogaDimension dimension, float availableDim, float paddingAndBorder, float ownerDim, float ownerWidth) {
        float availableInnerDim = availableDim - paddingAndBorder;
        if (Comparison.isDefined(availableInnerDim)) {
            FloatOptional minDimensionOptional = node.getStyle().resolveMinDimension(direction, dimension, ownerDim, ownerWidth);
            float minInnerDim = minDimensionOptional.isUndefined() ? 0.0f : minDimensionOptional.unwrap() - paddingAndBorder;
            FloatOptional maxDimensionOptional = node.getStyle().resolveMaxDimension(direction, dimension, ownerDim, ownerWidth);
            float maxInnerDim = maxDimensionOptional.isUndefined() ? Float.MAX_VALUE : maxDimensionOptional.unwrap() - paddingAndBorder;
            availableInnerDim = Comparison.maxOrDefined(Comparison.minOrDefined(availableInnerDim, maxInnerDim), minInnerDim);
        }
        return availableInnerDim;
    }

    private static float computeFlexBasisForChildren(YogaNode node, float availableInnerWidth, float availableInnerHeight, SizingMode widthSizingMode, SizingMode heightSizingMode, YogaDirection direction, YogaFlexDirection mainAxis, boolean performLayout, LayoutData layoutMarkerData, int depth, int generationCount) {
        SizingMode sizingModeMainDim;
        float totalOuterFlexBasis = 0.0f;
        YogaNode singleFlexChild = null;
        LayoutableChildren children = node.getLayoutChildren();
        SizingMode sizingMode = sizingModeMainDim = FlexDirectionUtil.isRow(mainAxis) ? widthSizingMode : heightSizingMode;
        if (sizingModeMainDim == SizingMode.STRETCH_FIT) {
            for (YogaNode child : children) {
                if (!child.isNodeFlexible()) continue;
                if (singleFlexChild != null || Comparison.inexactEquals(child.resolveFlexGrow(), 0.0f) || Comparison.inexactEquals(child.resolveFlexShrink(), 0.0f)) {
                    singleFlexChild = null;
                    break;
                }
                singleFlexChild = child;
            }
        }
        for (YogaNode child : children) {
            child.processDimensions();
            if (child.getStyle().getDisplay() == YogaDisplay.NONE) {
                CalculateLayout.zeroOutLayoutRecursively(child);
                child.setHasNewLayout(true);
                child.setDirty(false);
                continue;
            }
            if (performLayout) {
                YogaDirection childDirection = child.resolveDirection(direction);
                child.setPosition(childDirection, availableInnerWidth, availableInnerHeight);
            }
            if (child.getStyle().getPositionType() == YogaPositionType.ABSOLUTE) continue;
            if (child == singleFlexChild) {
                child.setLayoutComputedFlexBasisGeneration(generationCount);
                child.setLayoutComputedFlexBasis(FloatOptional.of(0.0f));
            } else {
                CalculateLayout.computeFlexBasisForChild(node, child, availableInnerWidth, widthSizingMode, availableInnerHeight, availableInnerWidth, availableInnerHeight, heightSizingMode, direction, layoutMarkerData, depth, generationCount);
            }
            totalOuterFlexBasis += child.getLayout().computedFlexBasis.unwrap() + child.getStyle().computeMarginForAxis(mainAxis, availableInnerWidth);
        }
        return totalOuterFlexBasis;
    }

    private static float distributeFreeSpaceSecondPass(FlexLine flexLine, YogaNode node, YogaFlexDirection mainAxis, YogaFlexDirection crossAxis, YogaDirection direction, float ownerWidth, float mainAxisOwnerSize, float availableInnerMainDim, float availableInnerCrossDim, float availableInnerWidth, float availableInnerHeight, boolean mainAxisOverflows, SizingMode sizingModeCrossDim, boolean performLayout, LayoutData layoutMarkerData, int depth, int generationCount) {
        float childFlexBasis = 0.0f;
        float flexShrinkScaledFactor = 0.0f;
        float flexGrowFactor = 0.0f;
        float deltaFreeSpace = 0.0f;
        boolean isMainAxisRow = FlexDirectionUtil.isRow(mainAxis);
        boolean isNodeFlexWrap = node.getStyle().getFlexWrap() != YogaWrap.NO_WRAP;
        for (YogaNode currentLineChild : flexLine.getItemsInFlow()) {
            SizingMode childCrossSizingMode;
            float updatedMainSize = childFlexBasis = BoundAxis.boundAxisWithinMinAndMax(currentLineChild, direction, mainAxis, currentLineChild.getLayout().computedFlexBasis, mainAxisOwnerSize, ownerWidth).unwrap();
            if (Comparison.isDefined(flexLine.getLayout().getRemainingFreeSpace()) && flexLine.getLayout().getRemainingFreeSpace() < 0.0f) {
                flexShrinkScaledFactor = -currentLineChild.resolveFlexShrink() * childFlexBasis;
                if (flexShrinkScaledFactor != 0.0f) {
                    float childSize = Float.NaN;
                    childSize = Comparison.isDefined(flexLine.getLayout().getTotalFlexShrinkScaledFactors()) && flexLine.getLayout().getTotalFlexShrinkScaledFactors() == 0.0f ? childFlexBasis + flexShrinkScaledFactor : childFlexBasis + flexLine.getLayout().getRemainingFreeSpace() / flexLine.getLayout().getTotalFlexShrinkScaledFactors() * flexShrinkScaledFactor;
                    updatedMainSize = BoundAxis.boundAxis(currentLineChild, mainAxis, direction, childSize, availableInnerMainDim, availableInnerWidth);
                }
            } else if (Comparison.isDefined(flexLine.getLayout().getRemainingFreeSpace()) && flexLine.getLayout().getRemainingFreeSpace() > 0.0f && !Float.isNaN(flexGrowFactor = currentLineChild.resolveFlexGrow()) && flexGrowFactor != 0.0f) {
                updatedMainSize = BoundAxis.boundAxis(currentLineChild, mainAxis, direction, childFlexBasis + flexLine.getLayout().getRemainingFreeSpace() / flexLine.getLayout().getTotalFlexGrowFactors() * flexGrowFactor, availableInnerMainDim, availableInnerWidth);
            }
            deltaFreeSpace += updatedMainSize - childFlexBasis;
            float marginMain = currentLineChild.getStyle().computeMarginForAxis(mainAxis, availableInnerWidth);
            float marginCross = currentLineChild.getStyle().computeMarginForAxis(crossAxis, availableInnerWidth);
            float childCrossSize = Float.NaN;
            float childMainSize = updatedMainSize + marginMain;
            SizingMode childMainSizingMode = SizingMode.STRETCH_FIT;
            YogaStyle childStyle = currentLineChild.getStyle();
            if (childStyle.getAspectRatio().isDefined()) {
                childCrossSize = isMainAxisRow ? (childMainSize - marginMain) / childStyle.getAspectRatio().unwrap() : (childMainSize - marginMain) * childStyle.getAspectRatio().unwrap();
                childCrossSizingMode = SizingMode.STRETCH_FIT;
                childCrossSize += marginCross;
            } else if (!(Float.isNaN(availableInnerCrossDim) || currentLineChild.hasDefiniteLength(FlexDirectionUtil.dimension(crossAxis), availableInnerCrossDim) || sizingModeCrossDim != SizingMode.STRETCH_FIT || isNodeFlexWrap && mainAxisOverflows || AlignUtil.resolveChildAlignment(node, currentLineChild) != YogaAlign.STRETCH || currentLineChild.getStyle().flexStartMarginIsAuto(crossAxis, direction) || currentLineChild.getStyle().flexEndMarginIsAuto(crossAxis, direction))) {
                childCrossSize = availableInnerCrossDim;
                childCrossSizingMode = SizingMode.STRETCH_FIT;
            } else if (!currentLineChild.hasDefiniteLength(FlexDirectionUtil.dimension(crossAxis), availableInnerCrossDim)) {
                childCrossSize = availableInnerCrossDim;
                childCrossSizingMode = Comparison.isUndefined(childCrossSize) ? SizingMode.MAX_CONTENT : SizingMode.FIT_CONTENT;
            } else {
                childCrossSize = currentLineChild.getResolvedDimension(direction, FlexDirectionUtil.dimension(crossAxis), availableInnerCrossDim, availableInnerWidth).unwrap() + marginCross;
                boolean isLoosePercentageMeasurement = currentLineChild.getProcessedDimension(FlexDirectionUtil.dimension(crossAxis)).isPercent() && sizingModeCrossDim != SizingMode.STRETCH_FIT;
                childCrossSizingMode = Comparison.isUndefined(childCrossSize) || isLoosePercentageMeasurement ? SizingMode.MAX_CONTENT : SizingMode.STRETCH_FIT;
            }
            MaxSizeConstraint maxSizeConstraint = new MaxSizeConstraint();
            maxSizeConstraint.constrainForMode(currentLineChild, direction, mainAxis, availableInnerMainDim, availableInnerWidth, childMainSizingMode, childMainSize);
            childMainSizingMode = maxSizeConstraint.mode;
            childMainSize = maxSizeConstraint.size;
            maxSizeConstraint.constrainForMode(currentLineChild, direction, crossAxis, availableInnerCrossDim, availableInnerWidth, childCrossSizingMode, childCrossSize);
            childCrossSizingMode = maxSizeConstraint.mode;
            childCrossSize = maxSizeConstraint.size;
            boolean requiresStretchLayout = !currentLineChild.hasDefiniteLength(FlexDirectionUtil.dimension(crossAxis), availableInnerCrossDim) && AlignUtil.resolveChildAlignment(node, currentLineChild) == YogaAlign.STRETCH && !currentLineChild.getStyle().flexStartMarginIsAuto(crossAxis, direction) && !currentLineChild.getStyle().flexEndMarginIsAuto(crossAxis, direction);
            float childWidth = isMainAxisRow ? childMainSize : childCrossSize;
            float childHeight = !isMainAxisRow ? childMainSize : childCrossSize;
            SizingMode childWidthSizingMode = isMainAxisRow ? childMainSizingMode : childCrossSizingMode;
            SizingMode childHeightSizingMode = !isMainAxisRow ? childMainSizingMode : childCrossSizingMode;
            boolean isLayoutPass = performLayout && !requiresStretchLayout;
            CalculateLayout.calculateLayoutInternal(currentLineChild, childWidth, childHeight, node.getLayout().direction(), childWidthSizingMode, childHeightSizingMode, availableInnerWidth, availableInnerHeight, isLayoutPass, isLayoutPass ? LayoutPassReason.FLEX_LAYOUT : LayoutPassReason.FLEX_MEASURE, layoutMarkerData, depth, generationCount);
            node.setLayoutHadOverflow(node.getLayout().hadOverflow() || currentLineChild.getLayout().hadOverflow());
        }
        return deltaFreeSpace;
    }

    private static void distributeFreeSpaceFirstPass(FlexLine flexLine, YogaDirection direction, YogaFlexDirection mainAxis, float ownerWidth, float mainAxisOwnerSize, float availableInnerMainDim, float availableInnerWidth) {
        float flexShrinkScaledFactor = 0.0f;
        float flexGrowFactor = 0.0f;
        float baseMainSize = 0.0f;
        float boundMainSize = 0.0f;
        float deltaFreeSpace = 0.0f;
        for (YogaNode currentLineChild : flexLine.getItemsInFlow()) {
            float childFlexBasis = BoundAxis.boundAxisWithinMinAndMax(currentLineChild, direction, mainAxis, currentLineChild.getLayout().computedFlexBasis, mainAxisOwnerSize, ownerWidth).unwrap();
            if (flexLine.getLayout().getRemainingFreeSpace() < 0.0f) {
                flexShrinkScaledFactor = -currentLineChild.resolveFlexShrink() * childFlexBasis;
                if (!Comparison.isDefined(flexShrinkScaledFactor) || flexShrinkScaledFactor == 0.0f) continue;
                baseMainSize = childFlexBasis + flexLine.getLayout().getRemainingFreeSpace() / flexLine.getLayout().getTotalFlexShrinkScaledFactors() * flexShrinkScaledFactor;
                boundMainSize = BoundAxis.boundAxis(currentLineChild, mainAxis, direction, baseMainSize, availableInnerMainDim, availableInnerWidth);
                if (!Comparison.isDefined(baseMainSize) || !Comparison.isDefined(boundMainSize) || baseMainSize == boundMainSize) continue;
                deltaFreeSpace += boundMainSize - childFlexBasis;
                flexLine.getLayout().setTotalFlexShrinkScaledFactors(flexLine.getLayout().getTotalFlexShrinkScaledFactors() - -currentLineChild.resolveFlexShrink() * currentLineChild.getLayout().computedFlexBasis.unwrap());
                continue;
            }
            if (!Comparison.isDefined(flexLine.getLayout().getRemainingFreeSpace()) || !(flexLine.getLayout().getRemainingFreeSpace() > 0.0f) || !Comparison.isDefined(flexGrowFactor = currentLineChild.resolveFlexGrow()) || flexGrowFactor == 0.0f) continue;
            baseMainSize = childFlexBasis + flexLine.getLayout().getRemainingFreeSpace() / flexLine.getLayout().getTotalFlexGrowFactors() * flexGrowFactor;
            boundMainSize = BoundAxis.boundAxis(currentLineChild, mainAxis, direction, baseMainSize, availableInnerMainDim, availableInnerWidth);
            if (!Comparison.isDefined(baseMainSize) || !Comparison.isDefined(boundMainSize) || baseMainSize == boundMainSize) continue;
            deltaFreeSpace += boundMainSize - childFlexBasis;
            flexLine.getLayout().setTotalFlexGrowFactors(flexLine.getLayout().getTotalFlexGrowFactors() - flexGrowFactor);
        }
        flexLine.getLayout().setRemainingFreeSpace(flexLine.getLayout().getRemainingFreeSpace() - deltaFreeSpace);
    }

    private static void resolveFlexibleLength(YogaNode node, FlexLine flexLine, YogaFlexDirection mainAxis, YogaFlexDirection crossAxis, YogaDirection direction, float ownerWidth, float mainAxisOwnerSize, float availableInnerMainDim, float availableInnerCrossDim, float availableInnerWidth, float availableInnerHeight, boolean mainAxisOverflows, SizingMode sizingModeCrossDim, boolean performLayout, LayoutData layoutMarkerData, int depth, int generationCount) {
        float originalFreeSpace = flexLine.getLayout().getRemainingFreeSpace();
        CalculateLayout.distributeFreeSpaceFirstPass(flexLine, direction, mainAxis, ownerWidth, mainAxisOwnerSize, availableInnerMainDim, availableInnerWidth);
        float distributedFreeSpace = CalculateLayout.distributeFreeSpaceSecondPass(flexLine, node, mainAxis, crossAxis, direction, ownerWidth, mainAxisOwnerSize, availableInnerMainDim, availableInnerCrossDim, availableInnerWidth, availableInnerHeight, mainAxisOverflows, sizingModeCrossDim, performLayout, layoutMarkerData, depth, generationCount);
        flexLine.getLayout().setRemainingFreeSpace(originalFreeSpace - distributedFreeSpace);
    }

    private static void justifyMainAxis(YogaNode node, FlexLine flexLine, YogaFlexDirection mainAxis, YogaFlexDirection crossAxis, YogaDirection direction, SizingMode sizingModeMainDim, SizingMode sizingModeCrossDim, float mainAxisOwnerSize, float ownerWidth, float availableInnerMainDim, float availableInnerCrossDim, float availableInnerWidth, boolean performLayout) {
        YogaJustify justifyContent;
        YogaStyle style = node.getStyle();
        float leadingPaddingAndBorderMain = node.getStyle().computeFlexStartPaddingAndBorder(mainAxis, direction, ownerWidth);
        float trailingPaddingAndBorderMain = node.getStyle().computeFlexEndPaddingAndBorder(mainAxis, direction, ownerWidth);
        float gap = node.getStyle().computeGapForAxis(mainAxis, availableInnerMainDim);
        if (sizingModeMainDim == SizingMode.FIT_CONTENT && flexLine.getLayout().getRemainingFreeSpace() > 0.0f) {
            if (style.getMinDimension(FlexDirectionUtil.dimension(mainAxis)).isDefined() && style.resolveMinDimension(direction, FlexDirectionUtil.dimension(mainAxis), mainAxisOwnerSize, ownerWidth).isDefined()) {
                float minAvailableMainDim = style.resolveMinDimension(direction, FlexDirectionUtil.dimension(mainAxis), mainAxisOwnerSize, ownerWidth).unwrap() - leadingPaddingAndBorderMain - trailingPaddingAndBorderMain;
                float occupiedSpaceByChildNodes = availableInnerMainDim - flexLine.getLayout().getRemainingFreeSpace();
                flexLine.getLayout().setRemainingFreeSpace(Comparison.maxOrDefined(0.0f, minAvailableMainDim - occupiedSpaceByChildNodes));
            } else {
                flexLine.getLayout().setRemainingFreeSpace(0.0f);
            }
        }
        float leadingMainDim = 0.0f;
        float betweenMainDim = gap;
        YogaJustify yogaJustify = justifyContent = flexLine.getLayout().getRemainingFreeSpace() >= 0.0f ? node.getStyle().getJustifyContent() : AlignUtil.fallbackAlignment(node.getStyle().getJustifyContent());
        if (flexLine.getNumberOfAutoMargins() == 0) {
            switch (justifyContent) {
                case CENTER: {
                    leadingMainDim = flexLine.getLayout().getRemainingFreeSpace() / 2.0f;
                    break;
                }
                case FLEX_END: {
                    leadingMainDim = flexLine.getLayout().getRemainingFreeSpace();
                    break;
                }
                case SPACE_BETWEEN: {
                    if (flexLine.getItemsInFlow().size() <= 1) break;
                    betweenMainDim += flexLine.getLayout().getRemainingFreeSpace() / (float)(flexLine.getItemsInFlow().size() - 1);
                    break;
                }
                case SPACE_EVENLY: {
                    leadingMainDim = flexLine.getLayout().getRemainingFreeSpace() / (float)(flexLine.getItemsInFlow().size() + 1);
                    betweenMainDim += leadingMainDim;
                    break;
                }
                case SPACE_AROUND: {
                    leadingMainDim = 0.5f * flexLine.getLayout().getRemainingFreeSpace() / (float)flexLine.getItemsInFlow().size();
                    betweenMainDim += leadingMainDim * 2.0f;
                    break;
                }
            }
        }
        flexLine.getLayout().setMainDim(leadingPaddingAndBorderMain + leadingMainDim);
        flexLine.getLayout().setCrossDim(0.0f);
        float maxAscentForCurrentLine = 0.0f;
        float maxDescentForCurrentLine = 0.0f;
        boolean isNodeBaselineLayout = Baseline.isBaselineLayout(node);
        Iterator<YogaNode> it = flexLine.getItemsInFlow().iterator();
        while (it.hasNext()) {
            boolean canSkipFlex;
            YogaNode child = it.next();
            LayoutResults childLayout = child.getLayout();
            if (child.getStyle().flexStartMarginIsAuto(mainAxis, direction) && flexLine.getLayout().getRemainingFreeSpace() > 0.0f) {
                flexLine.getLayout().setMainDim(flexLine.getLayout().getMainDim() + flexLine.getLayout().getRemainingFreeSpace() / (float)flexLine.getNumberOfAutoMargins());
            }
            if (performLayout) {
                child.setLayoutPosition(childLayout.position(FlexDirectionUtil.flexStartEdge(mainAxis)) + flexLine.getLayout().getMainDim(), FlexDirectionUtil.flexStartEdge(mainAxis));
            }
            if (it.hasNext()) {
                flexLine.getLayout().setMainDim(flexLine.getLayout().getMainDim() + betweenMainDim);
            }
            if (child.getStyle().flexEndMarginIsAuto(mainAxis, direction) && flexLine.getLayout().getRemainingFreeSpace() > 0.0f) {
                flexLine.getLayout().setMainDim(flexLine.getLayout().getMainDim() + flexLine.getLayout().getRemainingFreeSpace() / (float)flexLine.getNumberOfAutoMargins());
            }
            boolean bl = canSkipFlex = !performLayout && sizingModeCrossDim == SizingMode.STRETCH_FIT;
            if (canSkipFlex) {
                flexLine.getLayout().setMainDim(flexLine.getLayout().getMainDim() + child.getStyle().computeMarginForAxis(mainAxis, availableInnerWidth) + childLayout.computedFlexBasis.unwrap());
                flexLine.getLayout().setCrossDim(availableInnerCrossDim);
                continue;
            }
            flexLine.getLayout().setMainDim(flexLine.getLayout().getMainDim() + child.dimensionWithMargin(mainAxis, availableInnerWidth));
            if (isNodeBaselineLayout) {
                float ascent = Baseline.calculateBaseline(child) + child.getStyle().computeFlexStartMargin(YogaFlexDirection.COLUMN, direction, availableInnerWidth);
                float descent = child.getLayout().measuredDimension(YogaDimension.HEIGHT) + child.getStyle().computeMarginForAxis(YogaFlexDirection.COLUMN, availableInnerWidth) - ascent;
                maxAscentForCurrentLine = Comparison.maxOrDefined(maxAscentForCurrentLine, ascent);
                maxDescentForCurrentLine = Comparison.maxOrDefined(maxDescentForCurrentLine, descent);
                continue;
            }
            flexLine.getLayout().setCrossDim(Comparison.maxOrDefined(flexLine.getLayout().getCrossDim(), child.dimensionWithMargin(crossAxis, availableInnerWidth)));
        }
        flexLine.getLayout().setMainDim(flexLine.getLayout().getMainDim() + trailingPaddingAndBorderMain);
        if (isNodeBaselineLayout) {
            flexLine.getLayout().setCrossDim(maxAscentForCurrentLine + maxDescentForCurrentLine);
        }
    }

    private static class MaxSizeConstraint {
        SizingMode mode;
        float size;

        private MaxSizeConstraint() {
        }

        public void constrainForMode(YogaNode node, YogaDirection direction, YogaFlexDirection axis, float ownerAxisSize, float ownerWidth, SizingMode mode, float size) {
            this.mode = mode;
            this.size = size;
            FloatOptional maxSize = node.getStyle().resolveMaxDimension(direction, FlexDirectionUtil.dimension(axis), ownerAxisSize, ownerWidth).add(FloatOptional.of(node.getStyle().computeMarginForAxis(axis, ownerWidth)));
            switch (this.mode) {
                case STRETCH_FIT: 
                case FIT_CONTENT: {
                    if (maxSize.isUndefined() || this.size < maxSize.unwrap()) break;
                    this.size = maxSize.unwrap();
                    break;
                }
                case MAX_CONTENT: {
                    if (!maxSize.isDefined()) break;
                    this.mode = SizingMode.FIT_CONTENT;
                    this.size = maxSize.unwrap();
                }
            }
        }
    }
}

