/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event;

import io.homo.superresolution.thirdparty.yoga.appliedenergistics.yoga.event.LayoutPassReason;
import java.util.Objects;

public final class LayoutData {
    public int layouts;
    public int measures;
    public int maxMeasureCache;
    public int cachedLayouts;
    public int cachedMeasures;
    public int measureCallbacks;
    public int[] measureCallbackReasonsCount;

    public LayoutData(int layouts, int measures, int maxMeasureCache, int cachedLayouts, int cachedMeasures, int measureCallbacks, int[] measureCallbackReasonsCount) {
        this.layouts = layouts;
        this.measures = measures;
        this.maxMeasureCache = maxMeasureCache;
        this.cachedLayouts = cachedLayouts;
        this.cachedMeasures = cachedMeasures;
        this.measureCallbacks = measureCallbacks;
        this.measureCallbackReasonsCount = measureCallbackReasonsCount;
    }

    public LayoutData() {
        this(0, 0, 0, 0, 0, 0, new int[LayoutPassReason.COUNT]);
    }

    public LayoutData withLayouts(int layouts) {
        return new LayoutData(layouts, this.measures, this.maxMeasureCache, this.cachedLayouts, this.cachedMeasures, this.measureCallbacks, this.measureCallbackReasonsCount);
    }

    public LayoutData withMeasures(int measures) {
        return new LayoutData(this.layouts, measures, this.maxMeasureCache, this.cachedLayouts, this.cachedMeasures, this.measureCallbacks, this.measureCallbackReasonsCount);
    }

    public LayoutData withMaxMeasureCache(int maxMeasureCache) {
        return new LayoutData(this.layouts, this.measures, maxMeasureCache, this.cachedLayouts, this.cachedMeasures, this.measureCallbacks, this.measureCallbackReasonsCount);
    }

    public LayoutData withCachedLayouts(int cachedLayouts) {
        return new LayoutData(this.layouts, this.measures, this.maxMeasureCache, cachedLayouts, this.cachedMeasures, this.measureCallbacks, this.measureCallbackReasonsCount);
    }

    public LayoutData withCachedMeasures(int cachedMeasures) {
        return new LayoutData(this.layouts, this.measures, this.maxMeasureCache, this.cachedLayouts, cachedMeasures, this.measureCallbacks, this.measureCallbackReasonsCount);
    }

    public LayoutData withMeasureCallbacks(int measureCallbacks) {
        return new LayoutData(this.layouts, this.measures, this.maxMeasureCache, this.cachedLayouts, this.cachedMeasures, measureCallbacks, this.measureCallbackReasonsCount);
    }

    public LayoutData incrementMeasureCallbackReason(LayoutPassReason reason) {
        int[] newReasons = (int[])this.measureCallbackReasonsCount.clone();
        int n = reason.ordinal();
        newReasons[n] = newReasons[n] + 1;
        return new LayoutData(this.layouts, this.measures, this.maxMeasureCache, this.cachedLayouts, this.cachedMeasures, this.measureCallbacks, newReasons);
    }

    public int layouts() {
        return this.layouts;
    }

    public int measures() {
        return this.measures;
    }

    public int maxMeasureCache() {
        return this.maxMeasureCache;
    }

    public int cachedLayouts() {
        return this.cachedLayouts;
    }

    public int cachedMeasures() {
        return this.cachedMeasures;
    }

    public int measureCallbacks() {
        return this.measureCallbacks;
    }

    public int[] measureCallbackReasonsCount() {
        return this.measureCallbackReasonsCount;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        LayoutData that = (LayoutData)obj;
        return this.layouts == that.layouts && this.measures == that.measures && this.maxMeasureCache == that.maxMeasureCache && this.cachedLayouts == that.cachedLayouts && this.cachedMeasures == that.cachedMeasures && this.measureCallbacks == that.measureCallbacks && Objects.equals(this.measureCallbackReasonsCount, that.measureCallbackReasonsCount);
    }

    public int hashCode() {
        return Objects.hash(this.layouts, this.measures, this.maxMeasureCache, this.cachedLayouts, this.cachedMeasures, this.measureCallbacks, this.measureCallbackReasonsCount);
    }

    public String toString() {
        return "LayoutData[layouts=" + this.layouts + ", measures=" + this.measures + ", maxMeasureCache=" + this.maxMeasureCache + ", cachedLayouts=" + this.cachedLayouts + ", cachedMeasures=" + this.cachedMeasures + ", measureCallbacks=" + this.measureCallbacks + ", measureCallbackReasonsCount=" + String.valueOf(this.measureCallbackReasonsCount) + "]";
    }
}

