/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.api.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfigBuilder;
import com.electronwill.nightconfig.core.io.WritingMode;
import io.homo.superresolution.api.config.ConfigValue;
import io.homo.superresolution.api.config.ModConfigSpecBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModConfigSpec {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SRConfigAPI");
    protected final CommentedFileConfig configData;
    protected final Map<List<String>, ConfigValue<?>> configValues = new LinkedHashMap();
    protected final Map<List<String>, String> comments = new HashMap<List<String>, String>();
    protected final ConfigSpec spec;
    private final ReentrantLock lock = new ReentrantLock();

    protected ModConfigSpec(ModConfigSpecBuilder builder, Path configPath) {
        try {
            if (!Files.exists(configPath, new LinkOption[0])) {
                Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
                Files.createFile(configPath, new FileAttribute[0]);
                LOGGER.info("Config file not found, creating new default at: {}", (Object)configPath);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to create config file:", (Throwable)e);
        }
        CommentedFileConfigBuilder configDataBuilder = CommentedFileConfig.builder((Path)configPath);
        if (builder.autoSave) {
            configDataBuilder.autosave();
        }
        if (builder.autoReload) {
            configDataBuilder.autoreload();
        }
        configDataBuilder.sync();
        configDataBuilder.writingMode(WritingMode.REPLACE);
        this.configData = (CommentedFileConfig)configDataBuilder.build();
        this.spec = builder.spec;
    }

    protected void fillSpec() {
        this.configValues.values().forEach(configValue -> {
            configValue.configSpec = this;
        });
        this.configValues.values().forEach(configValue -> configValue.fillSpec(this.spec));
    }

    protected void initializeDefaultValues() {
        this.spec.correct((Config)this.configData);
        this.applyComment();
    }

    public void load() {
        try {
            this.configData.load();
            if (this.spec.correct((Config)this.configData) > 0) {
                this.configData.save();
            }
        }
        catch (Exception e) {
            LOGGER.error("Config is corrupted or unreadable, regenerating defaults.", (Throwable)e);
            this.configData.clear();
            this.initializeDefaultValues();
            this.save();
        }
    }

    private void applyComment() {
        for (Map.Entry<List<String>, String> commentEntry : this.comments.entrySet()) {
            this.configData.setComment(commentEntry.getKey(), commentEntry.getValue());
        }
    }

    public void save() {
        this.spec.correct((Config)this.configData);
        this.applyComment();
        this.configData.save();
    }

    public CommentedConfig getConfigData() {
        return this.configData;
    }

    public void close() {
        this.configData.close();
    }
}

