/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.platform.GlStateManager;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.graphics.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.graphics.impl.framebuffer.IBindableFrameBuffer;
import io.homo.superresolution.core.graphics.opengl.utils.GlBlitRenderer;
import net.minecraft.class_276;

class FrameBufferRenderTargetAdapter
extends class_276 {
    private IBindableFrameBuffer frameBuffer;

    FrameBufferRenderTargetAdapter(IBindableFrameBuffer frameBuffer) {
        super(frameBuffer.getDepthTextureFormat() != null);
        this.frameBuffer = frameBuffer;
        this.updateState();
    }

    protected static FrameBufferRenderTargetAdapter ofRenderTarget(IBindableFrameBuffer frameBuffer) {
        return new FrameBufferRenderTargetAdapter(frameBuffer);
    }

    public FrameBufferRenderTargetAdapter bindFrameBuffer(IBindableFrameBuffer frameBuffer) {
        this.frameBuffer = frameBuffer;
        return this;
    }

    private void updateState() {
        this.field_1482 = this.frameBuffer.getWidth();
        this.field_1481 = this.frameBuffer.getHeight();
        this.field_1480 = this.frameBuffer.getWidth();
        this.field_1477 = this.frameBuffer.getHeight();
        this.field_1476 = Math.toIntExact(this.frameBuffer.handle());
        this.field_1475 = this.frameBuffer.getTextureId(FrameBufferAttachmentType.Color);
        this.field_1474 = this.frameBuffer.getTextureId(FrameBufferAttachmentType.DepthStencil) == -1 ? this.frameBuffer.getTextureId(FrameBufferAttachmentType.Depth) : this.frameBuffer.getTextureId(FrameBufferAttachmentType.DepthStencil);
    }

    public void method_35610() {
        this.updateState();
        this.frameBuffer.bind(FrameBufferBindPoint.Read);
    }

    public void method_1242() {
        this.updateState();
        this.frameBuffer.unbind(FrameBufferBindPoint.Read);
    }

    public void method_1235(boolean setViewport) {
        this.updateState();
        this.frameBuffer.bind(FrameBufferBindPoint.Write, setViewport);
    }

    public void method_1240() {
        this.updateState();
        this.frameBuffer.unbind(FrameBufferBindPoint.Write);
    }

    public void method_1236(float red, float green, float blue, float alpha) {
        this.updateState();
        this.frameBuffer.setClearColorRGBA(red, green, blue, alpha);
    }

    public void method_1237(int width, int height) {
        this.updateState();
        GlBlitRenderer.blitToScreen(this.frameBuffer.getTexture(FrameBufferAttachmentType.Color), this.field_1480, this.field_1477);
    }

    public void blitAndBlendToScreen(int width, int height) {
        this.updateState();
        this.method_1237(width, height);
    }

    public void method_1230(boolean a) {
        this.updateState();
        this.frameBuffer.clearFrameBuffer();
    }

    public void method_1234(int width, int height, boolean clearError) {
    }

    public void method_1231(int width, int height, boolean clearError) {
        this.updateState();
    }

    public int method_30277() {
        this.updateState();
        return this.frameBuffer.getTextureId(FrameBufferAttachmentType.Color);
    }

    public int method_30278() {
        this.updateState();
        return this.frameBuffer.getTextureId(FrameBufferAttachmentType.DepthStencil) == -1 ? this.frameBuffer.getTextureId(FrameBufferAttachmentType.Depth) : this.frameBuffer.getTextureId(FrameBufferAttachmentType.DepthStencil);
    }

    public void method_1238() {
        this.updateState();
    }

    public void method_29329(class_276 otherTarget) {
        this.updateState();
        GlStateManager._glBindFramebuffer((int)36008, (int)otherTarget.field_1476);
        GlStateManager._glBindFramebuffer((int)36009, (int)this.field_1476);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)otherTarget.field_1482, (int)otherTarget.field_1481, (int)0, (int)0, (int)this.field_1482, (int)this.field_1481, (int)256, (int)9728);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
    }
}

