/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.buffer;

import io.homo.superresolution.core.graphics.impl.buffer.StructuredUniformBuffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.system.MemoryUtil;

public class UniformStructBuilder {
    private final Map<String, StructuredUniformBuffer.Entry> entries = new HashMap<String, StructuredUniformBuffer.Entry>();
    private int currentOffset = 0;

    public static UniformStructBuilder start() {
        return new UniformStructBuilder();
    }

    public UniformStructBuilder floatEntry(String name) {
        this.addEntry(name, new StructuredUniformBuffer.FloatEntry(this.currentOffset));
        this.currentOffset += 4;
        return this;
    }

    public UniformStructBuilder intEntry(String name) {
        this.addEntry(name, new StructuredUniformBuffer.IntEntry(this.currentOffset));
        this.currentOffset += 4;
        return this;
    }

    public UniformStructBuilder boolEntry(String name) {
        this.addEntry(name, new StructuredUniformBuffer.BoolEntry(this.currentOffset));
        this.currentOffset += 4;
        return this;
    }

    public UniformStructBuilder vec2Entry(String name) {
        this.currentOffset = this.alignOffset(this.currentOffset, 8);
        this.addEntry(name, new StructuredUniformBuffer.Vec2Entry(this.currentOffset));
        this.currentOffset += 8;
        return this;
    }

    public UniformStructBuilder vec3Entry(String name) {
        this.currentOffset = this.alignOffset(this.currentOffset, 16);
        this.addEntry(name, new StructuredUniformBuffer.Vec3Entry(this.currentOffset));
        this.currentOffset += 12;
        return this;
    }

    public UniformStructBuilder vec4Entry(String name) {
        this.currentOffset = this.alignOffset(this.currentOffset, 16);
        this.addEntry(name, new StructuredUniformBuffer.Vec4Entry(this.currentOffset));
        this.currentOffset += 16;
        return this;
    }

    public UniformStructBuilder mat4Entry(String name) {
        this.currentOffset = this.alignOffset(this.currentOffset, 16);
        this.addEntry(name, new StructuredUniformBuffer.Mat4Entry(this.currentOffset));
        this.currentOffset += 64;
        return this;
    }

    public UniformStructBuilder uintEntry(String name) {
        this.addEntry(name, new StructuredUniformBuffer.UintEntry(this.currentOffset));
        this.currentOffset += 4;
        return this;
    }

    private void addEntry(String name, StructuredUniformBuffer.Entry entry) {
        if (this.entries.containsKey(name)) {
            throw new IllegalArgumentException("Duplicate entry name: " + name);
        }
        this.entries.put(name, entry);
    }

    private int alignOffset(int offset, int alignment) {
        return offset + alignment - 1 & -alignment;
    }

    public StructuredUniformBuffer build() {
        int totalSize = this.alignOffset(this.currentOffset, 16);
        ByteBuffer buffer = MemoryUtil.memAlloc((int)totalSize);
        for (int i = 0; i < totalSize; ++i) {
            buffer.put(i, (byte)0);
        }
        return new StructuredUniformBuffer(buffer, this.entries, totalSize);
    }
}

