/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.impl.pipeline;

import io.homo.superresolution.core.graphics.impl.buffer.IBuffer;
import io.homo.superresolution.core.graphics.impl.command.ICommandBuffer;
import io.homo.superresolution.core.graphics.impl.pipeline.IPipelineJob;

public class PipelineCopyBufferJob
implements IPipelineJob {
    protected long srcOffset = 0L;
    protected long dstOffset = 0L;
    protected long size = 0L;
    protected IBuffer source;
    protected IBuffer destination;

    public PipelineCopyBufferJob(IBuffer source, IBuffer destination, long srcOffset, long dstOffset, long size) {
        this.srcOffset = srcOffset;
        this.dstOffset = dstOffset;
        this.size = size;
        this.source = source;
        this.destination = destination;
    }

    public PipelineCopyBufferJob source(IBuffer source) {
        this.source = source;
        return this;
    }

    public PipelineCopyBufferJob destination(IBuffer destination) {
        this.destination = destination;
        return this;
    }

    public PipelineCopyBufferJob copyRegion(long srcOffset, long dstOffset, long size) {
        this.srcOffset = srcOffset;
        this.dstOffset = dstOffset;
        this.size = size;
        return this;
    }

    public long getSrcOffset() {
        return this.srcOffset;
    }

    public long getDstOffset() {
        return this.dstOffset;
    }

    public long getSize() {
        return this.size;
    }

    public IBuffer getSource() {
        return this.source;
    }

    public IBuffer getDestination() {
        return this.destination;
    }

    @Override
    public void execute(ICommandBuffer commandBuffer) {
        if (this.srcOffset == -1L && this.dstOffset == -1L && this.size == -1L) {
            if (this.source.getSize() == this.destination.getSize()) {
                commandBuffer.getEncoder().copyBuffer(commandBuffer, this.source, this.destination, 0L, 0L, this.source.getSize());
                return;
            }
            throw new RuntimeException("\u6e90Buffer\u4e0e\u76ee\u6807Buffer\u5927\u5c0f\u4e0d\u5339\u914d");
        }
        if (this.srcOffset >= 0L && this.dstOffset >= 0L && this.size >= 0L) {
            if (this.srcOffset + this.size > this.source.getSize() || this.dstOffset + this.size > this.destination.getSize()) {
                throw new RuntimeException("Buffer\u7a7a\u95f4\u4e0d\u8db3");
            }
        } else {
            throw new RuntimeException("Buffer\u590d\u5236\u8303\u56f4\u9519\u8bef \u6e90\u504f\u79fb\u91cf %s \u76ee\u6807\u504f\u79fb\u91cf %s \u5927\u5c0f %s".formatted(this.srcOffset, this.dstOffset, this.size));
        }
        commandBuffer.getEncoder().copyBuffer(commandBuffer, this.source, this.destination, this.srcOffset, this.dstOffset, this.size);
    }

    @Override
    public void destroy() {
    }
}

