/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.graphics.opengl.texture;

import io.homo.superresolution.core.graphics.impl.IDebuggableObject;
import io.homo.superresolution.core.graphics.impl.texture.ITexture;
import io.homo.superresolution.core.graphics.impl.texture.TextureDescription;
import io.homo.superresolution.core.graphics.impl.texture.TextureFilterMode;
import io.homo.superresolution.core.graphics.impl.texture.TextureFormat;
import io.homo.superresolution.core.graphics.impl.texture.TextureMipmapSettings;
import io.homo.superresolution.core.graphics.impl.texture.TextureType;
import io.homo.superresolution.core.graphics.impl.texture.TextureUsages;
import io.homo.superresolution.core.graphics.impl.texture.TextureWrapMode;
import io.homo.superresolution.core.graphics.opengl.Gl;
import io.homo.superresolution.core.graphics.opengl.GlDebug;
import io.homo.superresolution.core.graphics.opengl.GlState;
import io.homo.superresolution.core.graphics.opengl.texture.GlTextureView;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lwjgl.opengl.GL45;
import org.lwjgl.system.MemoryUtil;

public class GlTexture1D
implements ITexture,
IDebuggableObject {
    private static final int DEFAULT_ALIGNMENT = 4;
    private final Map<Integer, GlTextureView> mipViews = new ConcurrentHashMap<Integer, GlTextureView>();
    private int id;
    private final TextureDescription description;
    private int width;
    private int currentMipmapLevel;

    protected GlTexture1D(TextureDescription description) {
        this.validateDimensions(description.getWidth());
        this.id = Gl.DSA.createTexture1D();
        this.description = description;
        this.width = description.getWidth();
        if (description.getType() != TextureType.Texture1D) {
            throw new RuntimeException();
        }
        this.configureMipmap();
        this.initializeTexture();
    }

    public static GlTexture1D create(TextureDescription description) {
        return new GlTexture1D(description);
    }

    public GlTextureView getMipView(int level) {
        return this.mipViews.computeIfAbsent(level, this::createMipView);
    }

    private GlTextureView createMipView(int level) {
        try (GlState ignored = new GlState(448L);){
            if (level < 0 || level > this.currentMipmapLevel) {
                throw new IllegalArgumentException("Invalid mip level: " + level);
            }
            GlTextureView glTextureView = GlTextureView.create(this, 3552, level, 1, 0, 1);
            return glTextureView;
        }
    }

    @Override
    public TextureMipmapSettings getMipmapSettings() {
        return this.description.getMipmapSettings();
    }

    private void configureTextureParameters() {
        Gl.DSA.textureParameteri(this.id, 10241, this.description.getMipmapSettings().isEnabled() ? (this.description.getFilterMode() == TextureFilterMode.Linear ? 9985 : 9984) : this.description.getFilterMode().gl());
        Gl.DSA.textureParameteri(this.id, 10240, this.description.getMipmapSettings().isEnabled() ? (this.description.getFilterMode() == TextureFilterMode.Linear ? 9985 : 9984) : this.description.getFilterMode().gl());
        Gl.DSA.textureParameteri(this.id, 10242, this.description.getWrapMode().gl());
        Gl.DSA.textureParameteri(this.id, 10243, this.description.getWrapMode().gl());
        Gl.DSA.textureParameteri(this.id, 33084, 0);
        Gl.DSA.textureParameteri(this.id, 33085, this.currentMipmapLevel);
        Gl.DSA.textureParameterf(this.id, 34049, this.description.getMipmapSettings().getBias());
    }

    private void allocateTextureStorage() {
        int levels = this.description.getMipmapSettings().isEnabled() ? this.currentMipmapLevel + 1 : 1;
        Gl.DSA.textureStorage1D(this.id, levels, this.description.getFormat().gl(), this.width);
    }

    private void initializeTexture() {
        try (GlState ignored = new GlState(448L);){
            this.configureTextureParameters();
            this.allocateTextureStorage();
            this.updateDebugLabel(this.getDebugLabel());
        }
    }

    public void uploadData(int mipLevel, int xoffset, int width, int format, int type, ByteBuffer data, int alignment) {
        GL45.glPixelStorei((int)3317, (int)alignment);
        Gl.DSA.textureSubImage1D(this.id, mipLevel, xoffset, width, format, type, MemoryUtil.memAddress((ByteBuffer)data));
    }

    public void uploadData(int format, int type, ByteBuffer data) {
        this.uploadData(0, 0, this.width, format, type, data, 4);
    }

    private void validateDimensions(int width) {
        if (width <= 0) {
            throw new IllegalArgumentException("Invalid texture width: " + width);
        }
    }

    public void copyFromTex(int srcTex) {
        GL45.glCopyImageSubData((int)srcTex, (int)3552, (int)0, (int)0, (int)0, (int)0, (int)this.id, (int)3552, (int)0, (int)0, (int)0, (int)0, (int)this.width, (int)1, (int)1);
    }

    @Override
    public long handle() {
        return this.id;
    }

    @Override
    public TextureFormat getTextureFormat() {
        return this.description.getFormat();
    }

    @Override
    public TextureUsages getTextureUsages() {
        return this.description.getUsages();
    }

    @Override
    public TextureType getTextureType() {
        return this.description.getType();
    }

    @Override
    public TextureFilterMode getTextureFilterMode() {
        return this.description.getFilterMode();
    }

    @Override
    public TextureWrapMode getTextureWrapMode() {
        return this.description.getWrapMode();
    }

    public void configureMipmap() {
        if (this.description.getMipmapSettings().isAutoGenerate()) {
            this.currentMipmapLevel = this.calculateMaxMipLevel();
            return;
        }
        this.currentMipmapLevel = Math.min(this.description.getMipmapSettings().getLevels(), this.calculateMaxMipLevel());
    }

    private int calculateMaxMipLevel() {
        return (int)(Math.log(this.width) / Math.log(2.0));
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    @Override
    public String getDebugLabel() {
        return this.string();
    }

    @Override
    public void updateDebugLabel(String newLabel) {
        GlDebug.objectLabel(5890, (int)this.handle(), this.getDebugLabel());
    }

    public void generateMipmap() {
        Gl.DSA.generateTextureMipmap(this.id);
    }

    @Override
    public void destroy() {
        this.mipViews.values().forEach(GlTextureView::destroy);
        this.mipViews.clear();
        Gl.DSA.deleteTexture(this.id);
    }

    @Override
    public void resize(int width, int height) {
        this.width = width;
        Gl.DSA.deleteTexture(this.id);
        this.id = Gl.DSA.createTexture1D();
        this.configureMipmap();
        this.initializeTexture();
    }

    @Override
    public TextureDescription getTextureDescription() {
        return this.description;
    }
}

