/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.core.impl;

import org.joml.Vector2f;

public class Rectangle {
    public float x;
    public float y;
    public float width;
    public float height;

    public Rectangle(Vector2f position, Vector2f size) {
        this(position.x, position.y, size.x, size.y);
    }

    public Rectangle(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle() {
        this(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Rectangle(Rectangle region) {
        this(region.x, region.y, region.width, region.height);
    }

    public Rectangle setX(float x) {
        this.x = x;
        return this;
    }

    public Rectangle setY(float y) {
        this.y = y;
        return this;
    }

    public Rectangle setWidth(float width) {
        this.width = width;
        return this;
    }

    public Rectangle setHeight(float height) {
        this.height = height;
        return this;
    }

    public Vector2f getPosition() {
        return new Vector2f(this.x, this.y);
    }

    public Vector2f getSize() {
        return new Vector2f(this.width, this.height);
    }

    public void setBounds(float x, float y, float width, float height) {
        this.reshape(x, y, width, height);
    }

    public void setBounds(Rectangle rectangle) {
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void reshape(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean in(int x, int y) {
        return (float)x >= this.x && (float)x < this.x + this.width && (float)y >= this.y && (float)y < this.y + this.height;
    }

    public boolean in(double x, double y) {
        return x >= (double)this.x && x < (double)(this.x + this.width) && y >= (double)this.y && y < (double)(this.y + this.height);
    }

    public boolean in(Vector2f point) {
        return point.x >= this.x && point.x < this.x + this.width && point.y >= this.y && point.y < this.y + this.height;
    }

    public boolean intersect(Rectangle rectangle) {
        return this.x < rectangle.x + rectangle.width && this.x + this.width > rectangle.x && this.y < rectangle.y + rectangle.height && this.y + this.height > rectangle.y;
    }

    public Rectangle intersection(Rectangle rectangle) {
        float x1 = Math.max(this.x, rectangle.x);
        float y1 = Math.max(this.y, rectangle.y);
        float x2 = Math.min(this.x + this.width, rectangle.x + rectangle.width);
        float y2 = Math.min(this.y + this.height, rectangle.y + rectangle.height);
        if (x2 > x1 && y2 > y1) {
            return new Rectangle(x1, y1, x2 - x1, y2 - y1);
        }
        return new Rectangle();
    }

    public boolean contains(Rectangle rectangle) {
        return this.x <= rectangle.x && this.y <= rectangle.y && this.x + this.width >= rectangle.x + rectangle.width && this.y + this.height >= rectangle.y + rectangle.height;
    }

    public void grow(float horizontal, float vertical) {
        this.x -= horizontal;
        this.y -= vertical;
        this.width += horizontal * 2.0f;
        this.height += vertical * 2.0f;
    }

    public void translate(float dx, float dy) {
        this.x += dx;
        this.y += dy;
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setSize(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public float getLimitX() {
        return this.x + this.width;
    }

    public float getLimitY() {
        return this.y + this.height;
    }

    public float getCenterX() {
        return this.x + this.width / 2.0f;
    }

    public float getCenterY() {
        return this.y + this.height / 2.0f;
    }

    public Vector2f getCenter() {
        return new Vector2f(this.getCenterX(), this.getCenterY());
    }

    public float getArea() {
        return this.width * this.height;
    }

    public Rectangle clone() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public boolean isEmpty() {
        return this.width <= 0.0f || this.height <= 0.0f;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Rectangle rectangle = (Rectangle)obj;
        return Float.compare(rectangle.x, this.x) == 0 && Float.compare(rectangle.y, this.y) == 0 && Float.compare(rectangle.width, this.width) == 0 && Float.compare(rectangle.height, this.height) == 0;
    }

    public int hashCode() {
        int result = Float.hashCode(this.x);
        result = 31 * result + Float.hashCode(this.y);
        result = 31 * result + Float.hashCode(this.width);
        result = 31 * result + Float.hashCode(this.height);
        return result;
    }

    public String toString() {
        return "Rectangle[x=" + this.x + ", y=" + this.y + ", width=" + this.width + ", height=" + this.height + "]";
    }
}

