/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.google.material.dynamiccolor;

import io.homo.superresolution.core.gui.google.material.dynamiccolor.DynamicColor;
import io.homo.superresolution.core.gui.google.material.dynamiccolor.TonePolarity;
import org.jetbrains.annotations.NotNull;

public final class ToneDeltaPair {
    private final DynamicColor roleA;
    private final DynamicColor roleB;
    private final double delta;
    private final TonePolarity polarity;
    private final boolean stayTogether;
    private final DeltaConstraint constraint;

    public ToneDeltaPair(DynamicColor roleA, DynamicColor roleB, double delta, TonePolarity polarity, boolean stayTogether) {
        this.roleA = roleA;
        this.roleB = roleB;
        this.delta = delta;
        this.polarity = polarity;
        this.stayTogether = stayTogether;
        this.constraint = DeltaConstraint.EXACT;
    }

    public ToneDeltaPair(DynamicColor roleA, DynamicColor roleB, double delta, TonePolarity polarity, DeltaConstraint constraint) {
        this.roleA = roleA;
        this.roleB = roleB;
        this.delta = delta;
        this.polarity = polarity;
        this.stayTogether = true;
        this.constraint = constraint;
    }

    @NotNull
    public DynamicColor getRoleA() {
        return this.roleA;
    }

    @NotNull
    public DynamicColor getRoleB() {
        return this.roleB;
    }

    public double getDelta() {
        return this.delta;
    }

    @NotNull
    public TonePolarity getPolarity() {
        return this.polarity;
    }

    public boolean getStayTogether() {
        return this.stayTogether;
    }

    @NotNull
    public DeltaConstraint getConstraint() {
        return this.constraint;
    }

    public static enum DeltaConstraint {
        EXACT,
        NEARER,
        FARTHER;

    }
}

