/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.google.material.hct;

import io.homo.superresolution.core.gui.google.material.hct.Cam16;
import io.homo.superresolution.core.gui.google.material.hct.HctSolver;
import io.homo.superresolution.core.gui.google.material.hct.ViewingConditions;
import io.homo.superresolution.core.gui.google.material.utils.ColorUtils;

public final class Hct {
    private double hue;
    private double chroma;
    private double tone;
    private int argb;

    private Hct(int argb) {
        this.setInternalState(argb);
    }

    public static Hct from(double hue, double chroma, double tone) {
        int argb = HctSolver.solveToInt(hue, chroma, tone);
        return new Hct(argb);
    }

    public static Hct fromInt(int argb) {
        return new Hct(argb);
    }

    public static boolean isBlue(double hue) {
        return hue >= 250.0 && hue < 270.0;
    }

    public static boolean isYellow(double hue) {
        return hue >= 105.0 && hue < 125.0;
    }

    public static boolean isCyan(double hue) {
        return hue >= 170.0 && hue < 207.0;
    }

    public double getHue() {
        return this.hue;
    }

    public void setHue(double newHue) {
        this.setInternalState(HctSolver.solveToInt(newHue, this.chroma, this.tone));
    }

    public double getChroma() {
        return this.chroma;
    }

    public void setChroma(double newChroma) {
        this.setInternalState(HctSolver.solveToInt(this.hue, newChroma, this.tone));
    }

    public double getTone() {
        return this.tone;
    }

    public void setTone(double newTone) {
        this.setInternalState(HctSolver.solveToInt(this.hue, this.chroma, newTone));
    }

    public int toInt() {
        return this.argb;
    }

    public String toString() {
        return "HCT(" + (int)Math.round(this.hue) + ", " + (int)Math.round(this.chroma) + ", " + (int)Math.round(this.tone) + ")";
    }

    public Hct inViewingConditions(ViewingConditions vc) {
        Cam16 cam16 = Cam16.fromInt(this.toInt());
        double[] viewedInVc = cam16.xyzInViewingConditions(vc, null);
        Cam16 recastInVc = Cam16.fromXyzInViewingConditions(viewedInVc[0], viewedInVc[1], viewedInVc[2], ViewingConditions.DEFAULT);
        return Hct.from(recastInVc.getHue(), recastInVc.getChroma(), ColorUtils.lstarFromY(viewedInVc[1]));
    }

    private void setInternalState(int argb) {
        this.argb = argb;
        Cam16 cam = Cam16.fromInt(argb);
        this.hue = cam.getHue();
        this.chroma = cam.getChroma();
        this.tone = ColorUtils.lstarFromArgb(argb);
    }
}

