/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gui.widgets.label;

import io.homo.superresolution.core.gui.core.UIInputState;
import io.homo.superresolution.core.gui.core.backends.interfaces.IUIDrawContext;
import io.homo.superresolution.core.gui.core.backends.interfaces.TextAlign;
import io.homo.superresolution.core.gui.core.backends.interfaces.TextAlignType;
import io.homo.superresolution.core.gui.core.impl.Rectangle;
import io.homo.superresolution.core.gui.widgets.MaterialWidget;
import io.homo.superresolution.core.gui.widgets.label.MaterialLabelAnimationSet;
import io.homo.superresolution.core.gui.widgets.label.MaterialLabelStyle;
import io.homo.superresolution.core.utils.Color;
import java.util.function.Supplier;
import org.joml.Vector2f;

public class MaterialLabel
extends MaterialWidget<MaterialLabel, MaterialLabelStyle, MaterialLabelAnimationSet> {
    private Supplier<String> textSupplier = () -> "";

    public MaterialLabel() {
        this.style = new MaterialLabelStyle();
        this.animationSet = new MaterialLabelAnimationSet();
        this.getLayoutNode().setDebugName("MaterialLabel");
    }

    public static MaterialLabel create() {
        return new MaterialLabel();
    }

    @Override
    protected boolean isInteractive() {
        return false;
    }

    public MaterialLabel text(String text) {
        this.textSupplier = () -> text;
        return this;
    }

    public MaterialLabel text(Supplier<String> supplier) {
        this.textSupplier = supplier;
        return this;
    }

    public MaterialLabel color(Color color) {
        ((MaterialLabelStyle)this.style).color(color);
        return this;
    }

    public MaterialLabel fontSize(float fontSize) {
        ((MaterialLabelStyle)this.style).fontSize(fontSize);
        return this;
    }

    @Override
    protected void init() {
    }

    @Override
    public void render(IUIDrawContext drawContext, UIInputState inputState) {
        drawContext.beginBatch();
        Vector2f textSize = drawContext.measureText(this.textSupplier.get(), ((MaterialLabelStyle)this.style).fontSize());
        this.setElementSize(textSize.x, textSize.y);
        Rectangle bounds = this.getBounds();
        String text = this.textSupplier.get();
        if (text != null && !text.isEmpty()) {
            Color textColor = this.getTextColor();
            drawContext.drawAlignedText(drawContext.font(), ((MaterialLabelStyle)this.style).fontSize(), text, bounds.x, bounds.y, bounds.width, bounds.height, textColor, TextAlign.of(TextAlignType.ALIGN_LEFT, TextAlignType.ALIGN_TOP), false);
        }
        drawContext.endBatch(this.getZIndex());
    }

    private Color getTextColor() {
        if (((MaterialLabelStyle)this.style).color() != null) {
            return this.isDisabled() ? ((MaterialLabelStyle)this.style).color().copy().alpha(96) : ((MaterialLabelStyle)this.style).color();
        }
        return this.isDisabled() ? this.scheme().onSurface().copy().alpha(96) : this.scheme().onSurface();
    }
}

