/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.srapi;

import java.util.EnumSet;

public enum SRResourceUsage {
    READ_ONLY(0),
    RENDERTARGET(1),
    UAV(2),
    DEPTHTARGET(4),
    INDIRECT(8),
    ARRAYVIEW(16),
    STENCILTARGET(32),
    DCC_RENDERTARGET(32768);

    public final int value;

    private SRResourceUsage(int value) {
        this.value = value;
    }

    public static int toBitmask(EnumSet<SRResourceUsage> usages) {
        int mask = 0;
        for (SRResourceUsage usage : usages) {
            mask |= usage.value;
        }
        return mask;
    }

    public static EnumSet<SRResourceUsage> fromBitmask(int mask) {
        EnumSet<SRResourceUsage> set = EnumSet.noneOf(SRResourceUsage.class);
        for (SRResourceUsage usage : SRResourceUsage.values()) {
            if ((mask & usage.value) == 0) continue;
            set.add(usage);
        }
        return set;
    }
}

