/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.config;

import io.homo.superresolution.api.registry.AlgorithmDescription;
import io.homo.superresolution.api.registry.AlgorithmRegistry;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.enums.CaptureMode;
import io.homo.superresolution.common.config.special.SpecialConfigs;
import io.homo.superresolution.common.platform.OS;
import io.homo.superresolution.common.platform.OSType;
import io.homo.superresolution.common.platform.Platform;
import io.homo.superresolution.common.upscale.AlgorithmDescriptions;

public class ConfigData {
    private static final OSType CURRENT_OS_TYPE = new OS().type;
    private static final boolean compatMode = CURRENT_OS_TYPE == OSType.MACOS || CURRENT_OS_TYPE == OSType.ANDROID;
    private SpecialConfigs special = new SpecialConfigs();
    private boolean enableUpscale = true;
    private float upscaleRatio = 1.7f;
    private AlgorithmDescription<?> upscaleAlgo = AlgorithmDescriptions.SGSR1;
    private float sharpness = 0.55f;
    private CaptureMode captureMode = CaptureMode.A;
    private boolean debugDumpShader = false;
    private boolean skipInitVulkan = compatMode;
    private boolean enableRenderDoc = !compatMode;
    private boolean enableImgui = !compatMode;
    private boolean generateMotionVectors;
    private boolean pauseGameOnGui;

    public static AlgorithmDescription<?> getDefaultAlgorithm() {
        AlgorithmDescription<?> desc = null;
        for (AlgorithmDescription<?> algorithmDescription : AlgorithmRegistry.getAlgorithmMap().values()) {
            if (!algorithmDescription.requirement.check().support()) continue;
            desc = algorithmDescription;
            break;
        }
        if (desc == null) {
            SuperResolution.LOGGER.info("\u4f60\u7684\u786c\u4ef6\u4e0d\u652f\u6301\u6240\u6709\u7b97\u6cd5????");
            return AlgorithmDescriptions.NONE;
        }
        return desc;
    }

    public boolean isPauseGameOnGui() {
        return this.pauseGameOnGui;
    }

    public ConfigData setPauseGameOnGui(boolean pauseGameOnGui) {
        this.pauseGameOnGui = pauseGameOnGui;
        return this;
    }

    public boolean isGenerateMotionVectors() {
        return this.generateMotionVectors;
    }

    public ConfigData setGenerateMotionVectors(boolean generateMotionVectors) {
        this.generateMotionVectors = generateMotionVectors;
        return this;
    }

    public boolean isEnableRenderDoc() {
        return this.enableRenderDoc;
    }

    public void setEnableRenderDoc(boolean enableRenderDoc) {
        this.enableRenderDoc = enableRenderDoc;
    }

    public boolean isEnableImgui() {
        return this.enableImgui;
    }

    public void setEnableImgui(boolean enableImgui) {
        this.enableImgui = enableImgui;
    }

    public boolean isSkipInitVulkan() {
        return this.skipInitVulkan;
    }

    public void setSkipInitVulkan(boolean skipInitVulkan) {
        this.skipInitVulkan = skipInitVulkan;
    }

    public boolean isDebugDumpShader() {
        return this.debugDumpShader;
    }

    public void setDebugDumpShader(boolean debugDumpShader) {
        this.debugDumpShader = debugDumpShader;
    }

    public CaptureMode getCaptureMode() {
        return this.captureMode;
    }

    public void setCaptureMode(CaptureMode captureMode) {
        this.captureMode = captureMode;
    }

    public float getRenderScaleFactor() {
        return this.isEnableUpscale() ? 1.0f / this.getUpscaleRatio() : 1.0f;
    }

    public float getUpscaleRatio() {
        return this.upscaleRatio;
    }

    public void setUpscaleRatio(float value) {
        this.upscaleRatio = value;
    }

    public AlgorithmDescription<?> getUpscaleAlgo() {
        if (this.upscaleAlgo == null) {
            this.upscaleAlgo = ConfigData.getDefaultAlgorithm();
        }
        return this.upscaleAlgo;
    }

    public void setUpscaleAlgo(AlgorithmDescription<?> newAlgo) {
        if (newAlgo == null) {
            newAlgo = ConfigData.getDefaultAlgorithm();
        }
        if (!newAlgo.requirement.check().support() && !Platform.currentPlatform.isDevelopmentEnvironment()) {
            SuperResolution.LOGGER.warn("\u7b97\u6cd5 {} \u4e0d\u652f\u6301\uff0c\u56de\u9000\u5230\u9ed8\u8ba4\u7b97\u6cd5", (Object)newAlgo.displayName);
            newAlgo = ConfigData.getDefaultAlgorithm();
        }
        if (this.upscaleAlgo == newAlgo) {
            return;
        }
        AlgorithmDescription<?> previousAlgo = this.upscaleAlgo;
        this.upscaleAlgo = newAlgo;
        SuperResolution.algorithmDescription = this.upscaleAlgo;
        if (SuperResolution.currentAlgorithm != null) {
            SuperResolution.currentAlgorithm.destroy();
        }
        if (!SuperResolution.createAlgo()) {
            this.upscaleAlgo = previousAlgo;
            SuperResolution.algorithmDescription = this.upscaleAlgo;
            if (!SuperResolution.createAlgo()) {
                SuperResolution.LOGGER.error("\u5728\u521d\u59cb\u5316\u7b97\u6cd5 {} \u65f6\u5931\u8d25\u540e\u5728\u56de\u9000\u5230\u7b97\u6cd5 {} \u65f6\u53c8\u53d1\u751f\u5f02\u5e38", (Object)this.upscaleAlgo.displayName, (Object)previousAlgo.displayName);
                throw new RuntimeException();
            }
            SuperResolution.LOGGER.error("\u521d\u59cb\u5316\u7b97\u6cd5 {} \u5931\u8d25\uff0c\u5df2\u56de\u9000\u5230\u7b97\u6cd5 {}", (Object)this.upscaleAlgo.displayName, (Object)previousAlgo.displayName);
        }
    }

    public float getSharpness() {
        return this.sharpness;
    }

    public void setSharpness(float sharpness) {
        this.sharpness = sharpness;
    }

    public boolean isEnableUpscale() {
        return this.enableUpscale;
    }

    public void setEnableUpscale(boolean enableUpscale) {
        this.enableUpscale = enableUpscale;
    }

    public SpecialConfigs getSpecial() {
        return this.special;
    }

    public void setSpecial(SpecialConfigs special) {
        this.special = special;
    }
}

