/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import io.homo.superresolution.core.gl.utils.GlBlitRenderer;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;

public class FrameBufferRenderTargetAdapter
extends RenderTarget {
    private IFrameBuffer frameBuffer;

    FrameBufferRenderTargetAdapter(IFrameBuffer frameBuffer) {
        super(frameBuffer.getDepthTextureFormat() != null);
        this.frameBuffer = frameBuffer;
        this.updateState();
    }

    protected static FrameBufferRenderTargetAdapter ofRenderTarget(IFrameBuffer frameBuffer) {
        return new FrameBufferRenderTargetAdapter(frameBuffer);
    }

    public FrameBufferRenderTargetAdapter bindFrameBuffer(IFrameBuffer frameBuffer) {
        this.frameBuffer = frameBuffer;
        return this;
    }

    private void updateState() {
        this.width = this.frameBuffer.getWidth();
        this.height = this.frameBuffer.getHeight();
        this.viewWidth = this.frameBuffer.getWidth();
        this.viewHeight = this.frameBuffer.getHeight();
        this.frameBufferId = this.frameBuffer.getFrameBufferId();
        this.colorTextureId = this.frameBuffer.getTextureId(FrameBufferAttachmentType.COLOR);
        this.depthBufferId = this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH_STENCIL) == -1 ? this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH) : this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH_STENCIL);
    }

    public void bindRead() {
        this.updateState();
        this.frameBuffer.bind(FrameBufferBindPoint.READ);
    }

    public void unbindRead() {
        this.updateState();
        this.frameBuffer.unbind(FrameBufferBindPoint.READ);
    }

    public void bindWrite(boolean setViewport) {
        this.updateState();
        this.frameBuffer.bind(FrameBufferBindPoint.WRITE, setViewport);
    }

    public void unbindWrite() {
        this.updateState();
        this.frameBuffer.unbind(FrameBufferBindPoint.WRITE);
    }

    public void setClearColor(float red, float green, float blue, float alpha) {
        this.updateState();
        this.frameBuffer.setClearColor(red, green, blue, alpha);
    }

    public void blitToScreen(int width, int height) {
        this.updateState();
        GlBlitRenderer.blitToScreen(this.frameBuffer.getTextureId(FrameBufferAttachmentType.COLOR), this.viewWidth, this.viewHeight);
    }

    public void blitAndBlendToScreen(int width, int height) {
        this.updateState();
        this.blitToScreen(width, height);
    }

    public void clear() {
        this.updateState();
        this.frameBuffer.clearFrameBuffer();
    }

    public void resize(int width, int height) {
    }

    public void createBuffers(int width, int height) {
        this.updateState();
    }

    public int getColorTextureId() {
        this.updateState();
        return this.frameBuffer.getTextureId(FrameBufferAttachmentType.COLOR);
    }

    public int getDepthTextureId() {
        this.updateState();
        return this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH_STENCIL) == -1 ? this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH) : this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH_STENCIL);
    }

    public void destroyBuffers() {
        this.updateState();
    }

    public void copyDepthFrom(RenderTarget otherTarget) {
        this.updateState();
        GlStateManager._glBindFramebuffer((int)36008, (int)otherTarget.frameBufferId);
        GlStateManager._glBindFramebuffer((int)36009, (int)this.frameBufferId);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)otherTarget.width, (int)otherTarget.height, (int)0, (int)0, (int)this.width, (int)this.height, (int)256, (int)9728);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
    }
}

