/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferTextureAdapter;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.impl.texture.ITexture;
import io.homo.superresolution.core.impl.texture.TextureFormat;

public class LegacyStorageFrameBuffer
extends RenderTarget
implements IFrameBuffer {
    private int colorAttachment1 = -1;
    private boolean stencilEnabled = false;

    public LegacyStorageFrameBuffer(boolean useDepth) {
        super(useDepth);
    }

    public void createBuffers(int width, int height) {
        RenderSystem.assertOnRenderThreadOrInit();
        int maxSupportedTextureSize = RenderSystem.maxSupportedTextureSize();
        if (width > 0 && width <= maxSupportedTextureSize && height > 0 && height <= maxSupportedTextureSize) {
            this.viewWidth = width;
            this.viewHeight = height;
            this.width = width;
            this.height = height;
            this.filterMode = 9728;
            this.frameBufferId = Gl.glGenFramebuffers();
            this.colorTextureId = TextureUtil.generateTextureId();
            this.depthBufferId = TextureUtil.generateTextureId();
            this.colorAttachment1 = TextureUtil.generateTextureId();
            Gl.glBindFramebuffer(36160, this.frameBufferId);
            Gl.glBindTexture(3553, this.depthBufferId);
            Gl.glTexParameteri(3553, 10241, 9728);
            Gl.glTexParameteri(3553, 10240, 9728);
            Gl.glTexParameteri(3553, 34892, 0);
            Gl.glTexParameteri(3553, 10242, 33071);
            Gl.glTexParameteri(3553, 10243, 33071);
            if (this.stencilEnabled) {
                Gl.glTexStorage2D(3553, 1, 35056, this.width, this.height);
                Gl.glFramebufferTexture2D(36160, 36128, 3553, this.depthBufferId, 0);
            } else {
                Gl.glTexStorage2D(3553, 1, 33190, this.width, this.height);
            }
        } else {
            throw new IllegalArgumentException("Window " + width + "x" + height + " size out of bounds (max. size: " + maxSupportedTextureSize + ")");
        }
        Gl.glFramebufferTexture2D(36160, 36096, 3553, this.depthBufferId, 0);
        Gl.glBindTexture(3553, this.colorTextureId);
        Gl.glTexParameteri(3553, 10241, 9728);
        Gl.glTexParameteri(3553, 10240, 9728);
        Gl.glTexParameteri(3553, 10242, 33071);
        Gl.glTexParameteri(3553, 10243, 33071);
        Gl.glTexStorage2D(3553, 1, 32856, this.width, this.height);
        Gl.glFramebufferTexture2D(36160, 36064, 3553, this.colorTextureId, 0);
        Gl.glBindTexture(3553, this.colorAttachment1);
        Gl.glTexParameteri(3553, 10241, 9728);
        Gl.glTexParameteri(3553, 10240, 9728);
        Gl.glTexParameteri(3553, 10242, 33071);
        Gl.glTexParameteri(3553, 10243, 33071);
        Gl.glTexStorage2D(3553, 1, TextureFormat.RG16F.gl(), this.width, this.height);
        this.checkStatus();
        this.clear();
        this.unbindRead();
    }

    public void enableStencil() {
        if (!this.stencilEnabled) {
            this.stencilEnabled = true;
            this.resize(this.viewWidth, this.viewHeight);
        }
    }

    public boolean isStencilEnabled() {
        return this.stencilEnabled;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void destroy() {
        this.destroyBuffers();
    }

    @Override
    public void clearFrameBuffer() {
        this.clear();
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        this.resize(width, height);
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
        if (bindPoint == FrameBufferBindPoint.READ) {
            this.bindRead();
        } else {
            this.bindWrite(setViewport);
        }
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
        this.bind(bindPoint, true);
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
        if (bindPoint == FrameBufferBindPoint.READ) {
            this.unbindRead();
        } else if (bindPoint == FrameBufferBindPoint.WRITE) {
            this.unbindWrite();
        } else {
            this.unbindRead();
            this.unbindWrite();
        }
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new MatchException(null, null);
            case FrameBufferAttachmentType.COLOR -> {
                if (attachmentType.getIndex() == 0) {
                    yield this.colorTextureId;
                }
                yield this.colorAttachment1;
            }
            case FrameBufferAttachmentType.ANY_DEPTH, FrameBufferAttachmentType.DEPTH -> this.depthBufferId;
            case FrameBufferAttachmentType.DEPTH_STENCIL -> this.stencilEnabled ? this.depthBufferId : -1;
        };
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return FrameBufferTextureAdapter.of(this, attachmentType);
    }

    @Override
    public int getFrameBufferId() {
        return this.frameBufferId;
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        return TextureFormat.RGBA8;
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        return this.stencilEnabled ? TextureFormat.DEPTH24_STENCIL8 : TextureFormat.DEPTH24;
    }

    @Override
    public void setClearColor(float red, float green, float blue, float alpha) {
        super.setClearColor(red, green, blue, alpha);
    }

    @Override
    public RenderTarget asMcRenderTarget() {
        return this;
    }
}

