/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.pipeline.RenderTarget;
import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.gl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferTextureAdapter;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.impl.texture.ITexture;
import io.homo.superresolution.core.impl.texture.TextureFormat;
import io.homo.superresolution.core.utils.ColorUtil;

public class MinecraftRenderTargetWrapper
implements IFrameBuffer {
    public RenderTarget renderTarget;
    private int clearColor = ColorUtil.color(255, 0, 0, 0);

    MinecraftRenderTargetWrapper(RenderTarget renderTarget) {
        this.renderTarget = renderTarget;
    }

    public static MinecraftRenderTargetWrapper of(RenderTarget renderTarget) {
        if (renderTarget == null) {
            return null;
        }
        MinecraftRenderTargetWrapper wrapper = new MinecraftRenderTargetWrapper(renderTarget);
        wrapper.clearColor = ColorUtil.color(255, 0, 0, 0);
        return wrapper;
    }

    @Override
    public void clearFrameBuffer() {
        this.renderTarget.clear();
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        this.renderTarget.resize(width, height);
    }

    @Override
    public int getWidth() {
        return this.renderTarget.width;
    }

    @Override
    public int getHeight() {
        return this.renderTarget.height;
    }

    @Override
    public void destroy() {
        this.renderTarget.destroyBuffers();
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
        if (bindPoint == FrameBufferBindPoint.READ) {
            this.renderTarget.bindRead();
        } else {
            this.renderTarget.bindWrite(setViewport);
        }
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
        this.bind(bindPoint, true);
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
        Gl.glBindFramebuffer(GlFrameBuffer.resolveBindTarget(bindPoint), 0);
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new MatchException(null, null);
            case FrameBufferAttachmentType.COLOR -> this.renderTarget.getColorTextureId();
            case FrameBufferAttachmentType.ANY_DEPTH, FrameBufferAttachmentType.DEPTH, FrameBufferAttachmentType.DEPTH_STENCIL -> this.renderTarget.getDepthTextureId();
        };
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new MatchException(null, null);
            case FrameBufferAttachmentType.COLOR -> FrameBufferTextureAdapter.ofColor(this);
            case FrameBufferAttachmentType.ANY_DEPTH, FrameBufferAttachmentType.DEPTH, FrameBufferAttachmentType.DEPTH_STENCIL -> FrameBufferTextureAdapter.ofDepth(this);
        };
    }

    @Override
    public int getFrameBufferId() {
        return this.renderTarget.frameBufferId;
    }

    @Override
    public void setClearColor(float red, float green, float blue, float alpha) {
        this.renderTarget.setClearColor(red, green, blue, alpha);
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        return TextureFormat.RGBA8;
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        return TextureFormat.DEPTH24;
    }

    @Override
    public RenderTarget asMcRenderTarget() {
        return this.renderTarget;
    }
}

