/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.platform;

import com.sun.jna.Platform;
import net.minecraft.network.chat.Component;

public enum OSType {
    ANDROID(8 == Platform.getOSType()),
    LINUX(1 == Platform.getOSType()),
    WINDOWS(2 == Platform.getOSType()),
    MACOS(0 == Platform.getOSType()),
    ANY(true);

    private final boolean isCurrentOS;

    private OSType(boolean isCurrentOS) {
        this.isCurrentOS = isCurrentOS;
    }

    public static OSType get() {
        if (OSType.ANDROID.isCurrentOS || System.getenv("POJAV_RENDERER") != null) {
            return ANDROID;
        }
        if (OSType.LINUX.isCurrentOS) {
            return LINUX;
        }
        if (OSType.WINDOWS.isCurrentOS) {
            return WINDOWS;
        }
        if (OSType.MACOS.isCurrentOS) {
            return MACOS;
        }
        return ANY;
    }

    public static boolean isCurrentOS(OSType osType) {
        return osType.isCurrentOS;
    }

    public boolean equals(OSType type) {
        return type == ANY || OSType.get() == type;
    }

    public String getString() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "Android";
            case 1 -> "Linux";
            case 2 -> "Windows";
            case 3 -> "MacOS";
            case 4 -> Component.translatable((String)"superresolution.requirement.os.any").getString();
        };
    }
}

