/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gl.shader;

import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.gl.shader.uniform.GlShaderUniforms;
import io.homo.superresolution.core.impl.Destroyable;
import io.homo.superresolution.core.impl.IDebuggableObject;
import io.homo.superresolution.core.impl.shader.ShaderSource;
import io.homo.superresolution.core.utils.ShaderCache;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GL46;

public abstract class AbstractGlShaderProgram
implements Destroyable,
IDebuggableObject {
    private final Map<String, Integer> uniformLocationCache = new HashMap<String, Integer>();
    public String shaderName;
    public int shaderProgram;
    public boolean compiled;
    protected Map<ShaderSource.Type, ShaderSource> shaderSources = new EnumMap<ShaderSource.Type, ShaderSource>(ShaderSource.Type.class);
    protected Map<String, String> shaderDefineList;

    protected AbstractGlShaderProgram() {
    }

    protected int compileSingleShader(ShaderSource source, int glShaderType) {
        Objects.requireNonNull(source, "ShaderSource cannot be null");
        this.validateShaderType(glShaderType);
        int shader = GL43.glCreateShader((int)glShaderType);
        if (shader == 0) {
            throw new RuntimeException("Failed to create shader object (Type: " + glShaderType + ")");
        }
        try {
            ShaderCache.ShaderBinary binary = ShaderCache.getShaderBinary(this, source.getType());
            if (binary == null) {
                throw new RuntimeException("SPIR-V binary not found for " + String.valueOf((Object)source.getType()));
            }
            GL43.glShaderBinary((int[])new int[]{shader}, (int)binary.format(), (ByteBuffer)binary.binary());
            GL46.glSpecializeShader((int)shader, (CharSequence)"main", null, (int[])null);
            if (GL43.glGetShaderi((int)shader, (int)35713) == 0) {
                String infoLog = GL43.glGetShaderInfoLog((int)shader);
                String errorDetails = String.format("%s Shader SPIR-V\u52a0\u8f7d\u5931\u8d25\n\u7c7b\u578b: %s\n\u9519\u8bef\u65e5\u5fd7:\n%s", new Object[]{source.getType(), this.getShaderTypeName(glShaderType), infoLog});
                SuperResolution.LOGGER.error(errorDetails);
                this.saveErrorArtifacts(source.getType(), "", infoLog);
                throw new ShaderCompileException(errorDetails);
            }
            Gl.glSafeObjectLabel(33505, shader, "Shader_" + String.valueOf((Object)source.getType()));
            return shader;
        }
        catch (Exception e) {
            GL43.glDeleteShader((int)shader);
            throw e;
        }
    }

    private void validateShaderType(int type) {
        int[] VALID_TYPES = new int[]{35633, 35632, 37305};
        if (!Arrays.stream(VALID_TYPES).anyMatch(t -> t == type)) {
            throw new IllegalArgumentException("\u65e0\u6548\u7684\u7740\u8272\u5668\u7c7b\u578b: 0x" + Integer.toHexString(type));
        }
    }

    private String getShaderTypeName(int type) {
        return switch (type) {
            case 35633 -> "Vertex";
            case 35632 -> "Fragment";
            case 37305 -> "Compute";
            default -> "Unknown";
        };
    }

    private void saveErrorArtifacts(ShaderSource.Type type, String sourceCode, String log) {
        String baseName = String.format("ERROR_%s", type.name());
        Path sourcePath = Path.of(baseName + ".glsl", new String[0]);
        try {
            Files.write(sourcePath, sourceCode.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            SuperResolution.LOGGER.info("\u4fdd\u5b58\u9519\u8bef\u7740\u8272\u5668\u6e90\u7801\u81f3: {}", (Object)sourcePath);
        }
        catch (IOException e) {
            SuperResolution.LOGGER.error("\u65e0\u6cd5\u4fdd\u5b58\u7740\u8272\u5668\u6e90\u7801\u6587\u4ef6: {}", (Object)e.getMessage());
        }
    }

    private void saveErrorShader(ShaderSource.Type type, String source) {
        try (PrintWriter out = new PrintWriter("ERROR_" + type.name() + ".glsl");){
            out.println(source);
        }
        catch (IOException e) {
            SuperResolution.LOGGER.error("\u4fdd\u5b58\u7f16\u8bd1\u9519\u8bef\u7684\u7740\u8272\u5668\u65f6\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    public Map<String, String> getShaderDefineList() {
        return this.shaderDefineList;
    }

    public Map<ShaderSource.Type, ShaderSource> getShaderSources() {
        return this.shaderSources;
    }

    @Override
    public String getDebugLabel() {
        return this.shaderName + "-" + this.shaderProgram;
    }

    @Override
    public void updateDebugLabel(String newLabel) {
        Gl.glSafeObjectLabel(33506, this.shaderProgram, newLabel);
    }

    protected void checkProgram() {
        if (GL20.glGetProgrami((int)this.shaderProgram, (int)35714) == 0) {
            String log = GL20.glGetProgramInfoLog((int)this.shaderProgram);
            GL20.glDeleteProgram((int)this.shaderProgram);
            throw new RuntimeException("\u7740\u8272\u5668\u7a0b\u5e8f\u94fe\u63a5\u72b6\u6001\u4e0d\u4e3aGL_TRUE:\n" + log);
        }
    }

    @Override
    public void destroy() {
        GL43.glDeleteProgram((int)this.shaderProgram);
        this.shaderSources.clear();
        this.shaderDefineList.clear();
    }

    public abstract AbstractGlShaderProgram compileShader();

    public void use() {
        GL43.glUseProgram((int)this.shaderProgram);
    }

    public void clear() {
        GL43.glUseProgram((int)0);
    }

    public int getUniformLocation(String name) {
        if (this.uniformLocationCache.containsKey(name)) {
            return this.uniformLocationCache.get(name);
        }
        int i = GL43.glGetUniformLocation((int)this.shaderProgram, (CharSequence)name);
        this.uniformLocationCache.put(name, i);
        return i;
    }

    public GlShaderUniforms uniforms() {
        return new GlShaderUniforms(this);
    }

    public static class ShaderCompileException
    extends RuntimeException {
        public ShaderCompileException(String message) {
            super(message);
        }
    }
}

