/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.Config;
import io.homo.superresolution.common.config.ConfigData;
import io.homo.superresolution.common.platform.Platform;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public class ConfigFile {
    public static final Path configPath = Path.of(Platform.currentPlatform.getGameFolder().toString(), "config", "superresolution.json");

    public static void write() {
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(configPath.toString()), StandardCharsets.UTF_8);){
            osw.write(ConfigFile.build());
        }
        catch (IOException e) {
            SuperResolution.LOGGER.error("\u914d\u7f6e\u5199\u5165\u5931\u8d25 {}", (Object)e.toString());
        }
    }

    public static void read() {
        String text;
        if (!ConfigFile.exists()) {
            ConfigFile.write();
        }
        if ((text = ConfigFile.readText()) == null || text.isEmpty()) {
            ConfigFile.write();
            text = ConfigFile.readText();
        }
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping();
        Config.registerTypeAdapter(gsonBuilder);
        Gson gson = gsonBuilder.create();
        try {
            ConfigData config = (ConfigData)gson.fromJson(text, ConfigData.class);
            Config.setInstance(config);
        }
        catch (Exception e) {
            SuperResolution.LOGGER.info("\u8bfb\u53d6\u914d\u7f6e\u53d1\u751f\u9519\u8bef: {}", (Object)e.toString());
            Config.setInstance(new ConfigData());
        }
    }

    public static boolean exists() {
        return configPath.toFile().isFile() && configPath.toFile().exists() && configPath.toFile().canRead() && configPath.toFile().canWrite();
    }

    private static String build() {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping();
        Config.registerTypeAdapter(gsonBuilder);
        Gson gson = gsonBuilder.create();
        if (Config.getInstance() == null) {
            return gson.toJson((Object)new ConfigData());
        }
        return gson.toJson((Object)Config.getInstance());
    }

    private static String readText() {
        String string;
        BufferedReader br = new BufferedReader(new FileReader(configPath.toString(), StandardCharsets.UTF_8));
        try {
            String line;
            StringBuilder jsonBuilder = new StringBuilder();
            while ((line = br.readLine()) != null) {
                jsonBuilder.append(line).append("\n");
            }
            string = jsonBuilder.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                SuperResolution.LOGGER.error("\u8bfb\u53d6\u914d\u7f6e\u6587\u4ef6\u5931\u8d25 {}", (Object)e.toString());
                return null;
            }
        }
        br.close();
        return string;
    }

    public static void main(String[] args) {
        ConfigFile.read();
        System.out.println("0");
    }
}

