/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.config;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class EnumSerializer<T>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    private final Map<String, T> nameToValueMap;
    private final Map<T, String> valueToNameMap;
    private final T defaultValue;
    private final String defaultName;

    private EnumSerializer(Map<String, T> nameToValueMap, T defaultValue) {
        this.nameToValueMap = Map.copyOf(nameToValueMap);
        this.valueToNameMap = this.createReverseMap(nameToValueMap);
        this.defaultValue = Objects.requireNonNull(defaultValue, "Default value cannot be null");
        this.defaultName = this.validateDefaultValue(nameToValueMap, defaultValue);
    }

    private Map<T, String> createReverseMap(Map<String, T> forwardMap) {
        HashMap reverseMap = new HashMap();
        forwardMap.forEach((name, value) -> {
            if (reverseMap.containsKey(value)) {
                throw new IllegalArgumentException(String.format("Duplicate value detected: %s -> %s and %s -> %s", value, reverseMap.get(value), value, name));
            }
            reverseMap.put(value, name);
        });
        return Collections.unmodifiableMap(reverseMap);
    }

    private String validateDefaultValue(Map<String, T> map, T defaultValue) {
        String name = this.valueToNameMap.get(defaultValue);
        if (name == null) {
            throw new IllegalArgumentException("Default value not found in enum mapping");
        }
        return name;
    }

    public JsonElement serialize(T value, Type type, JsonSerializationContext context) {
        String name = this.valueToNameMap.getOrDefault(value, this.defaultName);
        return new JsonPrimitive(name);
    }

    public T deserialize(JsonElement json, Type type, JsonDeserializationContext context) {
        return this.nameToValueMap.getOrDefault(json.getAsString(), this.defaultValue);
    }

    public static class Builder<T> {
        private final Map<String, T> mapping = new HashMap<String, T>();
        private T defaultValue;

        public Builder<T> addMapping(String name, T value) {
            if (this.mapping.containsKey(name)) {
                throw new IllegalArgumentException("Duplicate mapping name: " + name);
            }
            this.mapping.put(name, Objects.requireNonNull(value, "Mapped value cannot be null"));
            return this;
        }

        public Builder<T> setDefault(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public EnumSerializer<T> build() {
            if (this.mapping.isEmpty()) {
                throw new IllegalStateException("At least one enum mapping is required");
            }
            if (this.defaultValue == null) {
                throw new IllegalStateException("Default value must be specified");
            }
            if (!this.mapping.containsValue(this.defaultValue)) {
                throw new IllegalStateException("Default value must exist in mappings");
            }
            return new EnumSerializer<T>(this.mapping, this.defaultValue);
        }
    }
}

