/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferTextureAdapter;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.impl.texture.ITexture;
import io.homo.superresolution.core.impl.texture.TextureFormat;
import net.minecraft.class_276;

public class LegacyStorageFrameBuffer
extends class_276
implements IFrameBuffer {
    private int colorAttachment1 = -1;
    private boolean stencilEnabled = false;

    public LegacyStorageFrameBuffer(boolean useDepth) {
        super(useDepth);
    }

    public void method_1231(int width, int height) {
        RenderSystem.assertOnRenderThreadOrInit();
        int maxSupportedTextureSize = RenderSystem.maxSupportedTextureSize();
        if (width > 0 && width <= maxSupportedTextureSize && height > 0 && height <= maxSupportedTextureSize) {
            this.field_1480 = width;
            this.field_1477 = height;
            this.field_1482 = width;
            this.field_1481 = height;
            this.field_1483 = 9728;
            this.field_1476 = Gl.glGenFramebuffers();
            this.field_1475 = TextureUtil.generateTextureId();
            this.field_1474 = TextureUtil.generateTextureId();
            this.colorAttachment1 = TextureUtil.generateTextureId();
            Gl.glBindFramebuffer(36160, this.field_1476);
            Gl.glBindTexture(3553, this.field_1474);
            Gl.glTexParameteri(3553, 10241, 9728);
            Gl.glTexParameteri(3553, 10240, 9728);
            Gl.glTexParameteri(3553, 34892, 0);
            Gl.glTexParameteri(3553, 10242, 33071);
            Gl.glTexParameteri(3553, 10243, 33071);
            if (this.stencilEnabled) {
                Gl.glTexStorage2D(3553, 1, 35056, this.field_1482, this.field_1481);
                Gl.glFramebufferTexture2D(36160, 36128, 3553, this.field_1474, 0);
            } else {
                Gl.glTexStorage2D(3553, 1, 33190, this.field_1482, this.field_1481);
            }
        } else {
            throw new IllegalArgumentException("Window " + width + "x" + height + " size out of bounds (max. size: " + maxSupportedTextureSize + ")");
        }
        Gl.glFramebufferTexture2D(36160, 36096, 3553, this.field_1474, 0);
        Gl.glBindTexture(3553, this.field_1475);
        Gl.glTexParameteri(3553, 10241, 9728);
        Gl.glTexParameteri(3553, 10240, 9728);
        Gl.glTexParameteri(3553, 10242, 33071);
        Gl.glTexParameteri(3553, 10243, 33071);
        Gl.glTexStorage2D(3553, 1, 32856, this.field_1482, this.field_1481);
        Gl.glFramebufferTexture2D(36160, 36064, 3553, this.field_1475, 0);
        Gl.glBindTexture(3553, this.colorAttachment1);
        Gl.glTexParameteri(3553, 10241, 9728);
        Gl.glTexParameteri(3553, 10240, 9728);
        Gl.glTexParameteri(3553, 10242, 33071);
        Gl.glTexParameteri(3553, 10243, 33071);
        Gl.glTexStorage2D(3553, 1, TextureFormat.RG16F.gl(), this.field_1482, this.field_1481);
        this.method_1239();
        this.method_1230();
        this.method_1242();
    }

    public void enableStencil() {
        if (!this.stencilEnabled) {
            this.stencilEnabled = true;
            this.method_1234(this.field_1480, this.field_1477);
        }
    }

    public boolean isStencilEnabled() {
        return this.stencilEnabled;
    }

    @Override
    public int getWidth() {
        return this.field_1482;
    }

    @Override
    public int getHeight() {
        return this.field_1481;
    }

    @Override
    public void destroy() {
        this.method_1238();
    }

    @Override
    public void clearFrameBuffer() {
        this.method_1230();
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        this.method_1234(width, height);
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
        if (bindPoint == FrameBufferBindPoint.READ) {
            this.method_35610();
        } else {
            this.method_1235(setViewport);
        }
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
        this.bind(bindPoint, true);
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
        if (bindPoint == FrameBufferBindPoint.READ) {
            this.method_1242();
        } else if (bindPoint == FrameBufferBindPoint.WRITE) {
            this.method_1240();
        } else {
            this.method_1242();
            this.method_1240();
        }
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new MatchException(null, null);
            case FrameBufferAttachmentType.COLOR -> {
                if (attachmentType.getIndex() == 0) {
                    yield this.field_1475;
                }
                yield this.colorAttachment1;
            }
            case FrameBufferAttachmentType.ANY_DEPTH, FrameBufferAttachmentType.DEPTH -> this.field_1474;
            case FrameBufferAttachmentType.DEPTH_STENCIL -> this.stencilEnabled ? this.field_1474 : -1;
        };
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return FrameBufferTextureAdapter.of(this, attachmentType);
    }

    @Override
    public int getFrameBufferId() {
        return this.field_1476;
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        return TextureFormat.RGBA8;
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        return this.stencilEnabled ? TextureFormat.DEPTH24_STENCIL8 : TextureFormat.DEPTH24;
    }

    @Override
    public void method_1236(float red, float green, float blue, float alpha) {
        super.method_1236(red, green, blue, alpha);
    }

    @Override
    public class_276 asMcRenderTarget() {
        return this;
    }
}

