/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.gl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferTextureAdapter;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.impl.texture.ITexture;
import io.homo.superresolution.core.impl.texture.TextureFormat;
import io.homo.superresolution.core.utils.ColorUtil;
import net.minecraft.class_276;

public class MinecraftRenderTargetWrapper
implements IFrameBuffer {
    public class_276 renderTarget;
    private int clearColor = ColorUtil.color(255, 0, 0, 0);

    MinecraftRenderTargetWrapper(class_276 renderTarget) {
        this.renderTarget = renderTarget;
    }

    public static MinecraftRenderTargetWrapper of(class_276 renderTarget) {
        if (renderTarget == null) {
            return null;
        }
        MinecraftRenderTargetWrapper wrapper = new MinecraftRenderTargetWrapper(renderTarget);
        wrapper.clearColor = ColorUtil.color(255, 0, 0, 0);
        return wrapper;
    }

    @Override
    public void clearFrameBuffer() {
        this.renderTarget.method_1230();
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        this.renderTarget.method_1234(width, height);
    }

    @Override
    public int getWidth() {
        return this.renderTarget.field_1482;
    }

    @Override
    public int getHeight() {
        return this.renderTarget.field_1481;
    }

    @Override
    public void destroy() {
        this.renderTarget.method_1238();
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
        if (bindPoint == FrameBufferBindPoint.READ) {
            this.renderTarget.method_35610();
        } else {
            this.renderTarget.method_1235(setViewport);
        }
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
        this.bind(bindPoint, true);
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
        Gl.glBindFramebuffer(GlFrameBuffer.resolveBindTarget(bindPoint), 0);
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new MatchException(null, null);
            case FrameBufferAttachmentType.COLOR -> this.renderTarget.method_30277();
            case FrameBufferAttachmentType.ANY_DEPTH, FrameBufferAttachmentType.DEPTH, FrameBufferAttachmentType.DEPTH_STENCIL -> this.renderTarget.method_30278();
        };
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new MatchException(null, null);
            case FrameBufferAttachmentType.COLOR -> FrameBufferTextureAdapter.ofColor(this);
            case FrameBufferAttachmentType.ANY_DEPTH, FrameBufferAttachmentType.DEPTH, FrameBufferAttachmentType.DEPTH_STENCIL -> FrameBufferTextureAdapter.ofDepth(this);
        };
    }

    @Override
    public int getFrameBufferId() {
        return this.renderTarget.field_1476;
    }

    @Override
    public void method_1236(float red, float green, float blue, float alpha) {
        this.renderTarget.method_1236(red, green, blue, alpha);
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        return TextureFormat.RGBA8;
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        return TextureFormat.DEPTH24;
    }

    @Override
    public class_276 asMcRenderTarget() {
        return this.renderTarget;
    }
}

