/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.upscale.sgsr.v2;

import io.homo.superresolution.api.AbstractAlgorithm;
import io.homo.superresolution.common.config.Config;
import io.homo.superresolution.common.config.enums.SgsrVariant;
import io.homo.superresolution.common.minecraft.MinecraftRenderHandle;
import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.common.upscale.sgsr.v2.AbstractSgsrVariant;
import io.homo.superresolution.common.upscale.sgsr.v2.SgsrParams;
import io.homo.superresolution.common.upscale.sgsr.v2.variants.Sgsr2PassCompute;
import io.homo.superresolution.common.upscale.sgsr.v2.variants.Sgsr2PassFragment;
import io.homo.superresolution.common.upscale.sgsr.v2.variants.Sgsr3PassCompute;
import io.homo.superresolution.core.gl.buffer.GlUniformBuffer;
import io.homo.superresolution.core.gl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.gl.framebuffer.GlFrameBufferAttachment;
import io.homo.superresolution.core.gl.texture.GlTexture2D;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.impl.texture.TextureFormat;
import java.util.function.Consumer;

public class Sgsr2
extends AbstractAlgorithm {
    private AbstractSgsrVariant variantInstance;
    private SgsrVariant currentVariant;
    private GlUniformBuffer<SgsrParams> params;

    private void initVariant() {
        if (this.checkVariant()) {
            if (this.variantInstance != null) {
                this.variantInstance.destroy();
            }
            this.variantInstance = switch (Config.getSpecial().sgsr2.variant) {
                default -> throw new MatchException(null, null);
                case SgsrVariant.CS_2 -> new Sgsr2PassCompute();
                case SgsrVariant.CS_3 -> new Sgsr3PassCompute();
                case SgsrVariant.FS_2 -> new Sgsr2PassFragment();
            };
            this.variantInstance.init(this);
        }
    }

    private boolean checkVariant() {
        if (this.variantInstance == null) {
            return true;
        }
        if (Config.getSpecial().sgsr2.variant != this.currentVariant) {
            this.currentVariant = Config.getSpecial().sgsr2.variant;
            return true;
        }
        return false;
    }

    @Override
    public void init() {
        this.input = MinecraftRenderHandle.getRenderTarget();
        GlFrameBuffer output_ = new GlFrameBuffer();
        output_.addAttachment(new GlFrameBufferAttachment(GlFrameBufferAttachment.FrameBufferAttachmentType.COLOR, GlTexture2D.create(MinecraftRenderHandle.getRenderWidth(), MinecraftRenderHandle.getRenderHeight(), TextureFormat.RGBA8)));
        this.output = output_;
        this.resize(MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight());
        this.params = new GlUniformBuffer<SgsrParams>(new SgsrParams());
    }

    @Override
    public boolean dispatch(DispatchResource dispatchResource) {
        this.initVariant();
        this.variantInstance.setOutput(this.output);
        this.params.struct().updateData(dispatchResource);
        this.params.update();
        this.variantInstance.dispatch(dispatchResource, this);
        return false;
    }

    @Override
    public void resize(int width, int height) {
        this.safeVariantInstance(sgsrVariant -> sgsrVariant.resize(width, height));
        this.output.resizeFrameBuffer(width, height);
    }

    private void safeVariantInstance(Consumer<AbstractSgsrVariant> callback) {
        if (this.variantInstance != null) {
            callback.accept(this.variantInstance);
        }
    }

    public GlUniformBuffer<SgsrParams> getParams() {
        return this.params;
    }

    @Override
    public IFrameBuffer getOutputFrameBuffer() {
        return super.getOutputFrameBuffer();
    }
}

