/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gl.pipeline;

import io.homo.superresolution.core.gl.pipeline.jobs.GlPipelineClearJob;
import io.homo.superresolution.core.gl.pipeline.jobs.GlPipelineComputeJob;
import io.homo.superresolution.core.gl.pipeline.jobs.GlPipelineCopyJob;
import io.homo.superresolution.core.gl.pipeline.jobs.GlPipelineGraphicsJob;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceDescription;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceDescriptions;
import io.homo.superresolution.core.gl.shader.AbstractGlShaderProgram;
import io.homo.superresolution.core.impl.Vec3;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.impl.texture.ITexture;
import java.util.function.Supplier;

public final class GlPipelineJobBuilders {
    private GlPipelineJobBuilders() {
    }

    public static CopyJobBuilder copy() {
        return new CopyJobBuilder();
    }

    public static ClearJobBuilder clear() {
        return new ClearJobBuilder();
    }

    public static ComputeJobBuilder compute(AbstractGlShaderProgram program) {
        return new ComputeJobBuilder(program);
    }

    public static GraphicsJobBuilder graphics(AbstractGlShaderProgram program) {
        return new GraphicsJobBuilder(program);
    }

    public static final class CopyJobBuilder {
        private ITexture source;
        private ITexture dest;

        private CopyJobBuilder() {
        }

        public CopyJobBuilder from(ITexture source) {
            this.source = source;
            return this;
        }

        public CopyJobBuilder to(ITexture dest) {
            this.dest = dest;
            return this;
        }

        public GlPipelineCopyJob build() {
            this.validate();
            return new GlPipelineCopyJob(this.source, this.dest);
        }

        private void validate() {
            if (this.source == null) {
                throw new IllegalStateException("Copy source must be specified");
            }
            if (this.dest == null) {
                throw new IllegalStateException("Copy destination must be specified");
            }
            if (this.source.getTextureFormat() != this.dest.getTextureFormat()) {
                throw new IllegalArgumentException("Source and destination texture formats must match. Source: " + String.valueOf((Object)this.source.getTextureFormat()) + ", Dest: " + String.valueOf((Object)this.dest.getTextureFormat()));
            }
        }
    }

    public static final class ClearJobBuilder {
        private ITexture target;
        private float[] color = new float[]{0.0f, 0.0f, 0.0f, 0.0f};

        private ClearJobBuilder() {
        }

        public ClearJobBuilder target(ITexture texture) {
            this.target = texture;
            return this;
        }

        public ClearJobBuilder color(float r, float g, float b, float a) {
            this.color = new float[]{r, g, b, a};
            return this;
        }

        public GlPipelineClearJob build() {
            this.validate();
            return new GlPipelineClearJob(this.target, this.color);
        }

        private void validate() {
            if (this.target == null) {
                throw new IllegalStateException("Clear target must be specified");
            }
            if (this.color.length != 4) {
                throw new IllegalArgumentException("Clear color must have 4 components");
            }
        }
    }

    public static final class ComputeJobBuilder {
        private final AbstractGlShaderProgram program;
        private final GlPipelineResourceDescriptions resources = new GlPipelineResourceDescriptions();
        private Supplier<Vec3> workGroupSizeSupplier = () -> new Vec3(1.0f, 1.0f, 1.0f);

        private ComputeJobBuilder(AbstractGlShaderProgram program) {
            if (program == null) {
                throw new IllegalArgumentException("Compute shader program cannot be null");
            }
            this.program = program;
        }

        public ComputeJobBuilder workGroup(int x, int y, int z) {
            this.workGroupSizeSupplier = () -> new Vec3(x, y, z);
            return this;
        }

        public ComputeJobBuilder workGroupSupplier(Supplier<Vec3> workGroupSizeSupplier) {
            this.workGroupSizeSupplier = workGroupSizeSupplier;
            return this;
        }

        public ComputeJobBuilder resource(GlPipelineResourceDescription resource) {
            this.resources.addResource(resource);
            return this;
        }

        public GlPipelineComputeJob build() {
            GlPipelineComputeJob job = new GlPipelineComputeJob(this.program, this.workGroupSizeSupplier);
            job.resourcesMap = this.resources.clone();
            return job;
        }
    }

    public static final class GraphicsJobBuilder {
        private final AbstractGlShaderProgram program;
        private final GlPipelineResourceDescriptions resources = new GlPipelineResourceDescriptions();
        private IFrameBuffer targetFbo;

        private GraphicsJobBuilder(AbstractGlShaderProgram program) {
            if (program == null) {
                throw new IllegalArgumentException("Graphics shader program cannot be null");
            }
            this.program = program;
        }

        public GraphicsJobBuilder targetFramebuffer(IFrameBuffer fbo) {
            this.targetFbo = fbo;
            return this;
        }

        public GraphicsJobBuilder resource(GlPipelineResourceDescription resource) {
            this.resources.addResource(resource);
            return this;
        }

        public GlPipelineGraphicsJob build() {
            GlPipelineGraphicsJob job = new GlPipelineGraphicsJob();
            job.program = this.program;
            job.targetFrameBuffer = this.targetFbo;
            job.resourcesMap = this.resources.clone();
            return job;
        }
    }
}

