/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gl.shader;

import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.gl.shader.AbstractGlShaderProgram;
import io.homo.superresolution.core.gl.shader.AbstractShaderProgramBuilder;
import io.homo.superresolution.core.impl.shader.ShaderSource;
import io.homo.superresolution.core.utils.ShaderCache;
import java.util.ArrayList;
import java.util.Set;

public class GlGeneralShaderProgram
extends AbstractGlShaderProgram {
    protected GlGeneralShaderProgram() {
    }

    public static GeneralShaderProgramBuilder create() {
        return new GeneralShaderProgramBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlGeneralShaderProgram compileShader() {
        if (this.compiled) {
            return this;
        }
        this.validateShaderTypes();
        if (!ShaderCache.checkProgramBinary(this)) {
            ShaderCache.saveProgramBinary(this);
        }
        ArrayList<Integer> shaders = new ArrayList<Integer>();
        try {
            ShaderSource vertSource = (ShaderSource)this.shaderSources.get((Object)ShaderSource.Type.VERTEX);
            int vertShader = this.compileSingleShader(vertSource, 35633);
            shaders.add(vertShader);
            ShaderSource fragSource = (ShaderSource)this.shaderSources.get((Object)ShaderSource.Type.FRAGMENT);
            int fragShader = this.compileSingleShader(fragSource, 35632);
            shaders.add(fragShader);
            this.shaderProgram = Gl.glCreateProgram();
            shaders.forEach(s -> Gl.glAttachShader(this.shaderProgram, s));
            Gl.glLinkProgram(this.shaderProgram);
            this.checkProgram();
            this.compiled = true;
            this.updateDebugLabel(this.getDebugLabel());
            GlGeneralShaderProgram glGeneralShaderProgram = this;
            return glGeneralShaderProgram;
        }
        finally {
            shaders.forEach(Gl::glDeleteShader);
        }
    }

    private void validateShaderTypes() {
        Set types = this.shaderSources.keySet();
        if (!types.contains((Object)ShaderSource.Type.VERTEX) || !types.contains((Object)ShaderSource.Type.FRAGMENT)) {
            throw new IllegalStateException("\u901a\u7528\u7740\u8272\u5668\u5fc5\u987b\u540c\u65f6\u62e5\u6709VERTEX\u4e0eFRAGMENT\u7c7b\u578b\u7684ShaderSource");
        }
        if (types.stream().anyMatch(t -> t != ShaderSource.Type.VERTEX && t != ShaderSource.Type.FRAGMENT)) {
            throw new IllegalStateException("\u901a\u7528\u7740\u8272\u5668\u4ec5\u652f\u6301VERTEX\u4e0eFRAGMENT\u7c7b\u578b\u7684ShaderSource");
        }
    }

    public static class GeneralShaderProgramBuilder
    extends AbstractShaderProgramBuilder<GlGeneralShaderProgram> {
        public GeneralShaderProgramBuilder addShaderSource(ShaderSource source) {
            if (source.getType() != ShaderSource.Type.VERTEX && source.getType() != ShaderSource.Type.FRAGMENT) {
                throw new IllegalArgumentException("\u901a\u7528\u7740\u8272\u5668\u4ec5\u652f\u6301VERTEX\u4e0eFRAGMENT\u7c7b\u578b\u7684ShaderSource");
            }
            return (GeneralShaderProgramBuilder)super.addShaderSource(source);
        }

        @Override
        public GlGeneralShaderProgram build() {
            return (GlGeneralShaderProgram)this.updateShader(new GlGeneralShaderProgram());
        }
    }
}

