/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gl.shader.uniform;

import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.gl.buffer.GlUniformBuffer;
import io.homo.superresolution.core.gl.shader.uniform.GlShaderUniforms;
import io.homo.superresolution.core.impl.texture.ITexture;
import org.joml.Matrix4f;

public abstract class GlShaderUniform<T> {
    protected final int uniformLocation;
    protected final GlShaderUniforms shaderUniforms;
    protected final int program;

    protected GlShaderUniform(int program, int uniformLocation, GlShaderUniforms shaderUniforms) {
        this.uniformLocation = uniformLocation;
        this.shaderUniforms = shaderUniforms;
        this.program = program;
    }

    public abstract GlShaderUniforms value(T var1);

    protected void set(int value) {
        if (this.uniformLocation < 0) {
            return;
        }
        Gl.DSA.programUniform1i(this.program, this.uniformLocation, value);
    }

    protected void set(float value) {
        if (this.uniformLocation < 0) {
            return;
        }
        Gl.DSA.programUniform1f(this.program, this.uniformLocation, value);
    }

    protected void set(float x, float y) {
        if (this.uniformLocation < 0) {
            return;
        }
        Gl.DSA.programUniform2f(this.program, this.uniformLocation, x, y);
    }

    protected void set(float x, float y, float z) {
        if (this.uniformLocation < 0) {
            return;
        }
        Gl.DSA.programUniform3f(this.program, this.uniformLocation, x, y, z);
    }

    protected void set(float x, float y, float z, float w) {
        if (this.uniformLocation < 0) {
            return;
        }
        Gl.DSA.programUniform4f(this.program, this.uniformLocation, x, y, z, w);
    }

    protected void set(Matrix4f matrix) {
        if (this.uniformLocation < 0) {
            return;
        }
        Gl.DSA.programUniformMatrix4fv(this.program, this.uniformLocation, false, matrix.get(new float[16]));
    }

    public static class Struct
    extends GlShaderUniform<GlUniformBuffer<?>> {
        private final int bindingPoint;

        public Struct(int program, int location, int bindingPoint, GlShaderUniforms shaderUniforms) {
            super(program, location, shaderUniforms);
            this.bindingPoint = bindingPoint;
        }

        @Override
        public GlShaderUniforms value(GlUniformBuffer<?> value) {
            if (this.uniformLocation < 0) {
                return this.shaderUniforms;
            }
            value.bind(this.bindingPoint);
            return this.shaderUniforms;
        }
    }

    public static class Texture
    extends GlShaderUniform<ITexture> {
        public Texture(int program, int location, GlShaderUniforms shaderUniforms) {
            super(program, location, shaderUniforms);
        }

        @Override
        public GlShaderUniforms value(ITexture value) {
            return this.value(value, 0);
        }

        @Override
        public GlShaderUniforms value(int textureId) {
            return this.value(textureId, 0);
        }

        public GlShaderUniforms value(int textureId, int texture) {
            Gl.glActiveTexture(33984 + texture);
            Gl.glBindTexture(3553, textureId);
            Gl.glUniform1i(this.uniformLocation, texture);
            return this.shaderUniforms;
        }

        public GlShaderUniforms value(ITexture textureId, int texture) {
            return this.value(textureId.getTextureId(), texture);
        }
    }

    public static class Matrix4
    extends GlShaderUniform<Matrix4f> {
        public Matrix4(int program, int location, GlShaderUniforms shaderUniforms) {
            super(program, location, shaderUniforms);
        }

        @Override
        public GlShaderUniforms value(Matrix4f value) {
            this.set(value);
            return this.shaderUniforms;
        }
    }

    public static class Bool
    extends GlShaderUniform<Boolean> {
        public Bool(int program, int location, GlShaderUniforms shaderUniforms) {
            super(program, location, shaderUniforms);
        }

        @Override
        public GlShaderUniforms value(Boolean value) {
            this.set(value != false ? 1 : 0);
            return this.shaderUniforms;
        }
    }

    public static class Int
    extends GlShaderUniform<Integer> {
        public Int(int program, int location, GlShaderUniforms shaderUniforms) {
            super(program, location, shaderUniforms);
        }

        @Override
        public GlShaderUniforms value(Integer value) {
            this.set(value);
            return this.shaderUniforms;
        }
    }

    public static class Float
    extends GlShaderUniform<java.lang.Float> {
        public Float(int program, int location, GlShaderUniforms shaderUniforms) {
            super(program, location, shaderUniforms);
        }

        @Override
        public GlShaderUniforms value(java.lang.Float value) {
            this.set(value.floatValue());
            return this.shaderUniforms;
        }
    }

    public static class Vec4
    extends GlShaderUniform<io.homo.superresolution.core.impl.Vec4> {
        public Vec4(int program, int location, GlShaderUniforms shaderUniforms) {
            super(program, location, shaderUniforms);
        }

        @Override
        public GlShaderUniforms value(io.homo.superresolution.core.impl.Vec4 value) {
            this.set(value.x(), value.y(), value.z(), value.w());
            return this.shaderUniforms;
        }

        public GlShaderUniforms value(float x, float y, float z, float w) {
            this.set(x, y, z, w);
            return this.shaderUniforms;
        }
    }

    public static class Vec3
    extends GlShaderUniform<io.homo.superresolution.core.impl.Vec3> {
        public Vec3(int program, int location, GlShaderUniforms shaderUniforms) {
            super(program, location, shaderUniforms);
        }

        @Override
        public GlShaderUniforms value(io.homo.superresolution.core.impl.Vec3 value) {
            this.set(value.x(), value.y(), value.z());
            return this.shaderUniforms;
        }

        public GlShaderUniforms value(float x, float y, float z) {
            this.set(x, y, z);
            return this.shaderUniforms;
        }
    }

    public static class Vec2
    extends GlShaderUniform<io.homo.superresolution.core.impl.Vec2> {
        public Vec2(int program, int location, GlShaderUniforms shaderUniforms) {
            super(program, location, shaderUniforms);
        }

        @Override
        public GlShaderUniforms value(io.homo.superresolution.core.impl.Vec2 value) {
            this.set(value.x(), value.y());
            return this.shaderUniforms;
        }

        public GlShaderUniforms value(float x, float y) {
            this.set(x, y);
            return this.shaderUniforms;
        }
    }
}

