/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.impl.framebuffer;

import io.homo.superresolution.core.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.impl.texture.ITexture;
import io.homo.superresolution.core.impl.texture.TextureFormat;

public class FrameBufferTextureAdapter
implements ITexture {
    private final IFrameBuffer frameBuffer;
    private final FrameBufferAttachmentType attachmentType;

    FrameBufferTextureAdapter(IFrameBuffer frameBuffer, FrameBufferAttachmentType attachmentType) {
        this.frameBuffer = frameBuffer;
        this.attachmentType = attachmentType;
    }

    public static FrameBufferTextureAdapter ofColor(IFrameBuffer frameBuffer) {
        return FrameBufferTextureAdapter.of(frameBuffer, FrameBufferAttachmentType.COLOR);
    }

    public static FrameBufferTextureAdapter ofDepth(IFrameBuffer frameBuffer) {
        return FrameBufferTextureAdapter.of(frameBuffer, FrameBufferAttachmentType.ANY_DEPTH);
    }

    public static FrameBufferTextureAdapter of(IFrameBuffer frameBuffer, FrameBufferAttachmentType attachmentType) {
        return new FrameBufferTextureAdapter(frameBuffer, attachmentType);
    }

    @Override
    public int getTextureId() {
        return this.frameBuffer.getTextureId(this.attachmentType);
    }

    @Override
    public TextureFormat getTextureFormat() {
        return this.attachmentType.equals((Object)FrameBufferAttachmentType.COLOR) ? this.frameBuffer.getColorTextureFormat() : this.frameBuffer.getDepthTextureFormat();
    }

    @Override
    public int getWidth() {
        return this.frameBuffer.getWidth();
    }

    @Override
    public int getHeight() {
        return this.frameBuffer.getHeight();
    }

    @Override
    public void destroy() {
        throw new UnsupportedOperationException("This method is not implemented yet.");
    }

    @Override
    public void resize(int width, int height) {
        throw new UnsupportedOperationException("This method is not implemented yet.");
    }
}

