/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.utils;

import io.homo.superresolution.common.config.Config;
import io.homo.superresolution.common.platform.Platform;
import io.homo.superresolution.core.GraphicsCapabilities;
import io.homo.superresolution.core.SuperResolutionNative;
import io.homo.superresolution.core.gl.shader.AbstractGlShaderProgram;
import io.homo.superresolution.core.glslang.GlslangCompileShaderResult;
import io.homo.superresolution.core.glslang.GlslangShaderCompiler;
import io.homo.superresolution.core.glslang.enums.EProfile;
import io.homo.superresolution.core.glslang.enums.EShClient;
import io.homo.superresolution.core.glslang.enums.EShLanguage;
import io.homo.superresolution.core.glslang.enums.EShSource;
import io.homo.superresolution.core.glslang.enums.EShTargetClientVersion;
import io.homo.superresolution.core.glslang.enums.EShTargetLanguage;
import io.homo.superresolution.core.glslang.enums.EShTargetLanguageVersion;
import io.homo.superresolution.core.glslang.enums.GlslangCompileShaderError;
import io.homo.superresolution.core.impl.shader.ShaderSource;
import io.homo.superresolution.core.utils.Md5CaculateUtil;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaderCache {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SuperResolution-ShaderCache");
    public static final Path CACHE_DIR = Path.of(Platform.currentPlatform.getGameFolder().toString(), "sr_shaderCache");
    public static final Map<String, ShaderBinary> CACHE = new HashMap<String, ShaderBinary>();

    public static void createCacheDir() {
        File cacheDir = CACHE_DIR.toFile();
        if (!cacheDir.exists() && !cacheDir.mkdirs()) {
            LOGGER.error("\u65e0\u6cd5\u521b\u5efa\u7740\u8272\u5668\u7f13\u5b58\u76ee\u5f55: {}", (Object)CACHE_DIR);
        }
    }

    private static String getShaderProgramMd5(AbstractGlShaderProgram shaderProgram) {
        ShaderCache.createCacheDir();
        StringBuilder identityBuilder = new StringBuilder();
        for (ShaderSource.Type type : ShaderSource.Type.values()) {
            ShaderSource sources = shaderProgram.getShaderSources().get((Object)type);
            if (sources == null) continue;
            identityBuilder.append(type.name()).append(":");
            identityBuilder.append(sources.getSource());
        }
        List sortedDefines = shaderProgram.getShaderDefineList().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).sorted().collect(Collectors.toList());
        identityBuilder.append(shaderProgram.shaderName).append(String.join((CharSequence)"|", sortedDefines)).append(GraphicsCapabilities.getGLVersion()[0]).append(GraphicsCapabilities.getGLVersion()[1]).append(GL11.glGetString((int)7936)).append(GL11.glGetString((int)7937));
        return Md5CaculateUtil.getMD5(identityBuilder.toString());
    }

    public static boolean saveProgramBinary(AbstractGlShaderProgram program) {
        ShaderCache.createCacheDir();
        String hash = ShaderCache.getShaderProgramMd5(program);
        GlslangCompileShaderResult currentSourceResult = null;
        try {
            for (Map.Entry<ShaderSource.Type, ShaderSource> entry : program.getShaderSources().entrySet()) {
                ShaderSource.Type type = entry.getKey();
                ShaderSource source = entry.getValue();
                String suffix = ShaderCache.getShaderSuffix(type);
                Path path = CACHE_DIR.resolve(program.shaderName + "." + hash + "." + suffix);
                currentSourceResult = ShaderCache.compileShaderToSpirv(source.getSource(), ShaderCache.mapToGlslangType(type));
                LOGGER.info("\u5f00\u59cbSPIR-V\u7f16\u8bd1: \u7c7b\u578b={}\uff0c\u7f13\u5b58\u8def\u5f84={}", (Object)type.name(), (Object)path);
                if (currentSourceResult.error() != GlslangCompileShaderError.OK) {
                    LOGGER.error("\u7740\u8272\u5668\u7f16\u8bd1\u5931\u8d25[{}]\uff0c\u9519\u8bef\u7c7b\u578b={}\uff0c\u65e5\u5fd7={}", new Object[]{type.name(), currentSourceResult.error().name(), currentSourceResult.log()});
                    throw new AbstractGlShaderProgram.ShaderCompileException(currentSourceResult.log());
                }
                ByteBuffer buffer = currentSourceResult.spirvBuffer();
                long size = currentSourceResult.spirVDataSize();
                if (buffer == null || size <= 0L) {
                    LOGGER.error("SPIR-V\u7f13\u51b2\u533a\u4e3a\u7a7a\u6216\u5927\u5c0f\u975e\u6cd5\uff0ctype={}, size={}", (Object)type.name(), (Object)size);
                    throw new IOException("SPIR-V\u7f13\u51b2\u533a\u4e3a\u7a7a\u6216\u5927\u5c0f\u975e\u6cd5");
                }
                LOGGER.info("\u4fdd\u5b58SPIR-V\uff0c\u5927\u5c0f={} bytes, \u8def\u5f84={}", (Object)size, (Object)path);
                if (Config.getInstance().isDebugDumpShader()) {
                    try {
                        Path srcPath = Path.of(CACHE_DIR.toAbsolutePath().toString(), program.shaderName + ".source.glsl");
                        Path prePath = Path.of(CACHE_DIR.toAbsolutePath().toString(), program.shaderName + ".preprocessed.glsl");
                        LOGGER.debug("\u5199\u51faGLSL\u6e90\u7801\u8c03\u8bd5\u6587\u4ef6: {}\uff0c{}", (Object)srcPath, (Object)prePath);
                        Files.write(srcPath, currentSourceResult.sourceCode().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                        Files.write(prePath, currentSourceResult.preprocessedCode().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    }
                    catch (IOException e0) {
                        LOGGER.error("\u65e0\u6cd5\u4fdd\u5b58\u7740\u8272\u5668\u6e90\u7801\u6587\u4ef6: {}", (Object)e0.getMessage());
                        e0.printStackTrace();
                    }
                }
                try {
                    byte[] outBytes = new byte[(int)size];
                    buffer.position(0);
                    buffer.get(outBytes);
                    Files.write(path, outBytes, new OpenOption[0]);
                    LOGGER.info("SPIR-V\u4fdd\u5b58\u6210\u529f: {}", (Object)path);
                }
                catch (IOException e) {
                    LOGGER.error("\u4fdd\u5b58SPIR-V\u5931\u8d25", (Throwable)e);
                    e.printStackTrace();
                }
                SuperResolutionNative.freeDirectBuffer(buffer);
                LOGGER.debug("\u91ca\u653eDirectBuffer\u5b8c\u6210");
            }
            return true;
        }
        catch (AbstractGlShaderProgram.ShaderCompileException | IOException e) {
            Path sourcePath = Path.of(program.shaderName + ".glsl", new String[0]);
            try {
                LOGGER.debug("\u7740\u8272\u5668\u7f16\u8bd1\u5f02\u5e38\u7c7b\u578b: {}", (Object)(currentSourceResult != null ? currentSourceResult.error().name() : "null"));
                LOGGER.debug("\u7f16\u8bd1\u65e5\u5fd7: {}", (Object)(currentSourceResult != null ? currentSourceResult.log() : "null"));
                LOGGER.debug("\u6e90\u4ee3\u7801: {}", (Object)(currentSourceResult != null ? currentSourceResult.sourceCode() : "null"));
                LOGGER.debug("\u9884\u5904\u7406\u4ee3\u7801: {}", (Object)(currentSourceResult != null ? currentSourceResult.preprocessedCode() : "null"));
                Files.write(Path.of(program.shaderName + ".error.source.glsl", new String[0]), currentSourceResult != null ? currentSourceResult.sourceCode().getBytes(StandardCharsets.UTF_8) : new byte[]{}, new OpenOption[0]);
                Files.write(Path.of(program.shaderName + ".error.preprocessed.glsl", new String[0]), currentSourceResult != null ? currentSourceResult.preprocessedCode().getBytes(StandardCharsets.UTF_8) : new byte[]{}, new OpenOption[0]);
                Files.write(Path.of(program.shaderName + ".error.log", new String[0]), currentSourceResult != null ? currentSourceResult.log().getBytes(StandardCharsets.UTF_8) : new byte[]{}, new OpenOption[0]);
                LOGGER.info("\u4fdd\u5b58\u9519\u8bef\u7740\u8272\u5668\u6e90\u7801\u81f3: {}", (Object)sourcePath);
            }
            catch (IOException e0) {
                LOGGER.error("\u65e0\u6cd5\u4fdd\u5b58\u7740\u8272\u5668\u6e90\u7801\u6587\u4ef6: {}", (Object)e0.getMessage());
            }
            LOGGER.error("\u4fdd\u5b58SPIR-V\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
            return false;
        }
    }

    private static EShLanguage mapToGlslangType(ShaderSource.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ShaderSource.Type.VERTEX -> EShLanguage.EShLangVertex;
            case ShaderSource.Type.FRAGMENT -> EShLanguage.EShLangFragment;
            case ShaderSource.Type.COMPUTE -> EShLanguage.EShLangCompute;
        };
    }

    public static boolean checkProgramBinary(AbstractGlShaderProgram program) {
        ShaderCache.createCacheDir();
        String hash = ShaderCache.getShaderProgramMd5(program);
        for (ShaderSource.Type type : program.getShaderSources().keySet()) {
            String suffix = ShaderCache.getShaderSuffix(type);
            if (Files.exists(CACHE_DIR.resolve(program.shaderName + "." + hash + "." + suffix), new LinkOption[0])) continue;
            LOGGER.info("\u672a\u627e\u5230\u7f13\u5b58\u6587\u4ef6: {}", (Object)CACHE_DIR.resolve(program.shaderName + "." + hash + "." + suffix));
            return false;
        }
        LOGGER.info("\u7740\u8272\u5668\u7f13\u5b58\u6587\u4ef6\u5b58\u5728\u3002");
        return true;
    }

    public static ShaderBinary getShaderBinary(AbstractGlShaderProgram program, ShaderSource.Type type) {
        ShaderCache.createCacheDir();
        String hash = ShaderCache.getShaderProgramMd5(program);
        String filename = program.shaderName + "." + hash + "." + ShaderCache.getShaderSuffix(type);
        LOGGER.info("\u52a0\u8f7d\u7f13\u5b58\u4e8c\u8fdb\u5236: {}", (Object)filename);
        return ShaderCache.loadBinary(filename);
    }

    private static String getShaderSuffix(ShaderSource.Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ShaderSource.Type.VERTEX -> "vert.spv";
            case ShaderSource.Type.FRAGMENT -> "frag.spv";
            case ShaderSource.Type.COMPUTE -> "comp.spv";
        };
    }

    private static GlslangCompileShaderResult compileShaderToSpirv(String src, EShLanguage stage) {
        ShaderCache.createCacheDir();
        LOGGER.debug("\u8c03\u7528GlslangShaderCompiler\u7f16\u8bd1SPIR-V");
        GlslangCompileShaderResult result = GlslangShaderCompiler.compileShaderToSpirv(src, stage, EShSource.EShSourceGlsl, EShClient.EShClientOpenGL, EShTargetClientVersion.EShTargetOpenGL_450, EShTargetLanguage.EShTargetSpv, EShTargetLanguageVersion.EShTargetSpv_1_4, 460, EProfile.ENoProfile, true, false);
        LOGGER.debug("\u7f16\u8bd1SPIR-V\u7ed3\u675f\uff0c\u9519\u8bef\u7801={}, \u6570\u636e\u5927\u5c0f={}", (Object)result.error(), (Object)result.spirVDataSize());
        return result;
    }

    private static ShaderBinary loadBinary(String filename) {
        ShaderCache.createCacheDir();
        Path path = CACHE_DIR.resolve(filename);
        try {
            byte[] data = Files.readAllBytes(path);
            ByteBuffer buffer = MemoryUtil.memAlloc((int)data.length);
            buffer.put(data).flip();
            LOGGER.info("\u6210\u529f\u52a0\u8f7dSPIR-V\u7f13\u5b58\u6587\u4ef6: {}", (Object)filename);
            return new ShaderBinary(buffer, data.length, 38225);
        }
        catch (IOException e) {
            LOGGER.error("\u52a0\u8f7dSPIR-V\u5931\u8d25: {}", (Object)filename);
            e.printStackTrace();
            return null;
        }
    }

    static {
        ShaderCache.createCacheDir();
    }

    public record ShaderBinary(ByteBuffer binary, int size, int format) implements AutoCloseable
    {
        @Override
        public void close() {
            MemoryUtil.memFree((Buffer)this.binary);
        }
    }
}

