/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.vulkan;

import io.homo.superresolution.core.impl.Destroyable;
import io.homo.superresolution.core.vulkan.QueueFamilyIndices;
import io.homo.superresolution.core.vulkan.Utils;
import io.homo.superresolution.core.vulkan.VkApplication;
import io.homo.superresolution.core.vulkan.VkException;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.stream.IntStream;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.Struct;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkBufferCreateInfo;
import org.lwjgl.vulkan.VkDescriptorPoolCreateInfo;
import org.lwjgl.vulkan.VkDescriptorPoolSize;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkDeviceCreateInfo;
import org.lwjgl.vulkan.VkDeviceQueueCreateInfo;
import org.lwjgl.vulkan.VkExtensionProperties;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkMemoryAllocateInfo;
import org.lwjgl.vulkan.VkMemoryRequirements;
import org.lwjgl.vulkan.VkPhysicalDevice;
import org.lwjgl.vulkan.VkPhysicalDeviceFeatures;
import org.lwjgl.vulkan.VkPhysicalDeviceMemoryProperties;
import org.lwjgl.vulkan.VkPhysicalDeviceProperties;
import org.lwjgl.vulkan.VkQueue;
import org.lwjgl.vulkan.VkQueueFamilyProperties;
import org.lwjgl.vulkan.VkSamplerCreateInfo;

public class VkDeviceManager
implements Destroyable {
    public final VkApplication application;
    public VkPhysicalDevice physicalDevice;
    public VkDevice device;
    public VkQueue graphicsQueue;
    public long textureSampler;
    public long descriptorPool;
    public VkPhysicalDeviceProperties physicalDeviceProperties;
    public VkPhysicalDeviceMemoryProperties deviceMemoryProperties;
    public ArrayList<String> deviceExtensions = new ArrayList();
    public QueueFamilyIndices queueFamilyIndices;

    public VkDeviceManager(VkApplication application) {
        this.application = application;
    }

    public ArrayList<String> getRequiredExtensions() {
        return this.application.deviceRequiredExtensions;
    }

    public void init() {
        this.pickPhysicalDevice();
        this.createLogicalDevice();
        this.createTextureSampler();
        this.createDescriptorPool();
    }

    private void createDescriptorPool() {
        int POOL_COUNT = 1000;
        VkDescriptorPoolSize.Buffer poolSize = VkDescriptorPoolSize.create((int)11);
        poolSize.put(0, (Struct)VkDescriptorPoolSize.calloc().type(0).descriptorCount(POOL_COUNT));
        poolSize.put(1, (Struct)VkDescriptorPoolSize.calloc().type(1).descriptorCount(POOL_COUNT));
        poolSize.put(2, (Struct)VkDescriptorPoolSize.calloc().type(2).descriptorCount(POOL_COUNT));
        poolSize.put(3, (Struct)VkDescriptorPoolSize.calloc().type(3).descriptorCount(POOL_COUNT));
        poolSize.put(4, (Struct)VkDescriptorPoolSize.calloc().type(4).descriptorCount(POOL_COUNT));
        poolSize.put(5, (Struct)VkDescriptorPoolSize.calloc().type(5).descriptorCount(POOL_COUNT));
        poolSize.put(6, (Struct)VkDescriptorPoolSize.calloc().type(6).descriptorCount(POOL_COUNT));
        poolSize.put(7, (Struct)VkDescriptorPoolSize.calloc().type(7).descriptorCount(POOL_COUNT));
        poolSize.put(8, (Struct)VkDescriptorPoolSize.calloc().type(8).descriptorCount(POOL_COUNT));
        poolSize.put(9, (Struct)VkDescriptorPoolSize.calloc().type(9).descriptorCount(POOL_COUNT));
        poolSize.put(10, (Struct)VkDescriptorPoolSize.calloc().type(10).descriptorCount(POOL_COUNT));
        int NUM_POOLS = poolSize.capacity();
        VkDescriptorPoolCreateInfo poolInfo = VkDescriptorPoolCreateInfo.calloc();
        poolInfo.sType(33);
        poolInfo.flags(1);
        poolInfo.maxSets(POOL_COUNT * NUM_POOLS);
        poolInfo.pPoolSizes(poolSize);
        LongBuffer ptr = MemoryStack.stackCallocLong((int)1);
        VK10.vkCreateDescriptorPool((VkDevice)this.device, (VkDescriptorPoolCreateInfo)poolInfo, null, (LongBuffer)ptr);
        this.descriptorPool = ptr.get(0);
    }

    private void createTextureSampler() {
        VkSamplerCreateInfo samplerInfo = VkSamplerCreateInfo.calloc();
        samplerInfo.sType(31);
        samplerInfo.magFilter(1);
        samplerInfo.minFilter(1);
        samplerInfo.addressModeU(0);
        samplerInfo.addressModeV(0);
        samplerInfo.addressModeW(0);
        samplerInfo.borderColor(3);
        samplerInfo.unnormalizedCoordinates(false);
        samplerInfo.compareEnable(false);
        samplerInfo.compareOp(7);
        samplerInfo.mipmapMode(1);
        LongBuffer ptr = MemoryStack.stackCallocLong((int)1);
        VK10.vkCreateSampler((VkDevice)this.device, (VkSamplerCreateInfo)samplerInfo, null, (LongBuffer)ptr);
        this.textureSampler = ptr.get(0);
    }

    private void pickPhysicalDevice() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer deviceCount = stack.ints(0);
            VK10.vkEnumeratePhysicalDevices((VkInstance)this.application.instance, (IntBuffer)deviceCount, null);
            if (deviceCount.get(0) == 0) {
                throw new VkException("Failed to find GPUs with Vulkan support");
            }
            PointerBuffer ppPhysicalDevices = stack.mallocPointer(deviceCount.get(0));
            VK10.vkEnumeratePhysicalDevices((VkInstance)this.application.instance, (IntBuffer)deviceCount, (PointerBuffer)ppPhysicalDevices);
            for (int i = 0; i < ppPhysicalDevices.capacity(); ++i) {
                VkPhysicalDevice device = new VkPhysicalDevice(ppPhysicalDevices.get(i), this.application.instance);
                if (!this.isDeviceSuitable(device)) continue;
                this.physicalDevice = device;
                return;
            }
            throw new VkException("Failed to find a suitable GPU");
        }
    }

    private void createLogicalDevice() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pDevice;
            QueueFamilyIndices indices = this.findQueueFamilies(this.physicalDevice);
            int[] uniqueQueueFamilies = indices.unique();
            VkDeviceQueueCreateInfo.Buffer queueCreateInfos = VkDeviceQueueCreateInfo.calloc((int)uniqueQueueFamilies.length, (MemoryStack)stack);
            for (int i = 0; i < uniqueQueueFamilies.length; ++i) {
                VkDeviceQueueCreateInfo queueCreateInfo = (VkDeviceQueueCreateInfo)queueCreateInfos.get(i);
                queueCreateInfo.sType(2);
                queueCreateInfo.queueFamilyIndex(uniqueQueueFamilies[i]);
                queueCreateInfo.pQueuePriorities(stack.floats(1.0f));
            }
            VkDeviceCreateInfo createInfo = VkDeviceCreateInfo.calloc((MemoryStack)stack);
            createInfo.sType(3);
            createInfo.pQueueCreateInfos(queueCreateInfos);
            createInfo.pEnabledFeatures(VkPhysicalDeviceFeatures.calloc((MemoryStack)stack).shaderStorageImageWriteWithoutFormat(true));
            createInfo.ppEnabledExtensionNames(Utils.asPointerBuffer(stack, this.getRequiredExtensions()));
            if (VkApplication.ENABLE_VALIDATION) {
                createInfo.ppEnabledLayerNames(this.application.validationLayers.validationLayersAsPointerBuffer(stack));
            }
            if (VK10.vkCreateDevice((VkPhysicalDevice)this.physicalDevice, (VkDeviceCreateInfo)createInfo, null, (PointerBuffer)(pDevice = stack.pointers(0L))) != 0) {
                throw new VkException("Failed to create logical device");
            }
            this.device = new VkDevice(pDevice.get(0), this.physicalDevice, createInfo);
            this.physicalDeviceProperties = VkPhysicalDeviceProperties.calloc();
            this.deviceMemoryProperties = VkPhysicalDeviceMemoryProperties.calloc();
            VK10.vkGetPhysicalDeviceProperties((VkPhysicalDevice)this.physicalDevice, (VkPhysicalDeviceProperties)this.physicalDeviceProperties);
            VK10.vkGetPhysicalDeviceMemoryProperties((VkPhysicalDevice)this.physicalDevice, (VkPhysicalDeviceMemoryProperties)this.deviceMemoryProperties);
            PointerBuffer pQueue = stack.pointers(0L);
            VK10.vkGetDeviceQueue((VkDevice)this.device, (int)indices.graphicsFamily, (int)0, (PointerBuffer)pQueue);
            this.graphicsQueue = new VkQueue(pQueue.get(0), this.device);
            this.queueFamilyIndices = indices;
        }
    }

    private boolean isDeviceSuitable(VkPhysicalDevice device) {
        QueueFamilyIndices indices = this.findQueueFamilies(device);
        return indices.isComplete() && this.checkDeviceExtensionSupport(device);
    }

    protected QueueFamilyIndices findQueueFamilies(VkPhysicalDevice device) {
        QueueFamilyIndices indices = new QueueFamilyIndices();
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer queueFamilyCount = stack.ints(0);
            VK10.vkGetPhysicalDeviceQueueFamilyProperties((VkPhysicalDevice)device, (IntBuffer)queueFamilyCount, null);
            VkQueueFamilyProperties.Buffer queueFamilies = VkQueueFamilyProperties.malloc((int)queueFamilyCount.get(0), (MemoryStack)stack);
            VK10.vkGetPhysicalDeviceQueueFamilyProperties((VkPhysicalDevice)device, (IntBuffer)queueFamilyCount, (VkQueueFamilyProperties.Buffer)queueFamilies);
            IntStream.range(0, queueFamilies.capacity()).filter(index -> (((VkQueueFamilyProperties)queueFamilies.get(index)).queueFlags() & 1) != 0).findFirst().ifPresent(index -> {
                indices.graphicsFamily = index;
            });
            QueueFamilyIndices queueFamilyIndices = indices;
            return queueFamilyIndices;
        }
    }

    private boolean checkDeviceExtensionSupport(VkPhysicalDevice device) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer extensionCount = stack.ints(0);
            VK10.vkEnumerateDeviceExtensionProperties((VkPhysicalDevice)device, (CharSequence)null, (IntBuffer)extensionCount, null);
            VkExtensionProperties.Buffer availableExtensions = VkExtensionProperties.malloc((int)extensionCount.get(0), (MemoryStack)stack);
            VK10.vkEnumerateDeviceExtensionProperties((VkPhysicalDevice)device, (CharSequence)null, (IntBuffer)extensionCount, (VkExtensionProperties.Buffer)availableExtensions);
            this.deviceExtensions.clear();
            Iterator it = availableExtensions.stream().iterator();
            while (it.hasNext()) {
                VkExtensionProperties extension = (VkExtensionProperties)it.next();
                this.deviceExtensions.add(extension.extensionNameString());
            }
            for (String requiredExtension : this.getRequiredExtensions()) {
                if (this.deviceExtensions.contains(requiredExtension)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private int findMemoryType(MemoryStack stack, int typeFilter, int properties) {
        VkPhysicalDeviceMemoryProperties memProperties = VkPhysicalDeviceMemoryProperties.malloc((MemoryStack)stack);
        VK10.vkGetPhysicalDeviceMemoryProperties((VkPhysicalDevice)this.physicalDevice, (VkPhysicalDeviceMemoryProperties)memProperties);
        for (int i = 0; i < memProperties.memoryTypeCount(); ++i) {
            if ((typeFilter & 1 << i) == 0 || (memProperties.memoryTypes(i).propertyFlags() & properties) != properties) continue;
            return i;
        }
        throw new RuntimeException("Failed to find suitable memory type");
    }

    public void createBuffer(long size, int usage, int properties, LongBuffer pBuffer, LongBuffer pBufferMemory) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkBufferCreateInfo bufferInfo = VkBufferCreateInfo.calloc((MemoryStack)stack);
            bufferInfo.sType(12);
            bufferInfo.size(size);
            bufferInfo.usage(usage);
            bufferInfo.sharingMode(0);
            if (VK10.vkCreateBuffer((VkDevice)this.device, (VkBufferCreateInfo)bufferInfo, null, (LongBuffer)pBuffer) != 0) {
                throw new RuntimeException("Failed to create vertex buffer");
            }
            VkMemoryRequirements memRequirements = VkMemoryRequirements.malloc((MemoryStack)stack);
            VK10.vkGetBufferMemoryRequirements((VkDevice)this.device, (long)pBuffer.get(0), (VkMemoryRequirements)memRequirements);
            VkMemoryAllocateInfo allocInfo = VkMemoryAllocateInfo.calloc((MemoryStack)stack);
            allocInfo.sType(5);
            allocInfo.allocationSize(memRequirements.size());
            allocInfo.memoryTypeIndex(this.findMemoryType(stack, memRequirements.memoryTypeBits(), properties));
            if (VK10.vkAllocateMemory((VkDevice)this.device, (VkMemoryAllocateInfo)allocInfo, null, (LongBuffer)pBufferMemory) != 0) {
                throw new RuntimeException("Failed to allocate vertex buffer memory");
            }
            VK10.vkBindBufferMemory((VkDevice)this.device, (long)pBuffer.get(0), (long)pBufferMemory.get(0), (long)0L);
        }
    }

    @Override
    public void destroy() {
        VK10.vkDestroyDevice((VkDevice)this.device, null);
    }
}

