/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.vulkan;

import io.homo.superresolution.core.impl.Destroyable;
import io.homo.superresolution.core.vulkan.VkApplication;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.vulkan.EXTDebugUtils;
import org.lwjgl.vulkan.VK10;
import org.lwjgl.vulkan.VkDebugUtilsMessengerCallbackDataEXT;
import org.lwjgl.vulkan.VkDebugUtilsMessengerCreateInfoEXT;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkLayerProperties;

public class VkValidationLayers
implements Destroyable {
    private static final Set<String> VALIDATION_LAYERS = new HashSet<String>();
    private final VkApplication application;
    private long debugMessenger;

    public VkValidationLayers(VkApplication application) {
        this.application = application;
    }

    public static boolean checkValidationLayerSupport() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer layerCount = stack.ints(0);
            VK10.vkEnumerateInstanceLayerProperties((IntBuffer)layerCount, null);
            VkLayerProperties.Buffer availableLayers = VkLayerProperties.malloc((int)layerCount.get(0), (MemoryStack)stack);
            VK10.vkEnumerateInstanceLayerProperties((IntBuffer)layerCount, (VkLayerProperties.Buffer)availableLayers);
            Set availableLayerNames = availableLayers.stream().map(VkLayerProperties::layerNameString).collect(Collectors.toSet());
            boolean bl = availableLayerNames.containsAll(VALIDATION_LAYERS);
            return bl;
        }
    }

    public static int debugCallback(int messageSeverity, int messageType, long pCallbackData, long pUserData) {
        VkDebugUtilsMessengerCallbackDataEXT callbackData = VkDebugUtilsMessengerCallbackDataEXT.create((long)pCallbackData);
        String message = callbackData.pMessageString();
        switch (messageSeverity) {
            case 256: {
                VkApplication.LOGGER.warn("Validation layer: {}", (Object)message);
                break;
            }
            case 4096: {
                VkApplication.LOGGER.error("Validation layer: {}", (Object)message);
                break;
            }
            default: {
                VkApplication.LOGGER.info("Validation layer: {}", (Object)message);
            }
        }
        return 0;
    }

    private int createDebugUtilsMessengerEXT(VkInstance instance, VkDebugUtilsMessengerCreateInfoEXT createInfo, LongBuffer pDebugMessenger) {
        if (VK10.vkGetInstanceProcAddr((VkInstance)instance, (CharSequence)"vkCreateDebugUtilsMessengerEXT") != 0L) {
            return EXTDebugUtils.vkCreateDebugUtilsMessengerEXT((VkInstance)instance, (VkDebugUtilsMessengerCreateInfoEXT)createInfo, null, (LongBuffer)pDebugMessenger);
        }
        return -7;
    }

    private void destroyDebugUtilsMessengerEXT(VkInstance instance, long debugMessenger) {
        if (VK10.vkGetInstanceProcAddr((VkInstance)instance, (CharSequence)"vkDestroyDebugUtilsMessengerEXT") != 0L) {
            EXTDebugUtils.vkDestroyDebugUtilsMessengerEXT((VkInstance)instance, (long)debugMessenger, null);
        }
    }

    public void populateDebugMessengerCreateInfo(VkDebugUtilsMessengerCreateInfoEXT debugCreateInfo) {
        debugCreateInfo.sType(1000128004);
        debugCreateInfo.messageSeverity(4353);
        debugCreateInfo.messageType(7);
        debugCreateInfo.pfnUserCallback(VkValidationLayers::debugCallback);
    }

    public void setupDebugMessenger() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            VkDebugUtilsMessengerCreateInfoEXT createInfo = VkDebugUtilsMessengerCreateInfoEXT.calloc((MemoryStack)stack);
            this.populateDebugMessengerCreateInfo(createInfo);
            LongBuffer pDebugMessenger = stack.longs(0L);
            if (this.createDebugUtilsMessengerEXT(this.application.instance, createInfo, pDebugMessenger) != 0) {
                throw new RuntimeException("Failed to set up debug messenger");
            }
            this.debugMessenger = pDebugMessenger.get(0);
        }
    }

    public PointerBuffer validationLayersAsPointerBuffer(MemoryStack stack) {
        PointerBuffer buffer = stack.mallocPointer(VALIDATION_LAYERS.size());
        VALIDATION_LAYERS.stream().map(arg_0 -> ((MemoryStack)stack).UTF8(arg_0)).forEach(arg_0 -> ((PointerBuffer)buffer).put(arg_0));
        return (PointerBuffer)buffer.rewind();
    }

    public long getDebugMessenger() {
        return this.debugMessenger;
    }

    @Override
    public void destroy() {
        this.destroyDebugUtilsMessengerEXT(this.application.instance, this.debugMessenger);
    }

    static {
        VALIDATION_LAYERS.add("VK_LAYER_KHRONOS_validation");
    }
}

