/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.api.event;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class Event<T> {
    private final Class<T> listenerType;
    private final Function<T[], T> invokerFactory;
    private final List<T> listeners = new ArrayList<T>();
    private T invoker;

    public Event(Class<T> listenerType, Function<T[], T> invokerFactory) {
        this.listenerType = listenerType;
        this.invokerFactory = invokerFactory;
        this.updateInvoker();
    }

    public void register(T listener) {
        this.listeners.add(listener);
        this.updateInvoker();
    }

    public T invoker() {
        return this.invoker;
    }

    private void updateInvoker() {
        Object[] listenersArray = this.listeners.toArray((Object[])Array.newInstance(this.listenerType, 0));
        this.invoker = this.invokerFactory.apply((Object[][])listenersArray);
    }
}

