/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.config;

import com.google.gson.GsonBuilder;
import io.homo.superresolution.api.registry.AlgorithmDescription;
import io.homo.superresolution.common.SuperResolution;
import io.homo.superresolution.common.config.AlgorithmDescriptionSerializer;
import io.homo.superresolution.common.config.ConfigData;
import io.homo.superresolution.common.config.EnumSerializer;
import io.homo.superresolution.common.config.enums.CaptureMode;
import io.homo.superresolution.common.config.enums.SgsrVariant;
import io.homo.superresolution.common.config.special.SpecialConfigs;
import io.homo.superresolution.common.minecraft.MinecraftRenderHandle;
import java.util.List;
import net.minecraft.class_310;

public class Config {
    private static ConfigData instance = new ConfigData();
    private static Runnable resolutionChangeCallback;

    public static List<String> getInjectPostChainBlackList() {
        return instance.getInjectPostChainBlackList();
    }

    public static void setInjectPostChainBlackList(List<String> injectPostChainBlackList) {
        instance.setInjectPostChainBlackList(injectPostChainBlackList);
    }

    public static boolean isEnableRenderDoc() {
        return instance.isEnableRenderDoc();
    }

    public static void setEnableRenderDoc(boolean enableRenderDoc) {
        instance.setEnableRenderDoc(enableRenderDoc);
    }

    public static boolean isEnableImgui() {
        return instance.isEnableImgui();
    }

    public static void setEnableImgui(boolean enableImgui) {
        instance.setEnableImgui(enableImgui);
    }

    public static ConfigData getInstance() {
        return instance;
    }

    public static void setInstance(ConfigData instance) {
        if (instance != null) {
            Config.instance = instance;
        }
    }

    public static void registerTypeAdapter(GsonBuilder gsonBuilder) {
        gsonBuilder.registerTypeAdapter(AlgorithmDescription.class, (Object)new AlgorithmDescriptionSerializer());
        gsonBuilder.registerTypeAdapter(CaptureMode.class, new EnumSerializer.Builder<CaptureMode>().addMapping("a", CaptureMode.A).addMapping("b", CaptureMode.B).addMapping("c", CaptureMode.C).setDefault(CaptureMode.A).build());
        gsonBuilder.registerTypeAdapter(SgsrVariant.class, new EnumSerializer.Builder<SgsrVariant>().addMapping("CS_2", SgsrVariant.CS_2).addMapping("CS_3", SgsrVariant.CS_3).addMapping("FS_2", SgsrVariant.FS_2).setDefault(SgsrVariant.CS_2).build());
    }

    public static CaptureMode getCaptureMode() {
        return instance.getCaptureMode();
    }

    public static void setCaptureMode(CaptureMode captureMode) {
        instance.setCaptureMode(captureMode);
    }

    public static float getRenderScaleFactor() {
        return instance.getRenderScaleFactor();
    }

    public static float getUpscaleRatio() {
        return instance.getUpscaleRatio();
    }

    public static void setUpscaleRatio(float value) {
        boolean resolutionChanged = Config.getUpscaleRatio() != value;
        instance.setUpscaleRatio(value);
        if (resolutionChanged) {
            Config.runResolutionChangeCallback();
        }
    }

    public static AlgorithmDescription<?> getUpscaleAlgo() {
        return instance.getUpscaleAlgo();
    }

    public static void setUpscaleAlgo(AlgorithmDescription<?> upscaleAlgo) {
        instance.setUpscaleAlgo(upscaleAlgo);
    }

    public static float getSharpness() {
        return instance.getSharpness();
    }

    public static void setSharpness(float sharpness) {
        instance.setSharpness(sharpness);
    }

    public static double getMinUpscaleRatio() {
        int maxSize = 16384;
        if (class_310.method_1551().method_22683() == null) {
            return 0.1;
        }
        double maxWidth = 1.0 / ((double)maxSize / (double)class_310.method_1551().method_22683().method_4480());
        double maxHeight = 1.0 / ((double)maxSize / (double)class_310.method_1551().method_22683().method_4507());
        return Math.max(maxWidth, maxHeight);
    }

    public static boolean isEnableUpscale() {
        return instance.isEnableUpscale();
    }

    public static void setEnableUpscale(boolean enableUpscale) {
        boolean resolutionChanged = Config.isEnableUpscale() != enableUpscale;
        instance.setEnableUpscale(enableUpscale);
        if (resolutionChanged) {
            Config.runResolutionChangeCallback();
        }
    }

    public static SpecialConfigs getSpecial() {
        return instance.getSpecial();
    }

    public static void setSpecial(SpecialConfigs special) {
        instance.setSpecial(special);
    }

    public static void setResolutionChangeCallback(Runnable callback) {
        resolutionChangeCallback = callback;
    }

    public static boolean isPauseGameOnGui() {
        return instance.isPauseGameOnGui();
    }

    public static ConfigData setPauseGameOnGui(boolean pauseGameOnGui) {
        return instance.setPauseGameOnGui(pauseGameOnGui);
    }

    public static boolean isDebugDumpShader() {
        return instance.isDebugDumpShader();
    }

    public static void setDebugDumpShader(boolean debugDumpShader) {
        instance.setDebugDumpShader(debugDumpShader);
    }

    private static void runResolutionChangeCallback() {
        if (resolutionChangeCallback != null) {
            resolutionChangeCallback.run();
        }
    }

    public static boolean isSkipInitVulkan() {
        return instance.isSkipInitVulkan();
    }

    public static void setSkipInitVulkan(boolean skipInitVulkan) {
        instance.setSkipInitVulkan(skipInitVulkan);
    }

    public static boolean isGenerateMotionVectors() {
        return instance.isGenerateMotionVectors();
    }

    public static void setGenerateMotionVectors(boolean generateMotionVectors) {
        instance.setGenerateMotionVectors(generateMotionVectors);
    }

    static {
        Config.setResolutionChangeCallback(() -> {
            MinecraftRenderHandle.resize();
            SuperResolution.getInstance().resize(MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight());
            class_310.method_1551().field_1769.method_3242(MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight());
        });
    }
}

