/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.gui.entries;

import com.mojang.blaze3d.systems.RenderSystem;
import io.homo.superresolution.common.gui.InfoBuilder;
import io.homo.superresolution.common.gui.Rectangle;
import io.homo.superresolution.common.gui.ScissorsHandler;
import io.homo.superresolution.common.gui.widgets.Line;
import io.homo.superresolution.core.utils.ColorUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.animator.ValueAnimator;
import me.shedaniel.clothconfig2.gui.AbstractConfigScreen;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClothTextListListEntry
extends TooltipListEntry<Object>
implements InfoBuilder.LineContainer {
    public static final int DISABLED_COLOR;
    protected static final class_2960 CONFIG_TEX;
    protected final class_327 textRenderer;
    private final ValueAnimator<Double> expandAnimator = ValueAnimator.ofDouble((double)0.0);
    private final ValueAnimator<Double> rotatingAnimator = ValueAnimator.ofDouble((double)0.0);
    private final ValueAnimator<Double> backgroundAnimator = ValueAnimator.ofDouble((double)0.0);
    private final me.shedaniel.math.Rectangle mainRectangle = new me.shedaniel.math.Rectangle();
    private final List<LineRenderer> lineRenderers = new ArrayList<LineRenderer>();
    private final boolean canExpand;
    protected int savedWidth;
    protected int savedX;
    protected int savedY;
    private int top = 0;
    private int bottom = 0;
    private boolean expanded = false;
    private boolean showExpandButton = true;
    private boolean hoverdText = false;

    public ClothTextListListEntry(class_2561 fieldName, Supplier<Optional<class_2561[]>> tooltipSupplier) {
        this(fieldName, tooltipSupplier, true);
    }

    public ClothTextListListEntry(class_2561 fieldName, Supplier<Optional<class_2561[]>> tooltipSupplier, boolean canExpand) {
        super(fieldName, tooltipSupplier);
        this.textRenderer = class_310.method_1551().field_1772;
        this.canExpand = canExpand;
        if (!this.canExpand) {
            this.expanded = true;
            this.expandAnimator.setAs((Object)1.0);
            this.rotatingAnimator.setAs((Object)1.0);
        }
    }

    public ClothTextListListEntry setTop(int top) {
        this.top = top;
        return this;
    }

    public ClothTextListListEntry setBottom(int bottom) {
        this.bottom = bottom;
        return this;
    }

    public ClothTextListListEntry setShowExpandButton(boolean showExpandButton) {
        this.showExpandButton = showExpandButton;
        return this;
    }

    @Override
    public void addLine(Line line) {
        this.lineRenderers.add(LineRenderer.of(line));
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        if (!this.canExpand) {
            return;
        }
        this.expanded = expanded;
        if (this.expanded) {
            this.expandAnimator.setTo((Object)1.0, 1800L);
            this.rotatingAnimator.setTo((Object)1.0, 400L);
        } else {
            this.expandAnimator.setTo((Object)0.0, 1800L);
            this.rotatingAnimator.setTo((Object)0.0, 400L);
        }
    }

    public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        if (isHovered) {
            this.backgroundAnimator.setTo((Object)1.0, 300L);
        } else {
            this.backgroundAnimator.setTo((Object)0.0, 300L);
        }
        this.expandAnimator.update((double)delta);
        this.rotatingAnimator.update((double)delta);
        this.backgroundAnimator.update((double)delta);
        this.mainRectangle.setBounds(x, y, entryWidth, entryHeight);
        this.savedWidth = entryWidth;
        this.savedX = x;
        this.savedY = y;
        int sideWidth = 2;
        int backgroundAlpha = (int)(30.0 * (Double)this.backgroundAnimator.value()) + 20;
        class_2583 style = this.getTextAt(mouseX, mouseY);
        this.hoverdText = style != null;
        graphics.method_25296(x, y, x + entryWidth - 1, y + entryHeight, ColorUtil.color(backgroundAlpha, 255, 255, 255), ColorUtil.color(backgroundAlpha, 255, 255, 255));
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        if (this.canExpand && this.showExpandButton) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.method_51448().method_22903();
            float center = 4.5f;
            graphics.method_51448().method_46416((float)(x - 8) + center + (float)entryWidth - 7.0f, (float)(y + 5) + center, 0.0f);
            graphics.method_51448().method_22907(class_7833.field_40718.rotationDegrees(90.0f + (float)(180.0 * (Double)this.rotatingAnimator.value())));
            graphics.method_25302(CONFIG_TEX, (int)(-center), (int)(-center), 33, isHovered ? 18 : 0, 9, 9);
            graphics.method_51448().method_22909();
        }
        graphics.method_25296(x, y, x + sideWidth, y + entryHeight, ColorUtil.color(255, 255, 255, 255), ColorUtil.color(255, 255, 255, 255));
        if ((Double)this.expandAnimator.value() != 0.0) {
            ScissorsHandler.scissor(new Rectangle(x, y, entryWidth, (int)((double)this.getItemHeight() * (Double)this.expandAnimator.value())));
            int yy = y + this.top;
            for (LineRenderer line : this.lineRenderers) {
                int lineHeight = line.render(graphics, -1, yy, x + sideWidth + 5, entryWidth - (sideWidth + 5), entryHeight, mouseX, mouseY, isHovered, delta, this.textRenderer);
                Objects.requireNonNull(class_310.method_1551().field_1772);
                yy += lineHeight + 1;
            }
            ScissorsHandler.removeLastScissor();
            AbstractConfigScreen configScreen = this.getConfigScreen();
            if (style != null && configScreen != null) {
                graphics.method_51441(class_310.method_1551().field_1772, style, mouseX, mouseY);
            }
        }
        if ((Double)this.expandAnimator.value() < 0.1) {
            graphics.method_27534(this.textRenderer, this.getFieldName(), (int)((double)x + (double)entryWidth * 0.5), y + 6, ColorUtil.color((int)(255.0 - 255.0 * ((Double)this.expandAnimator.value() * 10.0)), 255, 255, 255));
        }
    }

    public int getItemHeight() {
        int height = 0;
        for (LineRenderer lineRenderer : this.lineRenderers) {
            if (lineRenderer.saveRectangle != null) {
                height += lineRenderer.saveRectangle.height + 1;
                continue;
            }
            height += lineRenderer.line.height(this.textRenderer) + 1;
        }
        return Math.min(Math.max((int)((double)height * (Double)this.expandAnimator.value()) + ((Double)this.expandAnimator.value() == 1.0 ? 3 + this.bottom : 24), 24), height + 3 + this.bottom);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            class_2583 style = this.getTextAt(mouseX, mouseY);
            AbstractConfigScreen configScreen = this.getConfigScreen();
            if (configScreen != null && configScreen.method_25430(style)) {
                return true;
            }
            if (this.mainRectangle.contains(mouseX, mouseY) && this.canExpand && !this.hoverdText) {
                this.setExpanded(!this.isExpanded());
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Nullable
    protected class_2583 getTextAt(double x, double y) {
        if (this.mainRectangle.contains(x, y) && this.isExpanded()) {
            List<LineRenderer> lines = this.lineRenderers;
            int size = lines.size();
            if (size == 0) {
                return null;
            }
            int low = 0;
            int high = size - 1;
            int candidate = -1;
            while (low <= high) {
                int mid = low + high >>> 1;
                LineRenderer line = lines.get(mid);
                me.shedaniel.math.Rectangle rect = line.saveRectangle;
                if (rect == null) break;
                double lineY = rect.y;
                if (lineY <= y) {
                    candidate = mid;
                    low = mid + 1;
                    continue;
                }
                high = mid - 1;
            }
            if (candidate != -1) {
                LineRenderer line = lines.get(candidate);
                me.shedaniel.math.Rectangle rect = line.saveRectangle;
                if (rect != null && rect.contains(x, y)) {
                    class_5481 text = line.line.text.method_30937();
                    return text != class_5481.field_26385 ? this.textRenderer.method_27527().method_30876(text, rect.x) : class_2583.field_24360;
                }
            }
            return null;
        }
        return null;
    }

    public boolean isMouseInside(int mouseX, int mouseY, int x, int y, int entryWidth, int entryHeight) {
        return false;
    }

    public Object getValue() {
        return null;
    }

    public Optional<Object> getDefaultValue() {
        return Optional.empty();
    }

    @NotNull
    public List<? extends class_364> method_25396() {
        return Collections.emptyList();
    }

    public List<? extends class_6379> narratables() {
        return Collections.emptyList();
    }

    static {
        CONFIG_TEX = new class_2960("cloth-config2", "textures/gui/cloth_config.png");
        DISABLED_COLOR = Objects.requireNonNull(class_124.field_1063.method_532());
    }

    public static class LineRenderer {
        public Line line;
        public me.shedaniel.math.Rectangle saveRectangle;

        LineRenderer(Line line) {
            this.line = line;
        }

        public static LineRenderer of(Line line) {
            return new LineRenderer(line);
        }

        public int render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta, class_327 font) {
            List splitLines = font.method_1728((class_5348)this.line.text, entryWidth - 8);
            int lineHeight = splitLines.size() * this.line.height(font) + (splitLines.size() - 1);
            this.saveRectangle = new me.shedaniel.math.Rectangle(x, y, this.line.width(font), lineHeight);
            int yOffset = 0;
            for (class_5481 text : splitLines) {
                graphics.method_51448().method_22903();
                graphics.method_51448().method_46416((float)(x + (this.line.center ? -7 : 0)), (float)(y + yOffset), 0.0f);
                graphics.method_51448().method_22905(this.line.scale.x, this.line.scale.y, 1.0f);
                if (this.line.center) {
                    graphics.method_35719(font, text, (int)((double)(entryWidth + 7) * 0.5 / (double)this.line.scale.x), 0, this.line.color);
                } else {
                    graphics.method_51430(font, text, (int)((float)entryWidth * this.line.left), 0, this.line.color, false);
                }
                yOffset += this.line.height(font);
                graphics.method_51448().method_22909();
            }
            return lineHeight;
        }
    }
}

