/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.minecraft;

import com.mojang.blaze3d.platform.GlStateManager;
import io.homo.superresolution.core.gl.utils.GlBlitRenderer;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import net.minecraft.class_276;

public class FrameBufferRenderTargetAdapter
extends class_276 {
    private IFrameBuffer frameBuffer;

    FrameBufferRenderTargetAdapter(IFrameBuffer frameBuffer) {
        super(frameBuffer.getDepthTextureFormat() != null);
        this.frameBuffer = frameBuffer;
        this.updateState();
    }

    protected static FrameBufferRenderTargetAdapter ofRenderTarget(IFrameBuffer frameBuffer) {
        return new FrameBufferRenderTargetAdapter(frameBuffer);
    }

    public FrameBufferRenderTargetAdapter bindFrameBuffer(IFrameBuffer frameBuffer) {
        this.frameBuffer = frameBuffer;
        return this;
    }

    private void updateState() {
        this.field_1482 = this.frameBuffer.getWidth();
        this.field_1481 = this.frameBuffer.getHeight();
        this.field_1480 = this.frameBuffer.getWidth();
        this.field_1477 = this.frameBuffer.getHeight();
        this.field_1476 = this.frameBuffer.getFrameBufferId();
        this.field_1475 = this.frameBuffer.getTextureId(FrameBufferAttachmentType.COLOR);
        this.field_1474 = this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH_STENCIL) == -1 ? this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH) : this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH_STENCIL);
    }

    public void method_35610() {
        this.updateState();
        this.frameBuffer.bind(FrameBufferBindPoint.READ);
    }

    public void method_1242() {
        this.updateState();
        this.frameBuffer.unbind(FrameBufferBindPoint.READ);
    }

    public void method_1235(boolean setViewport) {
        this.updateState();
        this.frameBuffer.bind(FrameBufferBindPoint.WRITE, setViewport);
    }

    public void method_1240() {
        this.updateState();
        this.frameBuffer.unbind(FrameBufferBindPoint.WRITE);
    }

    public void method_1236(float red, float green, float blue, float alpha) {
        this.updateState();
        this.frameBuffer.method_1236(red, green, blue, alpha);
    }

    public void method_1237(int width, int height) {
        this.updateState();
        GlBlitRenderer.blitToScreen(this.frameBuffer.getTextureId(FrameBufferAttachmentType.COLOR), this.field_1480, this.field_1477);
    }

    public void blitAndBlendToScreen(int width, int height) {
        this.updateState();
        this.method_1237(width, height);
    }

    public void method_1230(boolean a) {
        this.updateState();
        this.frameBuffer.clearFrameBuffer();
    }

    public void method_1234(int width, int height, boolean clearError) {
    }

    public void method_1231(int width, int height, boolean clearError) {
        this.updateState();
    }

    public int method_30277() {
        this.updateState();
        return this.frameBuffer.getTextureId(FrameBufferAttachmentType.COLOR);
    }

    public int method_30278() {
        this.updateState();
        return this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH_STENCIL) == -1 ? this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH) : this.frameBuffer.getTextureId(FrameBufferAttachmentType.DEPTH_STENCIL);
    }

    public void method_1238() {
        this.updateState();
    }

    public void method_29329(class_276 otherTarget) {
        this.updateState();
        GlStateManager._glBindFramebuffer((int)36008, (int)otherTarget.field_1476);
        GlStateManager._glBindFramebuffer((int)36009, (int)this.field_1476);
        GlStateManager._glBlitFrameBuffer((int)0, (int)0, (int)otherTarget.field_1482, (int)otherTarget.field_1481, (int)0, (int)0, (int)this.field_1482, (int)this.field_1481, (int)256, (int)9728);
        GlStateManager._glBindFramebuffer((int)36160, (int)0);
    }
}

