/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.common.upscale.sgsr.v1;

import io.homo.superresolution.api.AbstractAlgorithm;
import io.homo.superresolution.common.minecraft.MinecraftRenderHandle;
import io.homo.superresolution.common.upscale.DispatchResource;
import io.homo.superresolution.core.gl.framebuffer.GlFrameBuffer;
import io.homo.superresolution.core.gl.framebuffer.GlFrameBufferAttachment;
import io.homo.superresolution.core.gl.pipeline.GlPipeline;
import io.homo.superresolution.core.gl.pipeline.GlPipelineJobBuilders;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceAccess;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceDescription;
import io.homo.superresolution.core.gl.pipeline.resource.GlPipelineResourceType;
import io.homo.superresolution.core.gl.shader.AbstractGlShaderProgram;
import io.homo.superresolution.core.gl.shader.GlGeneralShaderProgram;
import io.homo.superresolution.core.gl.texture.GlTexture2D;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferTextureAdapter;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.impl.shader.ShaderSource;
import io.homo.superresolution.core.impl.texture.TextureFormat;

public class Sgsr1
extends AbstractAlgorithm {
    private GlPipeline pipeline;
    private AbstractGlShaderProgram sgsrShader;

    @Override
    public void init() {
        this.input = MinecraftRenderHandle.getRenderTarget();
        GlFrameBuffer output_ = new GlFrameBuffer();
        output_.addAttachment(new GlFrameBufferAttachment(GlFrameBufferAttachment.FrameBufferAttachmentType.COLOR, GlTexture2D.create(MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight(), TextureFormat.RGBA8)));
        this.output = output_;
        this.sgsrShader = ((GlGeneralShaderProgram)GlGeneralShaderProgram.create().addShaderSource(new ShaderSource(ShaderSource.Type.FRAGMENT, "/shader/sgsr/v1/sgsr1_shader.frag.glsl", true)).addShaderSource(new ShaderSource(ShaderSource.Type.VERTEX, "/shader/sgsr/v1/sgsr1_shader.vert.glsl", true)).setShaderName("SGSRV1").addDefineText("UseEdgeDirection", "").build()).compileShader();
        this.pipeline = new GlPipeline().addJob("main", GlPipelineJobBuilders.graphics(this.sgsrShader).resource(GlPipelineResourceDescription.createTextureResource(GlPipelineResourceType.Sampler2D, "ps0", FrameBufferTextureAdapter.ofColor(this.input), GlPipelineResourceAccess.READ, null, 0)).targetFramebuffer(this.output).build());
        this.resize(MinecraftRenderHandle.getScreenWidth(), MinecraftRenderHandle.getScreenHeight());
    }

    @Override
    public boolean dispatch(DispatchResource dispatchResource) {
        this.pipeline.scheduleJobs();
        this.sgsrShader.use();
        this.sgsrShader.uniforms().safeVec2("renderSize").value(dispatchResource.renderWidth(), dispatchResource.renderHeight()).safeVec2("renderSizeRcp").value(1.0f / (float)dispatchResource.renderWidth(), 1.0f / (float)dispatchResource.renderHeight()).safeFloat("EdgeThreshold").value(Float.valueOf(0.03137255f)).safeFloat("EdgeSharpness").value(Float.valueOf(2.0f));
        this.pipeline.executeJobs();
        this.sgsrShader.clear();
        return false;
    }

    @Override
    public void resize(int width, int height) {
        this.output.resizeFrameBuffer(width, height);
    }

    @Override
    public void destroy() {
        this.output.destroy();
        this.sgsrShader.destroy();
    }

    @Override
    public IFrameBuffer getOutputFrameBuffer() {
        return super.getOutputFrameBuffer();
    }
}

