/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gl.buffer;

import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.impl.IUniformStruct;
import java.nio.ByteBuffer;

public class GlUniformBuffer<T extends IUniformStruct> {
    private final int bufferSize;
    private final T struct;
    private int uboId;
    private volatile boolean isClosed;

    public GlUniformBuffer(T struct) {
        this.struct = struct;
        this.bufferSize = struct.sizeof();
        this.validateBufferSize(this.bufferSize);
        this.uboId = Gl.DSA.createBuffer();
        this.initializeBuffer();
    }

    public T struct() {
        return this.struct;
    }

    private void initializeBuffer() {
        ByteBuffer data = this.struct.container();
        Gl.DSA.bufferData(this.uboId, 35345, data, 35048);
    }

    public void update() {
        this.checkNotClosed();
        this.validateStructSize();
        ByteBuffer data = this.struct.container();
        Gl.DSA.bufferSubData(this.uboId, 0, data);
    }

    public void partialUpdate(int offset, ByteBuffer data) {
        this.checkNotClosed();
        this.validateOffset(offset, data.remaining());
        Gl.DSA.bufferSubData(this.uboId, offset, data);
    }

    public void bind(int bindingPoint) {
        this.checkNotClosed();
        Gl.DSA.bindBufferBase(35345, bindingPoint, this.uboId);
    }

    public synchronized void delete() {
        if (!this.isClosed) {
            Gl.DSA.deleteBuffer(this.uboId);
            this.uboId = 0;
            this.isClosed = true;
        }
    }

    private void checkNotClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("UBO already deleted");
        }
    }

    private void validateBufferSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size must be positive");
        }
    }

    private void validateStructSize() {
        if (this.struct.sizeof() != this.bufferSize) {
            throw new IllegalArgumentException("Struct size mismatch! Expected: " + this.bufferSize + ", Actual: " + this.struct.sizeof());
        }
    }

    private void validateOffset(int offset, int dataSize) {
        if (offset < 0 || offset + dataSize > this.bufferSize) {
            throw new IndexOutOfBoundsException("Invalid update range: offset=" + offset + ", dataSize=" + dataSize + ", bufferSize=" + this.bufferSize);
        }
    }

    public int getId() {
        return this.uboId;
    }

    public int getSize() {
        return this.bufferSize;
    }
}

