/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gl.framebuffer;

import io.homo.superresolution.common.minecraft.RenderTargetCache;
import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.gl.framebuffer.GlFrameBufferAttachment;
import io.homo.superresolution.core.gl.texture.GlTexture2D;
import io.homo.superresolution.core.impl.IDebuggableObject;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferAttachmentType;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import io.homo.superresolution.core.impl.texture.ITexture;
import io.homo.superresolution.core.impl.texture.TextureFormat;
import java.util.ArrayList;
import net.minecraft.class_276;
import org.jetbrains.annotations.NotNull;

public class GlFrameBuffer
implements IFrameBuffer,
IDebuggableObject {
    private final float[] clearColor = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
    private final ArrayList<GlFrameBufferAttachment> attachments = new ArrayList();
    private GlFrameBufferAttachment colorAttachment = null;
    private GlFrameBufferAttachment depthAttachment = null;
    private GlFrameBufferAttachment depthStencilAttachment = null;
    private int frameBufferId = Gl.DSA.createFramebuffer();
    private int width;
    private int height;

    @NotNull
    public static GlFrameBuffer create(TextureFormat colorTextureFormat, TextureFormat depthTextureFormat, int width, int height) {
        GlFrameBuffer frameBuffer = new GlFrameBuffer();
        frameBuffer.width = width;
        frameBuffer.height = height;
        frameBuffer.addAttachment(new GlFrameBufferAttachment(GlFrameBufferAttachment.FrameBufferAttachmentType.COLOR, GlTexture2D.create(width, height, colorTextureFormat)));
        if (depthTextureFormat != null) {
            frameBuffer.addAttachment(new GlFrameBufferAttachment(depthTextureFormat.isStencil() ? GlFrameBufferAttachment.FrameBufferAttachmentType.DEPTH_STENCIL : GlFrameBufferAttachment.FrameBufferAttachmentType.DEPTH, GlTexture2D.create(width, height, depthTextureFormat)));
        }
        frameBuffer.validate();
        return frameBuffer;
    }

    @NotNull
    public static GlFrameBuffer create(ITexture colorTexture, ITexture depthTexture, int width, int height) {
        GlFrameBuffer frameBuffer = new GlFrameBuffer();
        frameBuffer.width = width;
        frameBuffer.height = height;
        frameBuffer.addAttachment(new GlFrameBufferAttachment(GlFrameBufferAttachment.FrameBufferAttachmentType.COLOR, colorTexture));
        if (depthTexture != null) {
            frameBuffer.addAttachment(new GlFrameBufferAttachment(depthTexture.getTextureFormat().isStencil() ? GlFrameBufferAttachment.FrameBufferAttachmentType.DEPTH_STENCIL : GlFrameBufferAttachment.FrameBufferAttachmentType.DEPTH, depthTexture));
        }
        frameBuffer.validate();
        return frameBuffer;
    }

    @NotNull
    public static GlFrameBuffer create(int width, int height) {
        return GlFrameBuffer.create(GlTexture2D.create(width, height, TextureFormat.RGBA8), GlTexture2D.create(width, height, TextureFormat.DEPTH24), width, height);
    }

    @NotNull
    public static GlFrameBuffer create() {
        return GlFrameBuffer.create(GlTexture2D.create(1, 1, TextureFormat.RGBA8), GlTexture2D.create(1, 1, TextureFormat.DEPTH24), 1, 1);
    }

    @NotNull
    public static GlFrameBuffer create(ITexture colorTexture, ITexture depthTexture) {
        return GlFrameBuffer.create(colorTexture, depthTexture, colorTexture.getWidth(), colorTexture.getHeight());
    }

    public static int resolveBindTarget(FrameBufferBindPoint point) {
        return switch (point) {
            default -> throw new IncompatibleClassChangeError();
            case FrameBufferBindPoint.READ -> 36008;
            case FrameBufferBindPoint.WRITE -> 36009;
            case FrameBufferBindPoint.ALL -> 36160;
        };
    }

    public void addAttachment(GlFrameBufferAttachment attachment) {
        if (attachment.type == GlFrameBufferAttachment.FrameBufferAttachmentType.COLOR) {
            this.colorAttachment = attachment;
        } else if (attachment.type == GlFrameBufferAttachment.FrameBufferAttachmentType.DEPTH) {
            this.depthAttachment = attachment;
        } else {
            this.depthStencilAttachment = attachment;
        }
        Gl.DSA.framebufferTexture(this.frameBufferId, attachment.type.attachmentId(), attachment.texture.getTextureId(), 0);
        this.attachments.add(attachment);
        this.updateDebugLabel(this.getDebugLabel());
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint, boolean setViewport) {
        int target = GlFrameBuffer.resolveBindTarget(bindPoint);
        Gl.glBindFramebuffer(target, this.frameBufferId);
        if (setViewport) {
            Gl.glViewport(0, 0, this.width, this.height);
        }
    }

    @Override
    public void bind(FrameBufferBindPoint bindPoint) {
        this.bind(bindPoint, true);
    }

    @Override
    public void unbind(FrameBufferBindPoint bindPoint) {
        Gl.glBindFramebuffer(GlFrameBuffer.resolveBindTarget(bindPoint), 0);
    }

    @Override
    public int getTextureId(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new IncompatibleClassChangeError();
            case FrameBufferAttachmentType.COLOR -> {
                if (this.colorAttachment != null) {
                    yield this.colorAttachment.texture.getTextureId();
                }
                yield -1;
            }
            case FrameBufferAttachmentType.DEPTH -> {
                if (this.depthAttachment != null) {
                    yield this.depthAttachment.texture.getTextureId();
                }
                yield -1;
            }
            case FrameBufferAttachmentType.DEPTH_STENCIL -> {
                if (this.depthStencilAttachment != null) {
                    yield this.depthStencilAttachment.texture.getTextureId();
                }
                yield -1;
            }
            case FrameBufferAttachmentType.ANY_DEPTH -> this.depthStencilAttachment != null ? this.depthStencilAttachment.texture.getTextureId() : (this.depthAttachment != null ? this.depthAttachment.texture.getTextureId() : -1);
        };
    }

    @Override
    public ITexture getTexture(FrameBufferAttachmentType attachmentType) {
        return switch (attachmentType) {
            default -> throw new IncompatibleClassChangeError();
            case FrameBufferAttachmentType.COLOR -> {
                if (this.colorAttachment != null) {
                    yield this.colorAttachment.texture;
                }
                yield null;
            }
            case FrameBufferAttachmentType.DEPTH -> {
                if (this.depthAttachment != null) {
                    yield this.depthAttachment.texture;
                }
                yield null;
            }
            case FrameBufferAttachmentType.DEPTH_STENCIL -> {
                if (this.depthStencilAttachment != null) {
                    yield this.depthStencilAttachment.texture;
                }
                yield null;
            }
            case FrameBufferAttachmentType.ANY_DEPTH -> this.depthStencilAttachment != null ? this.depthStencilAttachment.texture : (this.depthAttachment != null ? this.depthAttachment.texture : null);
        };
    }

    @Override
    public void destroy() {
        if (this.frameBufferId != -1) {
            Gl.DSA.deleteFramebuffer(this.frameBufferId);
            this.frameBufferId = -1;
        }
    }

    public void validate() {
        int status = Gl.DSA.checkNamedFramebufferStatus(this.frameBufferId, 36160);
        if (status != 36053) {
            String errorDesc = switch (status) {
                case 33305 -> "UNDEFINED";
                case 36054 -> "INCOMPLETE_ATTACHMENT";
                case 36055 -> "MISSING_ATTACHMENT";
                case 36061 -> "UNSUPPORTED_FORMAT";
                default -> "UNKNOWN_ERROR";
            };
            throw new IllegalStateException("FBO validation failed: " + errorDesc + " (0x" + Integer.toHexString(status) + ")");
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void clearFrameBuffer() {
        if (this.colorAttachment != null) {
            Gl.DSA.clearNamedFramebufferfv(this.frameBufferId, 6144, 0, this.clearColor);
        }
        if (this.depthAttachment != null) {
            Gl.DSA.clearNamedFramebufferfv(this.frameBufferId, 6145, 0, new float[]{1.0f});
        }
        if (this.depthStencilAttachment != null) {
            Gl.DSA.clearNamedFramebufferfi(this.frameBufferId, 34041, 0, 1.0f, 0);
        }
    }

    @Override
    public int getFrameBufferId() {
        return this.frameBufferId;
    }

    @Override
    public void method_1236(float r, float g, float b, float a) {
        this.clearColor[0] = r;
        this.clearColor[1] = g;
        this.clearColor[2] = b;
        this.clearColor[3] = a;
    }

    @Override
    public TextureFormat getColorTextureFormat() {
        if (this.colorAttachment == null) {
            return null;
        }
        return this.colorAttachment.texture.getTextureFormat();
    }

    @Override
    public TextureFormat getDepthTextureFormat() {
        if (this.depthAttachment != null) {
            return this.depthAttachment.texture.getTextureFormat();
        }
        if (this.depthStencilAttachment != null) {
            return this.depthStencilAttachment.texture.getTextureFormat();
        }
        return null;
    }

    @Override
    public class_276 asMcRenderTarget() {
        return RenderTargetCache.cacheOf(this);
    }

    @Override
    public void resizeFrameBuffer(int width, int height) {
        for (GlFrameBufferAttachment attachment : this.attachments) {
            attachment.texture.resize(width, height);
        }
        Gl.DSA.deleteFramebuffer(this.frameBufferId);
        this.frameBufferId = Gl.DSA.createFramebuffer();
        this.width = width;
        this.height = height;
        ArrayList<GlFrameBufferAttachment> temp = new ArrayList<GlFrameBufferAttachment>(this.attachments);
        this.attachments.clear();
        for (GlFrameBufferAttachment attachment : temp) {
            this.addAttachment(attachment);
        }
        this.validate();
        this.updateDebugLabel(this.getDebugLabel());
    }

    @Override
    public String getDebugLabel() {
        return "FrameBuffer-%s|Color-%s|Depth-%s|DepthStencil-%s".formatted(this.getFrameBufferId(), this.colorAttachment != null ? this.colorAttachment.texture.string() : "None", this.depthAttachment != null ? this.depthAttachment.texture.string() : "None", this.depthStencilAttachment != null ? this.depthStencilAttachment.texture.string() : "None");
    }

    @Override
    public void updateDebugLabel(String newLabel) {
        Gl.glSafeObjectLabel(36160, this.getFrameBufferId(), newLabel);
    }
}

