/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gl.pipeline.jobs;

import io.homo.superresolution.core.gl.GlState;
import io.homo.superresolution.core.gl.pipeline.jobs.GlPipelineJob;
import io.homo.superresolution.core.gl.pipeline.jobs.GlPipelineJobDispatchResource;
import io.homo.superresolution.core.gl.pipeline.jobs.GlPipelineJobType;
import io.homo.superresolution.core.gl.shader.AbstractGlShaderProgram;
import io.homo.superresolution.core.gl.vertex.GlVertexArray;
import io.homo.superresolution.core.gl.vertex.GlVertexBuffer;
import io.homo.superresolution.core.impl.framebuffer.FrameBufferBindPoint;
import io.homo.superresolution.core.impl.framebuffer.IFrameBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class GlPipelineGraphicsJob
extends GlPipelineJob {
    public IFrameBuffer targetFrameBuffer;
    public AbstractGlShaderProgram program;

    public void setTargetFrameBuffer(IFrameBuffer frameBuffer) {
        if (this.type != GlPipelineJobType.Graphics) {
            throw new IllegalStateException("Only Graphics jobs can set FrameBuffer targets!");
        }
        this.targetFrameBuffer = frameBuffer;
    }

    @Override
    public void schedule(GlPipelineJobDispatchResource dispatchResource) {
        this.setupResource();
    }

    @Override
    public void execute(GlPipelineJobDispatchResource dispatchResource) {
        try (GlState ignored = new GlState();){
            if (this.targetFrameBuffer != null) {
                this.targetFrameBuffer.bind(FrameBufferBindPoint.WRITE, true);
            }
            this.program.use();
            try (GlVertexArray vao = new GlVertexArray();
                 GlVertexBuffer vbo = new GlVertexBuffer();){
                float[] vertices = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 0.0f, 1.0f};
                vao.bind();
                vbo.bind(34962);
                vbo.uploadData(vertices, 35044);
                int stride = 16;
                GL20.glEnableVertexAttribArray((int)0);
                GL20.glVertexAttribPointer((int)0, (int)2, (int)5126, (boolean)false, (int)stride, (long)0L);
                GL20.glEnableVertexAttribArray((int)1);
                GL20.glVertexAttribPointer((int)1, (int)2, (int)5126, (boolean)false, (int)stride, (long)8L);
                GL11.glDrawArrays((int)6, (int)0, (int)4);
            }
        }
    }
}

