/*
 * Decompiled with CFR 0.152.
 */
package io.homo.superresolution.core.gl.texture;

import io.homo.superresolution.core.gl.Gl;
import io.homo.superresolution.core.gl.GlState;
import io.homo.superresolution.core.gl.texture.GlTextureView;
import io.homo.superresolution.core.gl.utils.GlBlitRenderer;
import io.homo.superresolution.core.impl.IDebuggableObject;
import io.homo.superresolution.core.impl.texture.ITexture;
import io.homo.superresolution.core.impl.texture.TextureFormat;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.lwjgl.opengl.GL43;
import org.lwjgl.system.MemoryUtil;

public class GlTexture2D
implements ITexture,
IDebuggableObject {
    public static final int AUTO_MIPMAP_LEVEL = 0;
    private static final int MAX_MIPMAP_LEVELS = 16;
    private static final int DEFAULT_ALIGNMENT = 4;
    private final int format;
    private final Map<Integer, GlTextureView> mipViews = new ConcurrentHashMap<Integer, GlTextureView>();
    private int id;
    private int width;
    private int height;
    private int mipmapLevel;
    private boolean mipmapEnabled;

    public GlTexture2D(int width, int height, int format, int mipmapLevel) {
        this.validateDimensions(width, height);
        this.format = format;
        this.width = width;
        this.height = height;
        this.configureMipmap(mipmapLevel);
        this.initializeTexture();
    }

    public static GlTexture2D create(int width, int height, TextureFormat format) {
        return GlTexture2D.create(width, height, format, -1);
    }

    public static GlTexture2D create(int width, int height, TextureFormat format, int mipmapLevel) {
        return new GlTexture2D(width, height, format.gl(), mipmapLevel);
    }

    public static void blitToScreen(int srcWidth, int srcHeight, int viewWidth, int viewHeight, int id) {
        GlBlitRenderer.blitToScreen(id, viewWidth, viewHeight);
    }

    public int getMipmapLevel() {
        return this.mipmapLevel;
    }

    public GlTextureView getMipView(int level) {
        return this.mipViews.computeIfAbsent(level, this::createMipView);
    }

    private GlTextureView createMipView(int level) {
        try (GlState ignored = new GlState();){
            if (level < 0 || level > this.mipmapLevel) {
                throw new IllegalArgumentException("Invalid mip level: " + level);
            }
            GlTextureView glTextureView = GlTextureView.create(this, 3553, level, 1, 0, 1);
            return glTextureView;
        }
    }

    private void configureTextureParameters() {
        if (this.format != TextureFormat.R32UI.gl()) {
            Gl.DSA.textureParameteri(this.id, 10241, this.mipmapEnabled ? 9987 : 9728);
        } else {
            Gl.DSA.textureParameteri(this.id, 10241, this.mipmapEnabled ? 9984 : 9728);
        }
        Gl.DSA.textureParameteri(this.id, 10240, 9728);
        Gl.DSA.textureParameteri(this.id, 10242, 33071);
        Gl.DSA.textureParameteri(this.id, 10243, 33071);
        Gl.DSA.textureParameteri(this.id, 33084, 0);
        if (this.mipmapEnabled) {
            Gl.DSA.textureParameteri(this.id, 33085, this.mipmapLevel);
        }
    }

    private void allocateTextureStorage() {
        int levels = this.mipmapEnabled ? this.mipmapLevel + 1 : 1;
        Gl.DSA.textureStorage2D(this.id, levels, this.format, this.width, this.height);
    }

    private void initializeTexture() {
        try (GlState ignored = new GlState();){
            if (this.id >= 0) {
                Gl.DSA.deleteTexture(this.id);
            }
            this.id = Gl.DSA.createTexture2D();
            this.configureTextureParameters();
            this.allocateTextureStorage();
            this.updateDebugLabel(this.getDebugLabel());
        }
    }

    public void uploadData(int mipLevel, int xoffset, int yoffset, int width, int height, int format, int type, ByteBuffer data, int alignment) {
        GL43.glPixelStorei((int)3317, (int)alignment);
        Gl.DSA.textureSubImage2D(this.id, mipLevel, xoffset, yoffset, width, height, format, type, MemoryUtil.memAddress((ByteBuffer)data));
    }

    public void uploadData(int format, int type, ByteBuffer data) {
        this.uploadData(0, 0, 0, this.width, this.height, format, type, data, 4);
    }

    private void validateDimensions(int width, int height) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid texture dimensions: " + width + "x" + height);
        }
    }

    public void copyFromFBO(int srcFbo) {
        GL43.glBindFramebuffer((int)36160, (int)srcFbo);
        GL43.glBindTexture((int)3553, (int)this.id);
        Gl.DSA.copyTextureSubImage2D(this.id, 0, 0, 0, 0, 0, this.width, this.height);
        GL43.glBindFramebuffer((int)36160, (int)0);
    }

    public void copyFromTex(int srcTex) {
        GL43.glCopyImageSubData((int)srcTex, (int)3553, (int)0, (int)0, (int)0, (int)0, (int)this.id, (int)3553, (int)0, (int)0, (int)0, (int)0, (int)this.width, (int)this.height, (int)1);
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public TextureFormat getTextureFormat() {
        return TextureFormat.fromGl(this.format);
    }

    public void configureMipmap(int requestedLevel) {
        this.mipmapEnabled = requestedLevel >= 0;
        this.mipmapLevel = this.calculateActualMipLevel(requestedLevel);
    }

    private int calculateActualMipLevel(int requestedLevel) {
        if (!this.mipmapEnabled) {
            return 0;
        }
        if (requestedLevel == 0) {
            return this.calculateMaxMipLevel();
        }
        return Math.min(requestedLevel, 16);
    }

    private int calculateMaxMipLevel() {
        int maxDimension = Math.max(this.width, this.height);
        return (int)(Math.log(maxDimension) / Math.log(2.0));
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public String getDebugLabel() {
        return this.string();
    }

    @Override
    public void updateDebugLabel(String newLabel) {
        Gl.glSafeObjectLabel(5890, this.getTextureId(), this.getDebugLabel());
    }

    public void generateMipmap() {
        Gl.DSA.generateTextureMipmap(this.id);
    }

    @Override
    public void destroy() {
        this.mipViews.values().forEach(GlTextureView::destroy);
        this.mipViews.clear();
        Gl.DSA.deleteTexture(this.id);
    }

    @Override
    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
        this.initializeTexture();
    }
}

